/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32.symmetric;

import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;

public final class EWAHPointer32
implements Comparable {
    private int endrun;
    private final int pos;
    private boolean isLiteral;
    private boolean value;
    private boolean dead = false;
    public final IteratingBufferedRunningLengthWord32 iterator;

    public EWAHPointer32(int n2, IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32, int n3) {
        this.pos = n3;
        this.iterator = iteratingBufferedRunningLengthWord32;
        if (this.iterator.getRunningLength() > 0) {
            this.endrun = n2 + this.iterator.getRunningLength();
            this.isLiteral = false;
            this.value = this.iterator.getRunningBit();
        } else if (this.iterator.getNumberOfLiteralWords() > 0) {
            this.isLiteral = true;
            this.endrun = n2 + this.iterator.getNumberOfLiteralWords();
        } else {
            this.endrun = n2;
            this.dead = true;
        }
    }

    public int endOfRun() {
        return this.endrun;
    }

    public int beginOfRun() {
        if (this.isLiteral) {
            return this.endrun - this.iterator.getNumberOfLiteralWords();
        }
        return this.endrun - this.iterator.getRunningLength();
    }

    public void parseNextRun() {
        if (this.isLiteral || this.iterator.getNumberOfLiteralWords() == 0) {
            this.iterator.discardFirstWords(this.iterator.size());
            if (this.iterator.getRunningLength() > 0) {
                this.endrun += this.iterator.getRunningLength();
                this.isLiteral = false;
                this.value = this.iterator.getRunningBit();
            } else if (this.iterator.getNumberOfLiteralWords() > 0) {
                this.isLiteral = true;
                this.endrun += this.iterator.getNumberOfLiteralWords();
            } else {
                this.dead = true;
            }
        } else {
            this.isLiteral = true;
            this.endrun += this.iterator.getNumberOfLiteralWords();
        }
    }

    public boolean hasNoData() {
        return this.dead;
    }

    public void callbackUpdate(UpdateableBitmapFunction32 updateableBitmapFunction32) {
        if (this.dead) {
            updateableBitmapFunction32.setZero(this.pos);
        } else if (this.isLiteral) {
            updateableBitmapFunction32.setLiteral(this.pos);
        } else if (this.value) {
            updateableBitmapFunction32.setOne(this.pos);
        } else {
            updateableBitmapFunction32.setZero(this.pos);
        }
    }

    public int compareTo(EWAHPointer32 eWAHPointer32) {
        return this.endrun - eWAHPointer32.endrun;
    }
}

