/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class XORIt
implements CloneableIterator {
    EWAHCompressedBitmap32 buffer = new EWAHCompressedBitmap32();
    int[] hardbitmap;
    LinkedList ll;

    XORIt(LinkedList linkedList, int n2) {
        this.ll = linkedList;
        this.hardbitmap = new int[n2];
    }

    @Override
    public XORIt clone() {
        XORIt xORIt = (XORIt)super.clone();
        xORIt.buffer = this.buffer.clone();
        xORIt.hardbitmap = (int[])this.hardbitmap.clone();
        xORIt.ll = (LinkedList)this.ll.clone();
        return xORIt;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator32 next() {
        this.buffer.clear();
        int n2 = 0;
        Iterator iterator = this.ll.iterator();
        while (iterator.hasNext()) {
            IteratingRLW32 iteratingRLW32 = (IteratingRLW32)iterator.next();
            if (iteratingRLW32.size() > 0) {
                int n3 = IteratorAggregation32.inplacexor(this.hardbitmap, iteratingRLW32);
                if (n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            iterator.remove();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.addWord(this.hardbitmap[i2]);
        }
        Arrays.fill(this.hardbitmap, 0);
        return this.buffer.getEWAHIterator();
    }
}

