/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.Buffer32;

public final class RunningLengthWord32
implements Cloneable {
    final Buffer32 buffer;
    int position;
    public static final int RUNNING_LENGTH_BITS = 16;
    private static final int LITERAL_BITS = 15;
    public static final int LARGEST_LITERAL_COUNT = Short.MAX_VALUE;
    public static final int LARGEST_RUNNING_LENGTH_COUNT = 65535;
    private static final int RUNNING_LENGTH_PLUS_RUNNING_BIT = 131071;
    private static final int SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = 131070;
    private static final int NOT_RUNNING_LENGTH_PLUS_RUNNING_BIT = -131072;
    private static final int NOT_SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = -131071;

    RunningLengthWord32(Buffer32 buffer32, int n2) {
        this.buffer = buffer32;
        this.position = n2;
    }

    public int getNumberOfLiteralWords() {
        return RunningLengthWord32.getNumberOfLiteralWords(this.buffer, this.position);
    }

    static int getNumberOfLiteralWords(Buffer32 buffer32, int n2) {
        return buffer32.getWord(n2) >>> 17;
    }

    public boolean getRunningBit() {
        return RunningLengthWord32.getRunningBit(this.buffer, this.position);
    }

    static boolean getRunningBit(Buffer32 buffer32, int n2) {
        return (buffer32.getWord(n2) & 1) != 0;
    }

    public int getRunningLength() {
        return RunningLengthWord32.getRunningLength(this.buffer, this.position);
    }

    static int getRunningLength(Buffer32 buffer32, int n2) {
        return buffer32.getWord(n2) >>> 1 & 0xFFFF;
    }

    public void setNumberOfLiteralWords(int n2) {
        RunningLengthWord32.setNumberOfLiteralWords(this.buffer, this.position, n2);
    }

    static void setNumberOfLiteralWords(Buffer32 buffer32, int n2, int n3) {
        buffer32.orWord(n2, -131072);
        buffer32.andWord(n2, n3 << 17 | 0x1FFFF);
    }

    public void setRunningBit(boolean bl2) {
        RunningLengthWord32.setRunningBit(this.buffer, this.position, bl2);
    }

    static void setRunningBit(Buffer32 buffer32, int n2, boolean bl2) {
        if (bl2) {
            buffer32.orWord(n2, 1);
        } else {
            buffer32.andWord(n2, -2);
        }
    }

    public void setRunningLength(int n2) {
        RunningLengthWord32.setRunningLength(this.buffer, this.position, n2);
    }

    static void setRunningLength(Buffer32 buffer32, int n2, int n3) {
        buffer32.orWord(n2, 131070);
        buffer32.andWord(n2, n3 << 1 | 0xFFFE0001);
    }

    public int size() {
        return this.getRunningLength() + this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public RunningLengthWord32 clone() {
        return (RunningLengthWord32)super.clone();
    }
}

