/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.ReverseEWAHIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;

final class ReverseIntIterator32
implements IntIterator {
    private final ReverseEWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator32(ReverseEWAHIterator32 reverseEWAHIterator32, int n2) {
        this.ewahIter = reverseEWAHIterator32;
        this.sizeInBits = n2;
        this.buffer = reverseEWAHIterator32.buffer();
        this.runningLength = n2 - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int n2;
        if (this.literalHasNext()) {
            int n3 = this.word & -this.word;
            n2 = this.literalPosition - Integer.bitCount(n3 - 1);
            this.word ^= n3;
        } else {
            n2 = this.position--;
        }
        this.hasNext = this.moveToPreviousRLW();
        return n2;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord32 runningLengthWord32) {
        int n2;
        this.wordLength = runningLengthWord32.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength -= 32 * (runningLengthWord32.getRunningLength() + this.wordLength);
        if (this.position == this.sizeInBits - 1 && (n2 = this.sizeInBits % 32) > 0) {
            this.runningLength += 32 - n2;
            if (this.wordLength > 0) {
                this.word = Integer.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
                this.word >>>= 32 - n2;
                this.literalPosition = this.position;
                this.position -= n2;
            }
        }
        this.runningBit = runningLengthWord32.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordLength > 0) {
            this.word = Integer.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            this.literalPosition = this.position;
            this.position -= 32;
        }
        return this.word != 0;
    }
}

