/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.AndIt;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.BufferedIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32$1;
import com.googlecode.javaewah32.ORIt;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public final class IteratorAggregation32 {
    public static final int DEFAULT_MAX_BUF_SIZE = 65536;

    private IteratorAggregation32() {
    }

    public static IteratingRLW32 not(IteratingRLW32 iteratingRLW32) {
        return new IteratorAggregation32$1(iteratingRLW32);
    }

    public static IteratingRLW32 bufferedand(IteratingRLW32 ... iteratingRLW32Array) {
        return IteratorAggregation32.bufferedand(65536, iteratingRLW32Array);
    }

    public static IteratingRLW32 bufferedand(int n2, IteratingRLW32 ... iteratingRLW32Array) {
        if (iteratingRLW32Array.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLW32Array.length == 1) {
            return iteratingRLW32Array[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLW32Array);
        return new BufferedIterator32(new AndIt(linkedList, n2));
    }

    public static IteratingRLW32 bufferedor(IteratingRLW32 ... iteratingRLW32Array) {
        return IteratorAggregation32.bufferedor(65536, iteratingRLW32Array);
    }

    public static IteratingRLW32 bufferedor(int n2, IteratingRLW32 ... iteratingRLW32Array) {
        if (iteratingRLW32Array.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLW32Array.length == 1) {
            return iteratingRLW32Array[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLW32Array);
        return new BufferedIterator32(new ORIt(linkedList, n2));
    }

    public static IteratingRLW32 bufferedxor(IteratingRLW32 ... iteratingRLW32Array) {
        return IteratorAggregation32.bufferedxor(65536, iteratingRLW32Array);
    }

    public static IteratingRLW32 bufferedxor(int n2, IteratingRLW32 ... iteratingRLW32Array) {
        if (iteratingRLW32Array.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLW32Array.length == 1) {
            return iteratingRLW32Array[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLW32Array);
        return new BufferedIterator32(new XORIt(linkedList, n2));
    }

    protected static void dischargeAsEmpty(BitmapStorage32 bitmapStorage32, IteratingRLW32 iteratingRLW32) {
        while (iteratingRLW32.size() > 0) {
            bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW32.size());
            iteratingRLW32.next();
        }
    }

    protected static int discharge(BitmapStorage32 bitmapStorage32, IteratingRLW32 iteratingRLW32, int n2) {
        int n3;
        int n4;
        for (n3 = 0; iteratingRLW32.size() > 0 && n3 < n2; n3 += n4) {
            int n5 = iteratingRLW32.getRunningLength();
            if (n5 > 0) {
                if (n5 + n3 > n2) {
                    n5 = n2 - n3;
                }
                bitmapStorage32.addStreamOfEmptyWords(iteratingRLW32.getRunningBit(), n5);
                n3 += n5;
            }
            if ((n4 = iteratingRLW32.getNumberOfLiteralWords()) + n3 > n2) {
                n4 = n2 - n3;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                bitmapStorage32.addWord(iteratingRLW32.getLiteralWordAt(i2));
            }
            iteratingRLW32.discardFirstWords(n4 + n5);
        }
        return n3;
    }

    protected static int dischargeNegated(BitmapStorage32 bitmapStorage32, IteratingRLW32 iteratingRLW32, int n2) {
        int n3;
        int n4;
        for (n3 = 0; iteratingRLW32.size() > 0 && n3 < n2; n3 += n4) {
            int n5 = iteratingRLW32.getRunningLength();
            if (n5 > 0) {
                if (n5 + n3 > n2) {
                    n5 = n2 - n3;
                }
                bitmapStorage32.addStreamOfEmptyWords(iteratingRLW32.getRunningBit(), n5);
                n3 += n5;
            }
            if ((n4 = iteratingRLW32.getNumberOfLiteralWords()) + n3 > n2) {
                n4 = n2 - n3;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                bitmapStorage32.addWord(iteratingRLW32.getLiteralWordAt(i2));
            }
            iteratingRLW32.discardFirstWords(n4 + n5);
        }
        return n3;
    }

    static void andToContainer(BitmapStorage32 bitmapStorage32, int n2, IteratingRLW32 iteratingRLW32, IteratingRLW32 iteratingRLW322) {
        while (iteratingRLW32.size() > 0 && iteratingRLW322.size() > 0 && n2-- > 0) {
            int n3;
            while (iteratingRLW32.getRunningLength() > 0 || iteratingRLW322.getRunningLength() > 0) {
                IteratingRLW32 iteratingRLW323;
                n3 = iteratingRLW32.getRunningLength() < iteratingRLW322.getRunningLength() ? 1 : 0;
                IteratingRLW32 iteratingRLW324 = n3 != 0 ? iteratingRLW32 : iteratingRLW322;
                IteratingRLW32 iteratingRLW325 = iteratingRLW323 = n3 != 0 ? iteratingRLW322 : iteratingRLW32;
                if (!iteratingRLW323.getRunningBit()) {
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW323.getRunningLength());
                    iteratingRLW324.discardFirstWords(iteratingRLW323.getRunningLength());
                    iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
                    continue;
                }
                int n4 = IteratorAggregation32.discharge(bitmapStorage32, iteratingRLW324, iteratingRLW323.getRunningLength());
                bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW323.getRunningLength() - n4);
                iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
            }
            n3 = Math.min(iteratingRLW32.getNumberOfLiteralWords(), iteratingRLW322.getNumberOfLiteralWords());
            if (n3 <= 0) continue;
            n2 -= n3;
            for (int i2 = 0; i2 < n3; ++i2) {
                bitmapStorage32.addWord(iteratingRLW32.getLiteralWordAt(i2) & iteratingRLW322.getLiteralWordAt(i2));
            }
            iteratingRLW32.discardFirstWords(n3);
            iteratingRLW322.discardFirstWords(n3);
        }
    }

    static void andToContainer(BitmapStorage32 bitmapStorage32, IteratingRLW32 iteratingRLW32, IteratingRLW32 iteratingRLW322) {
        while (iteratingRLW32.size() > 0 && iteratingRLW322.size() > 0) {
            int n2;
            while (iteratingRLW32.getRunningLength() > 0 || iteratingRLW322.getRunningLength() > 0) {
                IteratingRLW32 iteratingRLW323;
                n2 = iteratingRLW32.getRunningLength() < iteratingRLW322.getRunningLength() ? 1 : 0;
                IteratingRLW32 iteratingRLW324 = n2 != 0 ? iteratingRLW32 : iteratingRLW322;
                IteratingRLW32 iteratingRLW325 = iteratingRLW323 = n2 != 0 ? iteratingRLW322 : iteratingRLW32;
                if (!iteratingRLW323.getRunningBit()) {
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW323.getRunningLength());
                    iteratingRLW324.discardFirstWords(iteratingRLW323.getRunningLength());
                    iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
                    continue;
                }
                int n3 = IteratorAggregation32.discharge(bitmapStorage32, iteratingRLW324, iteratingRLW323.getRunningLength());
                bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW323.getRunningLength() - n3);
                iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
            }
            n2 = Math.min(iteratingRLW32.getNumberOfLiteralWords(), iteratingRLW322.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage32.addWord(iteratingRLW32.getLiteralWordAt(i2) & iteratingRLW322.getLiteralWordAt(i2));
            }
            iteratingRLW32.discardFirstWords(n2);
            iteratingRLW322.discardFirstWords(n2);
        }
    }

    public static void xorToContainer(BitmapStorage32 bitmapStorage32, int n2, IteratingRLW32 iteratingRLW32, IteratingRLW32 iteratingRLW322) {
        while (iteratingRLW32.size() > 0 && iteratingRLW322.size() > 0 && n2-- > 0) {
            int n3;
            while (iteratingRLW32.getRunningLength() > 0 || iteratingRLW322.getRunningLength() > 0) {
                int n4;
                IteratingRLW32 iteratingRLW323;
                n3 = iteratingRLW32.getRunningLength() < iteratingRLW322.getRunningLength() ? 1 : 0;
                IteratingRLW32 iteratingRLW324 = n3 != 0 ? iteratingRLW32 : iteratingRLW322;
                IteratingRLW32 iteratingRLW325 = iteratingRLW323 = n3 != 0 ? iteratingRLW322 : iteratingRLW32;
                if (!iteratingRLW323.getRunningBit()) {
                    n4 = IteratorAggregation32.discharge(bitmapStorage32, iteratingRLW324, iteratingRLW323.getRunningLength());
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingRLW323.getRunningLength() - n4);
                    iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
                    continue;
                }
                n4 = IteratorAggregation32.dischargeNegated(bitmapStorage32, iteratingRLW324, iteratingRLW323.getRunningLength());
                bitmapStorage32.addStreamOfEmptyWords(true, iteratingRLW323.getRunningLength() - n4);
                iteratingRLW323.discardFirstWords(iteratingRLW323.getRunningLength());
            }
            n3 = Math.min(iteratingRLW32.getNumberOfLiteralWords(), iteratingRLW322.getNumberOfLiteralWords());
            if (n3 <= 0) continue;
            n2 -= n3;
            for (int i2 = 0; i2 < n3; ++i2) {
                bitmapStorage32.addWord(iteratingRLW32.getLiteralWordAt(i2) ^ iteratingRLW322.getLiteralWordAt(i2));
            }
            iteratingRLW32.discardFirstWords(n3);
            iteratingRLW322.discardFirstWords(n3);
        }
    }

    protected static int inplaceor(int[] nArray, IteratingRLW32 iteratingRLW32) {
        int n2;
        int n3 = 0;
        while ((n2 = iteratingRLW32.size()) > 0) {
            int n4;
            int n5;
            int n6;
            if (n3 + n2 < nArray.length) {
                n6 = iteratingRLW32.getRunningLength();
                if (iteratingRLW32.getRunningBit()) {
                    Arrays.fill(nArray, n3, n3 + n6, -1);
                }
                n3 += n6;
                n5 = iteratingRLW32.getNumberOfLiteralWords();
                for (n4 = 0; n4 < n5; ++n4) {
                    int n7 = n3++;
                    nArray[n7] = nArray[n7] | iteratingRLW32.getLiteralWordAt(n4);
                }
                if (iteratingRLW32.next()) continue;
                return n3;
            }
            n6 = nArray.length - n3;
            n5 = iteratingRLW32.getRunningLength();
            if (n3 + n5 > nArray.length) {
                if (iteratingRLW32.getRunningBit()) {
                    Arrays.fill(nArray, n3, nArray.length, -1);
                }
                iteratingRLW32.discardFirstWords(n6);
                return nArray.length;
            }
            if (iteratingRLW32.getRunningBit()) {
                Arrays.fill(nArray, n3, n3 + n5, -1);
            }
            n3 += n5;
            n4 = 0;
            while (n3 < nArray.length) {
                int n8 = n3++;
                nArray[n8] = nArray[n8] | iteratingRLW32.getLiteralWordAt(n4);
                ++n4;
            }
            iteratingRLW32.discardFirstWords(n6);
            return n3;
        }
        return n3;
    }

    protected static int inplacexor(int[] nArray, IteratingRLW32 iteratingRLW32) {
        int n2;
        int n3 = 0;
        while ((n2 = iteratingRLW32.size()) > 0) {
            int n4;
            int n5;
            int n6;
            if (n3 + n2 < nArray.length) {
                n6 = iteratingRLW32.getRunningLength();
                if (iteratingRLW32.getRunningBit()) {
                    for (n5 = n3; n5 < n3 + n6; ++n5) {
                        nArray[n5] = ~nArray[n5];
                    }
                }
                n3 += n6;
                n5 = iteratingRLW32.getNumberOfLiteralWords();
                for (n4 = 0; n4 < n5; ++n4) {
                    int n7 = n3++;
                    nArray[n7] = nArray[n7] ^ iteratingRLW32.getLiteralWordAt(n4);
                }
                if (iteratingRLW32.next()) continue;
                return n3;
            }
            n6 = nArray.length - n3;
            n5 = iteratingRLW32.getRunningLength();
            if (n3 + n5 > nArray.length) {
                if (iteratingRLW32.getRunningBit()) {
                    for (n4 = n3; n4 < nArray.length; ++n4) {
                        nArray[n4] = ~nArray[n4];
                    }
                }
                iteratingRLW32.discardFirstWords(n6);
                return nArray.length;
            }
            if (iteratingRLW32.getRunningBit()) {
                for (n4 = n3; n4 < n3 + n5; ++n4) {
                    nArray[n4] = ~nArray[n4];
                }
            }
            n3 += n5;
            n4 = 0;
            while (n3 < nArray.length) {
                int n8 = n3++;
                nArray[n8] = nArray[n8] ^ iteratingRLW32.getLiteralWordAt(n4);
                ++n4;
            }
            iteratingRLW32.discardFirstWords(n6);
            return n3;
        }
        return n3;
    }

    protected static int inplaceand(int[] nArray, IteratingRLW32 iteratingRLW32) {
        int n2;
        int n3 = 0;
        while ((n2 = iteratingRLW32.size()) > 0) {
            int n4;
            int n5;
            int n6;
            if (n3 + n2 < nArray.length) {
                n6 = iteratingRLW32.getRunningLength();
                if (!iteratingRLW32.getRunningBit()) {
                    for (n5 = n3; n5 < n3 + n6; ++n5) {
                        nArray[n5] = 0;
                    }
                }
                n3 += n6;
                n5 = iteratingRLW32.getNumberOfLiteralWords();
                for (n4 = 0; n4 < n5; ++n4) {
                    int n7 = n3++;
                    nArray[n7] = nArray[n7] & iteratingRLW32.getLiteralWordAt(n4);
                }
                if (iteratingRLW32.next()) continue;
                return n3;
            }
            n6 = nArray.length - n3;
            n5 = iteratingRLW32.getRunningLength();
            if (n3 + n5 > nArray.length) {
                if (!iteratingRLW32.getRunningBit()) {
                    for (n4 = n3; n4 < nArray.length; ++n4) {
                        nArray[n4] = 0;
                    }
                }
                iteratingRLW32.discardFirstWords(n6);
                return nArray.length;
            }
            if (!iteratingRLW32.getRunningBit()) {
                for (n4 = n3; n4 < n3 + n5; ++n4) {
                    nArray[n4] = 0;
                }
            }
            n3 += n5;
            n4 = 0;
            while (n3 < nArray.length) {
                int n8 = n3++;
                nArray[n8] = nArray[n8] & iteratingRLW32.getLiteralWordAt(n4);
                ++n4;
            }
            iteratingRLW32.discardFirstWords(n6);
            return n3;
        }
        return n3;
    }
}

