/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.BufferedRunningLengthWord32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;

public final class IteratingBufferedRunningLengthWord32
implements IteratingRLW32,
Cloneable {
    private BufferedRunningLengthWord32 brlw;
    private final Buffer32 buffer;
    private int literalWordStartPosition;
    private EWAHIterator32 iterator;

    public IteratingBufferedRunningLengthWord32(EWAHIterator32 eWAHIterator32) {
        this.iterator = eWAHIterator32;
        this.brlw = new BufferedRunningLengthWord32(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord32(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        this(EWAHIterator32.getEWAHIterator(eWAHCompressedBitmap32));
    }

    @Override
    public void discardFirstWords(int n2) {
        while (n2 > 0) {
            if (this.brlw.RunningLength > n2) {
                this.brlw.RunningLength -= n2;
                return;
            }
            this.brlw.RunningLength = 0;
            int n3 = (n2 -= this.brlw.RunningLength) > this.brlw.NumberOfLiteralWords ? this.brlw.NumberOfLiteralWords : n2;
            this.literalWordStartPosition += n3;
            this.brlw.NumberOfLiteralWords -= n3;
            if ((n2 -= n3) <= 0 && this.brlw.size() != 0) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardLiteralWords(int n2) {
        this.literalWordStartPosition += n2;
        this.brlw.NumberOfLiteralWords -= n2;
        if (this.brlw.NumberOfLiteralWords == 0) {
            if (!this.iterator.hasNext()) {
                return;
            }
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.RunningLength = 0;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    public int discharge(BitmapStorage32 bitmapStorage32, int n2) {
        int n3 = 0;
        do {
            if (n3 + this.getRunningLength() > n2) {
                int n4 = n2 - n3;
                bitmapStorage32.addStreamOfEmptyWords(this.getRunningBit(), n4);
                this.brlw.RunningLength -= n4;
                return n2;
            }
            bitmapStorage32.addStreamOfEmptyWords(this.getRunningBit(), this.getRunningLength());
            if (this.getNumberOfLiteralWords() + (n3 += this.getRunningLength()) > n2) {
                int n5 = n2 - n3;
                this.writeLiteralWords(n5, bitmapStorage32);
                this.brlw.RunningLength = 0;
                this.brlw.NumberOfLiteralWords -= n5;
                this.literalWordStartPosition += n5;
                return n2;
            }
            this.writeLiteralWords(this.getNumberOfLiteralWords(), bitmapStorage32);
            n3 += this.getNumberOfLiteralWords();
        } while (this.next());
        return n3;
    }

    public int dischargeNegated(BitmapStorage32 bitmapStorage32, int n2) {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && this.size() > 0; n3 += n4) {
            int n5 = this.getRunningLength();
            if (n3 + n5 > n2) {
                n5 = n2 - n3;
            }
            bitmapStorage32.addStreamOfEmptyWords(!this.getRunningBit(), n5);
            n4 = this.getNumberOfLiteralWords();
            if (n4 + (n3 += n5) > n2) {
                n4 = n2 - n3;
            }
            this.writeNegatedLiteralWords(n4, bitmapStorage32);
            this.discardFirstWords(n5 + n4);
        }
        return n3;
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext()) {
            this.brlw.NumberOfLiteralWords = 0;
            this.brlw.RunningLength = 0;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    public void dischargeAsEmpty(BitmapStorage32 bitmapStorage32) {
        while (this.size() > 0) {
            bitmapStorage32.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage32 bitmapStorage32) {
        this.brlw.literalWordOffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord32.discharge(this.brlw, this.iterator, bitmapStorage32);
    }

    @Override
    public int getLiteralWordAt(int n2) {
        return this.buffer.getWord(this.literalWordStartPosition + n2);
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    @Override
    public int getRunningLength() {
        return this.brlw.RunningLength;
    }

    @Override
    public int size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int n2, BitmapStorage32 bitmapStorage32) {
        bitmapStorage32.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, n2);
    }

    public void writeNegatedLiteralWords(int n2, BitmapStorage32 bitmapStorage32) {
        bitmapStorage32.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, n2);
    }

    protected static void discharge(BufferedRunningLengthWord32 bufferedRunningLengthWord32, EWAHIterator32 eWAHIterator32, BitmapStorage32 bitmapStorage32) {
        BufferedRunningLengthWord32 bufferedRunningLengthWord322 = bufferedRunningLengthWord32;
        while (true) {
            int n2 = bufferedRunningLengthWord322.getRunningLength();
            bitmapStorage32.addStreamOfEmptyWords(bufferedRunningLengthWord322.getRunningBit(), n2);
            bitmapStorage32.addStreamOfLiteralWords(eWAHIterator32.buffer(), eWAHIterator32.literalWords() + bufferedRunningLengthWord322.literalWordOffset, bufferedRunningLengthWord322.getNumberOfLiteralWords());
            if (!eWAHIterator32.hasNext()) break;
            bufferedRunningLengthWord322 = new BufferedRunningLengthWord32(eWAHIterator32.next());
        }
    }

    @Override
    public IteratingBufferedRunningLengthWord32 clone() {
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = (IteratingBufferedRunningLengthWord32)super.clone();
        iteratingBufferedRunningLengthWord32.brlw = this.brlw.clone();
        iteratingBufferedRunningLengthWord32.iterator = this.iterator.clone();
        return iteratingBufferedRunningLengthWord32;
    }
}

