/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.IteratingRLW32;

public class IntIteratorOverIteratingRLW32
implements IntIterator {
    final IteratingRLW32 parent;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    public IntIteratorOverIteratingRLW32(IteratingRLW32 iteratingRLW32) {
        this.parent = iteratingRLW32;
        this.position = 0;
        this.setupForCurrentRunningLengthWord();
        this.hasNext = this.moveToNext();
    }

    private boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (this.parent.next()) {
                this.setupForCurrentRunningLengthWord();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public final int next() {
        int n2;
        if (this.runningHasNext()) {
            n2 = this.position++;
        } else {
            int n3 = this.word & -this.word;
            n2 = this.literalPosition + Integer.bitCount(n3 - 1);
            this.word ^= n3;
        }
        this.hasNext = this.moveToNext();
        return n2;
    }

    private void setupForCurrentRunningLengthWord() {
        this.runningLength = 32 * this.parent.getRunningLength() + this.position;
        if (!this.parent.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = 0;
        this.wordLength = this.parent.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            this.word = this.parent.getLiteralWordAt(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

