/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.Buffer32;
import java.nio.IntBuffer;

final class IntBufferWrapper
implements Buffer32,
Cloneable {
    private int actualSizeInWords = 1;
    private IntBuffer buffer;

    public IntBufferWrapper(IntBuffer intBuffer) {
        this.buffer = intBuffer;
    }

    public IntBufferWrapper(IntBuffer intBuffer, int n2) {
        this.buffer = intBuffer;
        this.actualSizeInWords = n2;
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int n2) {
        if (n2 > this.buffer.capacity()) {
            throw new RuntimeException("Cannot increase buffer capacity. Current capacity: " + this.buffer.capacity() + ". New capacity: " + n2);
        }
    }

    @Override
    public int getWord(int n2) {
        return this.buffer.get(n2);
    }

    @Override
    public int getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.setWord(0, 0);
    }

    @Override
    public void trim() {
    }

    @Override
    public void setWord(int n2, int n3) {
        this.buffer.put(n2, n3);
    }

    @Override
    public void setLastWord(int n2) {
        this.setWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void push_back(int n2) {
        this.setWord(this.actualSizeInWords++, n2);
    }

    @Override
    public void push_back(Buffer32 buffer32, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.push_back(buffer32.getWord(n2 + i2));
        }
    }

    @Override
    public void negative_push_back(Buffer32 buffer32, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.push_back(~buffer32.getWord(n2 + i2));
        }
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0);
    }

    @Override
    public void negateWord(int n2) {
        this.setWord(n2, ~this.getWord(n2));
    }

    @Override
    public void andWord(int n2, int n3) {
        this.setWord(n2, this.getWord(n2) & n3);
    }

    @Override
    public void orWord(int n2, int n3) {
        this.setWord(n2, this.getWord(n2) | n3);
    }

    @Override
    public void andLastWord(int n2) {
        this.andWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void orLastWord(int n2) {
        this.orWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void expand(int n2, int n3) {
        for (int i2 = this.actualSizeInWords - n2 - 1; i2 >= 0; --i2) {
            this.setWord(n2 + n3 + i2, this.getWord(n2 + i2));
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void collapse(int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.actualSizeInWords - n2 - n3; ++n4) {
            this.setWord(n2 + n4, this.getWord(n2 + n3 + n4));
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.removeLastWord();
        }
    }

    @Override
    public IntBufferWrapper clone() {
        return new IntBufferWrapper(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void swap(Buffer32 buffer32) {
        if (buffer32 instanceof IntBufferWrapper) {
            IntBufferWrapper intBufferWrapper = (IntBufferWrapper)buffer32;
            IntBuffer intBuffer = this.buffer;
            int n2 = this.actualSizeInWords;
            this.actualSizeInWords = intBufferWrapper.actualSizeInWords;
            this.buffer = intBufferWrapper.buffer;
            intBufferWrapper.actualSizeInWords = n2;
            intBufferWrapper.buffer = intBuffer;
        } else {
            buffer32.swap(this);
        }
    }
}

