/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.Buffer32;
import java.util.Arrays;

class IntArray
implements Buffer32,
Cloneable {
    private int actualSizeInWords = 1;
    private int[] buffer = null;
    private static final int DEFAULT_BUFFER_SIZE = 4;

    public IntArray() {
        this(4);
    }

    public IntArray(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.buffer = new int[n2];
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int n2) {
        this.resizeBuffer(n2 - this.actualSizeInWords);
    }

    @Override
    public int getWord(int n2) {
        return this.buffer[n2];
    }

    @Override
    public int getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.buffer[0] = 0;
    }

    @Override
    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void setWord(int n2, int n3) {
        this.buffer[n2] = n3;
    }

    @Override
    public void setLastWord(int n2) {
        this.setWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void push_back(int n2) {
        this.resizeBuffer(1);
        this.buffer[this.actualSizeInWords++] = n2;
    }

    @Override
    public void push_back(Buffer32 buffer32, int n2, int n3) {
        this.resizeBuffer(n3);
        if (buffer32 instanceof IntArray) {
            int[] nArray = ((IntArray)buffer32).buffer;
            System.arraycopy(nArray, n2, this.buffer, this.actualSizeInWords, n3);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.buffer[this.actualSizeInWords + i2] = buffer32.getWord(n2 + i2);
            }
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void negative_push_back(Buffer32 buffer32, int n2, int n3) {
        this.resizeBuffer(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.buffer[this.actualSizeInWords + i2] = ~buffer32.getWord(n2 + i2);
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0);
    }

    @Override
    public void negateWord(int n2) {
        this.buffer[n2] = ~this.buffer[n2];
    }

    @Override
    public void andWord(int n2, int n3) {
        int n4 = n2;
        this.buffer[n4] = this.buffer[n4] & n3;
    }

    @Override
    public void orWord(int n2, int n3) {
        int n4 = n2;
        this.buffer[n4] = this.buffer[n4] | n3;
    }

    @Override
    public void andLastWord(int n2) {
        this.andWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void orLastWord(int n2) {
        this.orWord(this.actualSizeInWords - 1, n2);
    }

    @Override
    public void expand(int n2, int n3) {
        this.resizeBuffer(n3);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + n3, this.actualSizeInWords - n2);
        this.actualSizeInWords += n3;
    }

    @Override
    public void collapse(int n2, int n3) {
        System.arraycopy(this.buffer, n2 + n3, this.buffer, n2, this.actualSizeInWords - n2 - n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.removeLastWord();
        }
    }

    @Override
    public IntArray clone() {
        IntArray intArray = null;
        try {
            intArray = (IntArray)super.clone();
            intArray.buffer = (int[])this.buffer.clone();
            intArray.actualSizeInWords = this.actualSizeInWords;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return intArray;
    }

    @Override
    public void swap(Buffer32 buffer32) {
        if (buffer32 instanceof IntArray) {
            int[] nArray = this.buffer;
            this.buffer = ((IntArray)buffer32).buffer;
            ((IntArray)buffer32).buffer = nArray;
            int n2 = this.actualSizeInWords;
            this.actualSizeInWords = ((IntArray)buffer32).actualSizeInWords;
            ((IntArray)buffer32).actualSizeInWords = n2;
        } else {
            int n3;
            int[] nArray = new int[buffer32.sizeInWords()];
            for (n3 = 0; n3 < buffer32.sizeInWords(); ++n3) {
                nArray[n3] = buffer32.getWord(n3);
            }
            n3 = buffer32.sizeInWords();
            buffer32.clear();
            buffer32.removeLastWord();
            buffer32.push_back(this, 0, this.sizeInWords());
            this.buffer = nArray;
            this.actualSizeInWords = n3;
        }
    }

    private void resizeBuffer(int n2) {
        int n3 = this.newSizeInWords(n2);
        if (n3 >= this.buffer.length) {
            int[] nArray = this.buffer;
            this.buffer = new int[n3];
            System.arraycopy(nArray, 0, this.buffer, 0, nArray.length);
        }
    }

    private int newSizeInWords(int n2) {
        int n3 = this.actualSizeInWords + n2;
        if (n3 >= this.buffer.length) {
            n3 = n3 < 32768 ? (n3 *= 2) : (n3 * 3 / 2 < n3 ? Integer.MAX_VALUE : n3 * 3 / 2);
        }
        return n3;
    }
}

