/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.RunningLengthWord32;

public final class EWAHIterator32
implements Cloneable {
    private int pointer;
    final RunningLengthWord32 rlw;
    private final int size;

    public EWAHIterator32(Buffer32 buffer32) {
        this.rlw = new RunningLengthWord32(buffer32, 0);
        this.size = buffer32.sizeInWords();
        this.pointer = 0;
    }

    private EWAHIterator32(int n2, RunningLengthWord32 runningLengthWord32, int n3) {
        this.pointer = n2;
        this.rlw = runningLengthWord32;
        this.size = n3;
    }

    public static EWAHIterator32 getEWAHIterator(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        return eWAHCompressedBitmap32.getEWAHIterator();
    }

    public Buffer32 buffer() {
        return this.rlw.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord32 next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator32 clone() {
        return new EWAHIterator32(this.pointer, this.rlw.clone(), this.size);
    }
}

