/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah32.BitCounter32;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.ChunkIteratorImpl32;
import com.googlecode.javaewah32.ClearIntIterator32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32$1;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IntArray;
import com.googlecode.javaewah32.IntBufferWrapper;
import com.googlecode.javaewah32.IntIteratorImpl32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32$NonEmptyException;
import com.googlecode.javaewah32.ReverseEWAHIterator32;
import com.googlecode.javaewah32.ReverseIntIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;
import com.googlecode.javaewah32.symmetric.RunningBitmapMerge32;
import com.googlecode.javaewah32.symmetric.ThresholdFuncBitmap32;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap32
implements LogicalElement,
BitmapStorage32,
Externalizable,
Cloneable,
Iterable {
    final Buffer32 buffer;
    private RunningLengthWord32 rlw = null;
    private int sizeInBits = 0;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 32;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap32() {
        this(new IntArray());
    }

    public EWAHCompressedBitmap32(int n2) {
        this(new IntArray(n2));
    }

    public EWAHCompressedBitmap32(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.sizeInBits = intBuffer.get(0);
        int n2 = intBuffer.get(1);
        int n3 = intBuffer.get(2 + n2);
        intBuffer.position(2);
        this.buffer = new IntBufferWrapper(intBuffer.slice(), n2);
        this.rlw = new RunningLengthWord32(this.buffer, n3);
    }

    public EWAHCompressedBitmap32(IntBuffer intBuffer) {
        this(new IntBufferWrapper(intBuffer));
    }

    private EWAHCompressedBitmap32(Buffer32 buffer32) {
        this.buffer = buffer32;
        this.rlw = new RunningLengthWord32(this.buffer, 0);
    }

    @Deprecated
    public void add(int n2) {
        this.addWord(n2);
    }

    @Deprecated
    public void add(int n2, int n3) {
        this.addWord(n2, n3);
    }

    @Override
    public void addWord(int n2) {
        this.addWord(n2, 32);
    }

    public void addWord(int n2, int n3) {
        this.sizeInBits += n3;
        if (n2 == 0) {
            this.insertEmptyWord(false);
        } else if (n2 == -1) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(n2);
        }
    }

    private void insertEmptyWord(boolean bl2) {
        boolean bl3 = this.rlw.getNumberOfLiteralWords() == 0;
        int n2 = this.rlw.getRunningLength();
        if (bl3 && n2 == 0) {
            this.rlw.setRunningBit(bl2);
        }
        if (bl3 && this.rlw.getRunningBit() == bl2 && n2 < 65535) {
            this.rlw.setRunningLength(n2 + 1);
            return;
        }
        this.buffer.push_back(0);
        this.rlw.position = this.buffer.sizeInWords() - 1;
        this.rlw.setRunningBit(bl2);
        this.rlw.setRunningLength(1);
    }

    @Override
    public void addLiteralWord(int n2) {
        this.sizeInBits += 32;
        this.insertLiteralWord(n2);
    }

    private void insertLiteralWord(int n2) {
        int n3 = this.rlw.getNumberOfLiteralWords();
        if (n3 >= Short.MAX_VALUE) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.buffer.push_back(n2);
        } else {
            this.rlw.setNumberOfLiteralWords(n3 + 1);
            this.buffer.push_back(n2);
        }
    }

    @Override
    public void addStreamOfLiteralWords(Buffer32 buffer32, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this.rlw.getNumberOfLiteralWords();
            int n6 = n4 < Short.MAX_VALUE - n5 ? n4 : Short.MAX_VALUE - n5;
            this.rlw.setNumberOfLiteralWords(n5 + n6);
            this.buffer.push_back(buffer32, n2, n6);
            this.sizeInBits += n6 * 32;
            if ((n4 -= n6) <= 0) continue;
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean bl2, int n2) {
        if (n2 == 0) {
            return;
        }
        this.sizeInBits += n2 * 32;
        this.fastaddStreamOfEmptyWords(bl2, n2);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer32 buffer32, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this.rlw.getNumberOfLiteralWords();
            int n6 = n4 < Short.MAX_VALUE - n5 ? n4 : Short.MAX_VALUE - n5;
            this.rlw.setNumberOfLiteralWords(n5 + n6);
            this.buffer.negative_push_back(buffer32, n2, n6);
            this.sizeInBits += n6 * 32;
            if ((n4 -= n6) <= 0) continue;
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        int n2 = this.buffer.sizeInWords() > eWAHCompressedBitmap32.buffer.sizeInWords() ? this.buffer.sizeInWords() : eWAHCompressedBitmap32.buffer.sizeInWords();
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        this.andToContainer(eWAHCompressedBitmap32, eWAHCompressedBitmap322);
        return eWAHCompressedBitmap322;
    }

    public void andToContainer(EWAHCompressedBitmap32 eWAHCompressedBitmap32, BitmapStorage32 bitmapStorage32) {
        bitmapStorage32.clear();
        EWAHIterator32 eWAHIterator32 = eWAHCompressedBitmap32.getEWAHIterator();
        EWAHIterator32 eWAHIterator322 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = new IteratingBufferedRunningLengthWord32(eWAHIterator32);
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord322 = new IteratingBufferedRunningLengthWord32(eWAHIterator322);
        while (iteratingBufferedRunningLengthWord32.size() > 0 && iteratingBufferedRunningLengthWord322.size() > 0) {
            int n2;
            while (iteratingBufferedRunningLengthWord32.getRunningLength() > 0 || iteratingBufferedRunningLengthWord322.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord323;
                n2 = iteratingBufferedRunningLengthWord32.getRunningLength() < iteratingBufferedRunningLengthWord322.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord324 = n2 != 0 ? iteratingBufferedRunningLengthWord32 : iteratingBufferedRunningLengthWord322;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord325 = iteratingBufferedRunningLengthWord323 = n2 != 0 ? iteratingBufferedRunningLengthWord322 : iteratingBufferedRunningLengthWord32;
                if (!iteratingBufferedRunningLengthWord323.getRunningBit()) {
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord323.getRunningLength());
                    iteratingBufferedRunningLengthWord324.discardFirstWords(iteratingBufferedRunningLengthWord323.getRunningLength());
                } else {
                    int n3 = iteratingBufferedRunningLengthWord324.discharge(bitmapStorage32, iteratingBufferedRunningLengthWord323.getRunningLength());
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord323.getRunningLength() - n3);
                }
                iteratingBufferedRunningLengthWord323.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord32.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord322.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage32.addWord(iteratingBufferedRunningLengthWord32.getLiteralWordAt(i2) & iteratingBufferedRunningLengthWord322.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord32.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord322.discardLiteralWords(n2);
        }
        bitmapStorage32.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap32.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        BitCounter32 bitCounter32 = new BitCounter32();
        this.andToContainer(eWAHCompressedBitmap32, bitCounter32);
        return bitCounter32.getCount();
    }

    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        int n2 = this.buffer.sizeInWords() > eWAHCompressedBitmap32.buffer.sizeInWords() ? this.buffer.sizeInWords() : eWAHCompressedBitmap32.buffer.sizeInWords();
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        this.andNotToContainer(eWAHCompressedBitmap32, eWAHCompressedBitmap322);
        return eWAHCompressedBitmap322;
    }

    public void andNotToContainer(EWAHCompressedBitmap32 eWAHCompressedBitmap32, BitmapStorage32 bitmapStorage32) {
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32;
        int n2;
        bitmapStorage32.clear();
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        EWAHIterator32 eWAHIterator322 = eWAHCompressedBitmap32.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord322 = new IteratingBufferedRunningLengthWord32(eWAHIterator32);
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord323 = new IteratingBufferedRunningLengthWord32(eWAHIterator322);
        while (iteratingBufferedRunningLengthWord322.size() > 0 && iteratingBufferedRunningLengthWord323.size() > 0) {
            while (iteratingBufferedRunningLengthWord322.getRunningLength() > 0 || iteratingBufferedRunningLengthWord323.getRunningLength() > 0) {
                int n3;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord324;
                n2 = iteratingBufferedRunningLengthWord322.getRunningLength() < iteratingBufferedRunningLengthWord323.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord325 = n2 != 0 ? iteratingBufferedRunningLengthWord322 : iteratingBufferedRunningLengthWord323;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord326 = iteratingBufferedRunningLengthWord324 = n2 != 0 ? iteratingBufferedRunningLengthWord323 : iteratingBufferedRunningLengthWord322;
                if (iteratingBufferedRunningLengthWord324.getRunningBit() && n2 != 0 || !iteratingBufferedRunningLengthWord324.getRunningBit() && n2 == 0) {
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord324.getRunningLength());
                    iteratingBufferedRunningLengthWord325.discardFirstWords(iteratingBufferedRunningLengthWord324.getRunningLength());
                } else if (n2 != 0) {
                    n3 = iteratingBufferedRunningLengthWord325.discharge(bitmapStorage32, iteratingBufferedRunningLengthWord324.getRunningLength());
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord324.getRunningLength() - n3);
                } else {
                    n3 = iteratingBufferedRunningLengthWord325.dischargeNegated(bitmapStorage32, iteratingBufferedRunningLengthWord324.getRunningLength());
                    bitmapStorage32.addStreamOfEmptyWords(true, iteratingBufferedRunningLengthWord324.getRunningLength() - n3);
                }
                iteratingBufferedRunningLengthWord324.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord322.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord323.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage32.addWord(iteratingBufferedRunningLengthWord322.getLiteralWordAt(i2) & ~iteratingBufferedRunningLengthWord323.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord322.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord323.discardLiteralWords(n2);
        }
        n2 = iteratingBufferedRunningLengthWord322.size() > 0 ? 1 : 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord327 = iteratingBufferedRunningLengthWord32 = n2 != 0 ? iteratingBufferedRunningLengthWord322 : iteratingBufferedRunningLengthWord323;
        if (n2 != 0) {
            iteratingBufferedRunningLengthWord32.discharge(bitmapStorage32);
        }
        bitmapStorage32.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap32.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        BitCounter32 bitCounter32 = new BitCounter32();
        this.andNotToContainer(eWAHCompressedBitmap32, bitCounter32);
        return bitCounter32.getCount();
    }

    public int cardinality() {
        int n2 = 0;
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        while (eWAHIterator32.hasNext()) {
            RunningLengthWord32 runningLengthWord32 = eWAHIterator32.next();
            if (runningLengthWord32.getRunningBit()) {
                n2 += 32 * runningLengthWord32.getRunningLength();
            }
            int n3 = runningLengthWord32.getNumberOfLiteralWords();
            int n4 = eWAHIterator32.literalWords();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += Integer.bitCount(eWAHIterator32.buffer().getWord(n4 + i2));
            }
        }
        return n2;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.buffer.clear();
        this.rlw.position = 0;
    }

    public EWAHCompressedBitmap32 clone() {
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32(this.buffer.clone());
        eWAHCompressedBitmap32.sizeInBits = this.sizeInBits;
        eWAHCompressedBitmap32.rlw = new RunningLengthWord32(eWAHCompressedBitmap32.buffer, this.rlw.position);
        return eWAHCompressedBitmap32;
    }

    public void serialize(DataOutput dataOutput) {
        dataOutput.writeInt(this.sizeInBits);
        int n2 = this.buffer.sizeInWords();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeInt(this.buffer.getWord(i2));
        }
        dataOutput.writeInt(this.rlw.position);
    }

    public void deserialize(DataInput dataInput) {
        this.sizeInBits = dataInput.readInt();
        int n2 = dataInput.readInt();
        this.buffer.clear();
        this.buffer.removeLastWord();
        this.buffer.ensureCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.push_back(dataInput.readInt());
        }
        this.rlw = new RunningLengthWord32(this.buffer, dataInput.readInt());
    }

    public boolean equals(Object object) {
        if (object instanceof EWAHCompressedBitmap32) {
            try {
                this.xorToContainer((EWAHCompressedBitmap32)object, new NonEmptyVirtualStorage32());
                return true;
            }
            catch (NonEmptyVirtualStorage32$NonEmptyException nonEmptyVirtualStorage32$NonEmptyException) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean bl2, int n2) {
        if (this.rlw.getRunningBit() != bl2 && this.rlw.size() == 0) {
            this.rlw.setRunningBit(bl2);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != bl2) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
        }
        int n3 = this.rlw.getRunningLength();
        int n4 = n2 < 65535 - n3 ? n2 : 65535 - n3;
        this.rlw.setRunningLength(n3 + n4);
        n2 -= n4;
        while (n2 >= 65535) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(65535);
            n2 -= 65535;
        }
        if (n2 > 0) {
            this.buffer.push_back(0);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(n2);
        }
    }

    public EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this.buffer);
    }

    private ReverseEWAHIterator32 getReverseEWAHIterator() {
        return new ReverseEWAHIterator32(this.buffer);
    }

    public IteratingRLW32 getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord32(this);
    }

    @Deprecated
    public List getPositions() {
        return this.toList();
    }

    public List toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        int n2 = 0;
        while (eWAHIterator32.hasNext()) {
            int n3;
            int n4;
            int n5;
            RunningLengthWord32 runningLengthWord32 = eWAHIterator32.next();
            if (runningLengthWord32.getRunningBit()) {
                n5 = runningLengthWord32.getRunningLength();
                for (n4 = 0; n4 < n5; ++n4) {
                    for (n3 = 0; n3 < 32; ++n3) {
                        arrayList.add(n2++);
                    }
                }
            } else {
                n2 += 32 * runningLengthWord32.getRunningLength();
            }
            n5 = runningLengthWord32.getNumberOfLiteralWords();
            for (n4 = 0; n4 < n5; ++n4) {
                int n6;
                for (n3 = eWAHIterator32.buffer().getWord(eWAHIterator32.literalWords() + n4); n3 != 0; n3 ^= n6) {
                    n6 = n3 & -n3;
                    arrayList.add(Integer.bitCount(n6 - 1) + n2);
                }
                n2 += 32;
            }
        }
        while (arrayList.size() > 0 && (Integer)arrayList.get(arrayList.size() - 1) >= this.sizeInBits) {
            arrayList.remove(arrayList.size() - 1);
        }
        return arrayList;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = -1640531535;
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        while (eWAHIterator32.hasNext()) {
            int n4;
            eWAHIterator32.next();
            if (eWAHIterator32.rlw.getRunningBit()) {
                n4 = eWAHIterator32.rlw.getRunningLength();
                n2 += -1640531535 * n4;
            }
            n4 = eWAHIterator32.rlw.getNumberOfLiteralWords();
            int n5 = eWAHIterator32.literalWords();
            for (int i2 = 0; i2 < n4; ++i2) {
                long l2 = this.buffer.getWord(n5 + i2);
                n2 += (int)(-1640531535L * l2);
            }
        }
        return n2;
    }

    public boolean intersects(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        NonEmptyVirtualStorage32 nonEmptyVirtualStorage32 = new NonEmptyVirtualStorage32();
        try {
            this.andToContainer(eWAHCompressedBitmap32, nonEmptyVirtualStorage32);
        }
        catch (NonEmptyVirtualStorage32$NonEmptyException nonEmptyVirtualStorage32$NonEmptyException) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl32(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator32(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator32(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl32(this.getEWAHIterator(), this.sizeInBits);
    }

    public Iterator iterator() {
        return new EWAHCompressedBitmap32$1(this);
    }

    @Override
    public void not() {
        int n2;
        RunningLengthWord32 runningLengthWord32;
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        if (!eWAHIterator32.hasNext()) {
            return;
        }
        do {
            runningLengthWord32.setRunningBit(!(runningLengthWord32 = eWAHIterator32.next()).getRunningBit());
            int n3 = runningLengthWord32.getNumberOfLiteralWords();
            for (n2 = 0; n2 < n3; ++n2) {
                eWAHIterator32.buffer().negateWord(eWAHIterator32.literalWords() + n2);
            }
        } while (eWAHIterator32.hasNext());
        n2 = this.sizeInBits % 32;
        if (n2 == 0) {
            return;
        }
        if (runningLengthWord32.getNumberOfLiteralWords() == 0) {
            if (runningLengthWord32.getRunningLength() > 0 && runningLengthWord32.getRunningBit()) {
                if (runningLengthWord32.getRunningLength() == 1 && runningLengthWord32.position > 0) {
                    EWAHIterator32 eWAHIterator322 = this.getEWAHIterator();
                    int n4 = this.rlw.position;
                    while (eWAHIterator322.hasNext()) {
                        RunningLengthWord32 runningLengthWord322 = eWAHIterator322.next();
                        if (runningLengthWord322.position >= runningLengthWord32.position) break;
                        n4 = runningLengthWord322.position;
                    }
                    this.rlw.position = n4;
                    this.buffer.removeLastWord();
                } else {
                    runningLengthWord32.setRunningLength(runningLengthWord32.getRunningLength() - 1);
                }
                this.insertLiteralWord(-1 >>> 32 - n2);
            }
            return;
        }
        eWAHIterator32.buffer().andWord(eWAHIterator32.literalWords() + runningLengthWord32.getNumberOfLiteralWords() - 1, -1 >>> 32 - n2);
    }

    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        int n2 = this.buffer.sizeInWords() + eWAHCompressedBitmap32.buffer.sizeInWords();
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        this.orToContainer(eWAHCompressedBitmap32, eWAHCompressedBitmap322);
        return eWAHCompressedBitmap322;
    }

    public void orToContainer(EWAHCompressedBitmap32 eWAHCompressedBitmap32, BitmapStorage32 bitmapStorage32) {
        int n2;
        bitmapStorage32.clear();
        EWAHIterator32 eWAHIterator32 = eWAHCompressedBitmap32.getEWAHIterator();
        EWAHIterator32 eWAHIterator322 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = new IteratingBufferedRunningLengthWord32(eWAHIterator32);
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord322 = new IteratingBufferedRunningLengthWord32(eWAHIterator322);
        while (iteratingBufferedRunningLengthWord32.size() > 0 && iteratingBufferedRunningLengthWord322.size() > 0) {
            while (iteratingBufferedRunningLengthWord32.getRunningLength() > 0 || iteratingBufferedRunningLengthWord322.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord323;
                n2 = iteratingBufferedRunningLengthWord32.getRunningLength() < iteratingBufferedRunningLengthWord322.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord324 = n2 != 0 ? iteratingBufferedRunningLengthWord32 : iteratingBufferedRunningLengthWord322;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord325 = iteratingBufferedRunningLengthWord323 = n2 != 0 ? iteratingBufferedRunningLengthWord322 : iteratingBufferedRunningLengthWord32;
                if (iteratingBufferedRunningLengthWord323.getRunningBit()) {
                    bitmapStorage32.addStreamOfEmptyWords(true, iteratingBufferedRunningLengthWord323.getRunningLength());
                    iteratingBufferedRunningLengthWord324.discardFirstWords(iteratingBufferedRunningLengthWord323.getRunningLength());
                } else {
                    int n3 = iteratingBufferedRunningLengthWord324.discharge(bitmapStorage32, iteratingBufferedRunningLengthWord323.getRunningLength());
                    bitmapStorage32.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord323.getRunningLength() - n3);
                }
                iteratingBufferedRunningLengthWord323.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord32.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord322.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage32.addWord(iteratingBufferedRunningLengthWord32.getLiteralWordAt(i2) | iteratingBufferedRunningLengthWord322.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord32.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord322.discardLiteralWords(n2);
        }
        if (iteratingBufferedRunningLengthWord322.size() > 0 && iteratingBufferedRunningLengthWord32.size() > 0) {
            throw new RuntimeException("fds");
        }
        n2 = iteratingBufferedRunningLengthWord32.size() > 0 ? 1 : 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord326 = n2 != 0 ? iteratingBufferedRunningLengthWord32 : iteratingBufferedRunningLengthWord322;
        iteratingBufferedRunningLengthWord326.discharge(bitmapStorage32);
        bitmapStorage32.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap32.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        BitCounter32 bitCounter32 = new BitCounter32();
        this.orToContainer(eWAHCompressedBitmap32, bitCounter32);
        return bitCounter32.getCount();
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        this.deserialize(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        this.serialize(objectOutput);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int n2) {
        if (n2 < 0 || n2 >= this.sizeInBits) {
            return false;
        }
        IteratingRLW32 iteratingRLW32 = this.getIteratingRLW();
        int n3 = n2 / 32;
        for (int i2 = 0; i2 <= n3; i2 += iteratingRLW32.getNumberOfLiteralWords()) {
            if (n3 < (i2 += iteratingRLW32.getRunningLength())) {
                return iteratingRLW32.getRunningBit();
            }
            if (n3 < i2 + iteratingRLW32.getNumberOfLiteralWords()) {
                int n4 = iteratingRLW32.getLiteralWordAt(n3 - i2);
                return (n4 & 1 << n2) != 0;
            }
            iteratingRLW32.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int n2 = 0;
        int n3 = this.buffer.sizeInWords();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = RunningLengthWord32.getRunningLength(this.buffer, i2);
            boolean bl2 = RunningLengthWord32.getRunningBit(this.buffer, i2);
            if (n4 > 0 && bl2) {
                return n2 * 32;
            }
            n2 += n4;
            int n5 = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, i2);
            for (int i3 = i2 + 1; i3 <= i2 + n5; ++i3) {
                int n6 = this.buffer.getWord(i3);
                if ((long)n6 != 0L) {
                    int n7 = n6 & -n6;
                    return n2 * 32 + Integer.bitCount(n7 - 1);
                }
                ++n2;
            }
        }
        return -1;
    }

    public boolean clear(int n2) {
        return this.set(n2, false);
    }

    public boolean set(int n2) {
        return this.set(n2, true);
    }

    private boolean set(int n2, boolean bl2) {
        if (n2 > 0x7FFFFFDF || n2 < 0) {
            throw new IndexOutOfBoundsException("Position should be between 0 and 2147483615");
        }
        if (n2 < this.sizeInBits) {
            this.locateAndSet(n2, bl2);
        } else {
            this.extendAndSet(n2, bl2);
        }
        return true;
    }

    private void extendAndSet(int n2, boolean bl2) {
        int n3 = this.distanceInWords(n2);
        this.sizeInBits = n2 + 1;
        if (bl2) {
            if (n3 > 0) {
                if (this.rlw.getNumberOfLiteralWords() > 0 && this.buffer.getLastWord() == 0) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(false);
                }
                if (n3 > 1) {
                    this.fastaddStreamOfEmptyWords(false, n3 - 1);
                }
                this.insertLiteralWord(1 << n2 % 32);
            }
            if (this.rlw.getNumberOfLiteralWords() == 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                this.insertLiteralWord(1 << n2 % 32);
            }
            this.buffer.orLastWord(1 << n2 % 32);
            if (this.buffer.getLastWord() == -1) {
                this.buffer.removeLastWord();
                this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                this.insertEmptyWord(true);
            }
        } else if (n3 > 0) {
            this.fastaddStreamOfEmptyWords(false, n3);
        }
    }

    private void locateAndSet(int n2, boolean bl2) {
        int n3;
        int n4 = 0;
        int n5 = this.buffer.sizeInWords();
        for (int i2 = 0; i2 < n5; i2 += n3 + 1) {
            int n6 = RunningLengthWord32.getRunningLength(this.buffer, i2);
            boolean bl3 = RunningLengthWord32.getRunningBit(this.buffer, i2);
            n3 = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, i2);
            int n7 = n6 * 32;
            if (n2 < n4 + n7) {
                this.setInRunningLength(bl2, n2, n4, i2, n6, bl3, n3);
                return;
            }
            int n8 = n3 * 32;
            if (n2 < (n4 += n7) + n8) {
                this.setInLiteralWords(bl2, n2, n4, i2, n6, bl3, n3);
                return;
            }
            n4 += n8;
        }
    }

    private void setInRunningLength(boolean bl2, int n2, int n3, int n4, int n5, boolean bl3, int n6) {
        if (bl2 != bl3) {
            int n7 = (n2 - n3) / 32 + 1;
            int n8 = n7 == n5 ? 1 : 2;
            this.buffer.expand(n4 + 1, n8);
            int n9 = 1 << n2 % 32;
            this.buffer.setWord(n4 + 1, bl2 ? n9 : ~n9);
            if (this.rlw.position >= n4 + 1) {
                this.rlw.position += n8;
            }
            if (n8 == 1) {
                this.setRLWInfo(n4, bl3, n5 - 1, n6 + 1);
            } else {
                this.setRLWInfo(n4, bl3, n7 - 1, 1);
                this.setRLWInfo(n4 + 2, bl3, n5 - n7, n6);
                if (this.rlw.position == n4) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(boolean bl2, int n2, int n3, int n4, int n5, boolean bl3, int n6) {
        int n7;
        int n8 = (n2 - n3) / 32 + 1;
        int n9 = 1 << n2 % 32;
        if (bl2) {
            this.buffer.orWord(n4 + n8, n9);
        } else {
            this.buffer.andWord(n4 + n8, ~n9);
        }
        int n10 = n7 = bl2 ? -1 : 0;
        if (this.buffer.getWord(n4 + n8) == n7) {
            boolean bl4 = this.mergeLiteralWordInCurrentRunningLength(bl2, bl3, n5, n8);
            boolean bl5 = this.mergeLiteralWordInNextRunningLength(bl2, n6, n4, n8);
            if (bl4 && bl5) {
                int n11 = RunningLengthWord32.getRunningLength(this.buffer, n4 + 2);
                int n12 = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, n4 + 2);
                this.buffer.collapse(n4, 2);
                this.setRLWInfo(n4, bl2, n5 + 1 + n11, n12);
                if (this.rlw.position >= n4 + 2) {
                    this.rlw.position -= 2;
                }
            } else if (bl4) {
                this.buffer.collapse(n4 + 1, 1);
                this.setRLWInfo(n4, bl2, n5 + 1, n6 - 1);
                if (this.rlw.position >= n4 + 2) {
                    --this.rlw.position;
                }
            } else if (bl5) {
                int n13 = n4 + n6 + 1;
                int n14 = RunningLengthWord32.getRunningLength(this.buffer, n13);
                int n15 = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, n13);
                this.buffer.collapse(n4 + n8, 1);
                this.setRLWInfo(n4, bl3, n5, n6 - 1);
                this.setRLWInfo(n4 + n8, bl2, n14 + 1, n15);
                if (this.rlw.position >= n13) {
                    this.rlw.position -= n6 + 1 - n8;
                }
            } else {
                this.setRLWInfo(n4, bl3, n5, n8 - 1);
                this.setRLWInfo(n4 + n8, bl2, 1, n6 - n8);
                if (this.rlw.position == n4) {
                    this.rlw.position += n8;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean bl2, boolean bl3, int n2, int n3) {
        return (bl2 == bl3 || n2 == 0) && n3 == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(boolean bl2, int n2, int n3, int n4) {
        int n5 = n3 + n2 + 1;
        if (n2 == n4 && n5 < this.buffer.sizeInWords()) {
            int n6 = RunningLengthWord32.getRunningLength(this.buffer, n5);
            boolean bl3 = RunningLengthWord32.getRunningBit(this.buffer, n5);
            return bl2 == bl3 || n6 == 0;
        }
        return false;
    }

    private void setRLWInfo(int n2, boolean bl2, int n3, int n4) {
        RunningLengthWord32.setRunningBit(this.buffer, n2, bl2);
        RunningLengthWord32.setRunningLength(this.buffer, n2, n3);
        RunningLengthWord32.setNumberOfLiteralWords(this.buffer, n2, n4);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int n2) {
        if ((n2 + 32 - 1) / 32 > (this.sizeInBits + 32 - 1) / 32) {
            this.setSizeInBits(n2, false);
            return;
        }
        if ((n2 + 32 - 1) / 32 != (this.sizeInBits + 32 - 1) / 32) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInbits(int,boolean): " + n2 + " " + this.sizeInBits);
        }
        this.sizeInBits = n2;
        int n3 = this.sizeInBits % 32;
        if (n3 == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                int n4 = this.rlw.getRunningBit() ? -1 >>> 32 - n3 : 0;
                this.insertLiteralWord(n4);
            }
            return;
        }
        this.buffer.andLastWord(-1 >>> 32 - n3);
    }

    public boolean setSizeInBits(int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 32 != 0) {
            if (!bl2) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    n5 = n2 - this.sizeInBits;
                    n4 = this.sizeInBits % 32;
                    n3 = 32 - n4;
                    if (this.buffer.getLastWord() == 0) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        this.buffer.removeLastWord();
                        this.sizeInBits -= n4;
                    } else if (n4 > 0) {
                        this.sizeInBits += Math.min(n5, n3);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                    this.insertLiteralWord(0);
                }
                n5 = Math.min(32 - this.sizeInBits % 32, n2 - this.sizeInBits);
                n4 = this.sizeInBits % 32;
                n3 = -1 >>> 32 - n5 << n4;
                this.buffer.orLastWord(n3);
                if (this.buffer.getLastWord() == -1) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += n5;
            }
        }
        this.addStreamOfEmptyWords(bl2, n2 / 32 - this.sizeInBits / 32);
        if (this.sizeInBits < n2) {
            n5 = this.distanceInWords(n2 - 1);
            if (n5 > 0) {
                this.insertLiteralWord(0);
            }
            if (bl2) {
                n4 = n2 - this.sizeInBits;
                n3 = this.sizeInBits % 32;
                int n6 = -1 >>> 32 - n4 << n3;
                this.buffer.orLastWord(n6);
            }
            this.sizeInBits = n2;
        }
        return true;
    }

    private int distanceInWords(int n2) {
        return (n2 + 32) / 32 - (this.sizeInBits + 32 - 1) / 32;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.sizeInWords() * 4;
    }

    public static EWAHCompressedBitmap32 threshold(int n2, EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32.thresholdWithContainer(eWAHCompressedBitmap32, n2, eWAHCompressedBitmap32Array);
        return eWAHCompressedBitmap32;
    }

    static int maxSizeInBits(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        int n2 = 0;
        for (EWAHCompressedBitmap32 eWAHCompressedBitmap32 : eWAHCompressedBitmap32Array) {
            n2 = Math.max(n2, eWAHCompressedBitmap32.sizeInBits());
        }
        return n2;
    }

    public static void thresholdWithContainer(BitmapStorage32 bitmapStorage32, int n2, EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        new RunningBitmapMerge32().symmetric(new ThresholdFuncBitmap32(n2), bitmapStorage32, eWAHCompressedBitmap32Array);
    }

    public int[] toArray() {
        int[] nArray = new int[this.cardinality()];
        int n2 = 0;
        int n3 = 0;
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        while (eWAHIterator32.hasNext()) {
            int n4;
            int n5;
            RunningLengthWord32 runningLengthWord32 = eWAHIterator32.next();
            int n6 = runningLengthWord32.getRunningLength();
            if (runningLengthWord32.getRunningBit()) {
                for (n5 = 0; n5 < n6; ++n5) {
                    for (n4 = 0; n4 < 32; ++n4) {
                        nArray[n2++] = n3++;
                    }
                }
            } else {
                n3 += 32 * n6;
            }
            n5 = runningLengthWord32.getNumberOfLiteralWords();
            n4 = eWAHIterator32.literalWords();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n7;
                for (int i3 = eWAHIterator32.buffer().getWord(n4 + i2); i3 != 0; i3 ^= n7) {
                    n7 = i3 & -i3;
                    nArray[n2++] = Integer.bitCount(n7 - 1) + n3;
                }
                n3 += 32;
            }
        }
        return nArray;
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"size in bits\":");
        stringBuilder.append(this.sizeInBits).append(", \"size in words\":");
        stringBuilder.append(this.buffer.sizeInWords()).append(",");
        EWAHIterator32 eWAHIterator32 = this.getEWAHIterator();
        stringBuilder.append(" \"content\": [");
        boolean bl2 = true;
        while (eWAHIterator32.hasNext()) {
            int n2;
            RunningLengthWord32 runningLengthWord32 = eWAHIterator32.next();
            if (!bl2) {
                stringBuilder.append(",");
            }
            bl2 = false;
            stringBuilder.append("[");
            if (runningLengthWord32.getRunningBit()) {
                stringBuilder.append(runningLengthWord32.getRunningLength()).append(",").append(" \"1x11\", ");
            } else {
                stringBuilder.append(runningLengthWord32.getRunningLength()).append(",").append(" \"0x00\", ");
            }
            stringBuilder.append("[");
            int n3 = 0;
            while (n3 + 1 < runningLengthWord32.getNumberOfLiteralWords()) {
                n2 = eWAHIterator32.buffer().getWord(eWAHIterator32.literalWords() + n3);
                stringBuilder.append("\"0x").append(Integer.toHexString(n2)).append("\",");
                ++n3;
            }
            if (n3 < runningLengthWord32.getNumberOfLiteralWords()) {
                n2 = eWAHIterator32.buffer().getWord(eWAHIterator32.literalWords() + n3);
                stringBuilder.append("\"0x").append(Integer.toHexString(n2)).append("\"");
            }
            stringBuilder.append("]]");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntIterator intIterator = this.intIterator();
        stringBuilder.append("{");
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(",");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void swap(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        this.buffer.swap(eWAHCompressedBitmap32.buffer);
        int n2 = this.rlw.position;
        this.rlw.position = eWAHCompressedBitmap32.rlw.position;
        eWAHCompressedBitmap32.rlw.position = n2;
        int n3 = this.sizeInBits;
        this.sizeInBits = eWAHCompressedBitmap32.sizeInBits;
        eWAHCompressedBitmap32.sizeInBits = n3;
    }

    public void trim() {
        this.buffer.trim();
    }

    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        int n2 = this.buffer.sizeInWords() + eWAHCompressedBitmap32.buffer.sizeInWords();
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        this.xorToContainer(eWAHCompressedBitmap32, eWAHCompressedBitmap322);
        return eWAHCompressedBitmap322;
    }

    public void xorToContainer(EWAHCompressedBitmap32 eWAHCompressedBitmap32, BitmapStorage32 bitmapStorage32) {
        int n2;
        bitmapStorage32.clear();
        EWAHIterator32 eWAHIterator32 = eWAHCompressedBitmap32.getEWAHIterator();
        EWAHIterator32 eWAHIterator322 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = new IteratingBufferedRunningLengthWord32(eWAHIterator32);
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord322 = new IteratingBufferedRunningLengthWord32(eWAHIterator322);
        while (iteratingBufferedRunningLengthWord32.size() > 0 && iteratingBufferedRunningLengthWord322.size() > 0) {
            while (iteratingBufferedRunningLengthWord32.getRunningLength() > 0 || iteratingBufferedRunningLengthWord322.getRunningLength() > 0) {
                n2 = iteratingBufferedRunningLengthWord32.getRunningLength() < iteratingBufferedRunningLengthWord322.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord323 = n2 != 0 ? iteratingBufferedRunningLengthWord32 : iteratingBufferedRunningLengthWord322;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord324 = n2 != 0 ? iteratingBufferedRunningLengthWord322 : iteratingBufferedRunningLengthWord32;
                int n3 = !iteratingBufferedRunningLengthWord324.getRunningBit() ? iteratingBufferedRunningLengthWord323.discharge(bitmapStorage32, iteratingBufferedRunningLengthWord324.getRunningLength()) : iteratingBufferedRunningLengthWord323.dischargeNegated(bitmapStorage32, iteratingBufferedRunningLengthWord324.getRunningLength());
                bitmapStorage32.addStreamOfEmptyWords(iteratingBufferedRunningLengthWord324.getRunningBit(), iteratingBufferedRunningLengthWord324.getRunningLength() - n3);
                iteratingBufferedRunningLengthWord324.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord32.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord322.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage32.addWord(iteratingBufferedRunningLengthWord32.getLiteralWordAt(i2) ^ iteratingBufferedRunningLengthWord322.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord32.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord322.discardLiteralWords(n2);
        }
        n2 = iteratingBufferedRunningLengthWord32.size() > 0 ? 1 : 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord325 = n2 != 0 ? iteratingBufferedRunningLengthWord32 : iteratingBufferedRunningLengthWord322;
        iteratingBufferedRunningLengthWord325.discharge(bitmapStorage32);
        bitmapStorage32.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap32.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        BitCounter32 bitCounter32 = new BitCounter32();
        this.xorToContainer(eWAHCompressedBitmap32, bitCounter32);
        return bitCounter32.getCount();
    }

    public EWAHCompressedBitmap32 compose(EWAHCompressedBitmap32 eWAHCompressedBitmap32) {
        int n2 = this.buffer.sizeInWords();
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        this.composeToContainer(eWAHCompressedBitmap32, eWAHCompressedBitmap322);
        return eWAHCompressedBitmap322;
    }

    public void composeToContainer(EWAHCompressedBitmap32 eWAHCompressedBitmap32, EWAHCompressedBitmap32 eWAHCompressedBitmap322) {
        eWAHCompressedBitmap322.clear();
        ChunkIterator chunkIterator = this.chunkIterator();
        ChunkIterator chunkIterator2 = eWAHCompressedBitmap32.chunkIterator();
        int n2 = 0;
        while (chunkIterator.hasNext() && chunkIterator2.hasNext()) {
            int n3;
            if (!chunkIterator.nextBit()) {
                n3 = chunkIterator.nextLength();
                eWAHCompressedBitmap322.setSizeInBits(n2 += n3, false);
                chunkIterator.move(n3);
                continue;
            }
            n3 = Math.min(chunkIterator.nextLength(), chunkIterator2.nextLength());
            eWAHCompressedBitmap322.setSizeInBits(n2 += n3, chunkIterator2.nextBit());
            chunkIterator.move(n3);
            chunkIterator2.move(n3);
        }
        eWAHCompressedBitmap322.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage32 bitmapStorage32, EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (eWAHCompressedBitmap32Array.length == 2) {
            eWAHCompressedBitmap32Array[0].andToContainer(eWAHCompressedBitmap32Array[1], bitmapStorage32);
            return;
        }
        int n2 = EWAHCompressedBitmap32.calculateInitialSize(eWAHCompressedBitmap32Array);
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32(n2);
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        eWAHCompressedBitmap32Array[0].andToContainer(eWAHCompressedBitmap32Array[1], eWAHCompressedBitmap32);
        for (int i2 = 2; i2 < eWAHCompressedBitmap32Array.length - 1; ++i2) {
            eWAHCompressedBitmap32.andToContainer(eWAHCompressedBitmap32Array[i2], eWAHCompressedBitmap322);
            eWAHCompressedBitmap322.swap(eWAHCompressedBitmap32);
            eWAHCompressedBitmap322.clear();
        }
        eWAHCompressedBitmap32.andToContainer(eWAHCompressedBitmap32Array[eWAHCompressedBitmap32Array.length - 1], bitmapStorage32);
    }

    private static int calculateInitialSize(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        int n2 = 0;
        for (EWAHCompressedBitmap32 eWAHCompressedBitmap32 : eWAHCompressedBitmap32Array) {
            n2 = Math.max(eWAHCompressedBitmap32.buffer.sizeInWords(), n2);
        }
        return n2;
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length == 1) {
            return eWAHCompressedBitmap32Array[0];
        }
        if (eWAHCompressedBitmap32Array.length == 2) {
            return eWAHCompressedBitmap32Array[0].and(eWAHCompressedBitmap32Array[1]);
        }
        int n2 = EWAHCompressedBitmap32.calculateInitialSize(eWAHCompressedBitmap32Array);
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32(n2);
        EWAHCompressedBitmap32 eWAHCompressedBitmap322 = new EWAHCompressedBitmap32(n2);
        eWAHCompressedBitmap32Array[0].andToContainer(eWAHCompressedBitmap32Array[1], eWAHCompressedBitmap32);
        for (int i2 = 2; i2 < eWAHCompressedBitmap32Array.length; ++i2) {
            eWAHCompressedBitmap32.andToContainer(eWAHCompressedBitmap32Array[i2], eWAHCompressedBitmap322);
            eWAHCompressedBitmap322.swap(eWAHCompressedBitmap32);
            eWAHCompressedBitmap322.clear();
        }
        return eWAHCompressedBitmap32;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length == 1) {
            return eWAHCompressedBitmap32Array[0].cardinality();
        }
        BitCounter32 bitCounter32 = new BitCounter32();
        EWAHCompressedBitmap32.andWithContainer(bitCounter32, eWAHCompressedBitmap32Array);
        return bitCounter32.getCount();
    }

    public static EWAHCompressedBitmap32 bitmapOf(int ... nArray) {
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32();
        for (int n2 : nArray) {
            eWAHCompressedBitmap32.set(n2);
        }
        return eWAHCompressedBitmap32;
    }

    public static void orWithContainer(BitmapStorage32 bitmapStorage32, EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + eWAHCompressedBitmap32Array.length);
        }
        FastAggregation32.orToContainer(bitmapStorage32, eWAHCompressedBitmap32Array);
    }

    public static void xorWithContainer(BitmapStorage32 bitmapStorage32, EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + eWAHCompressedBitmap32Array.length);
        }
        FastAggregation32.xorToContainer(bitmapStorage32, eWAHCompressedBitmap32Array);
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        return FastAggregation32.or(eWAHCompressedBitmap32Array);
    }

    public static EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        return FastAggregation32.xor(eWAHCompressedBitmap32Array);
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... eWAHCompressedBitmap32Array) {
        if (eWAHCompressedBitmap32Array.length == 1) {
            return eWAHCompressedBitmap32Array[0].cardinality();
        }
        BitCounter32 bitCounter32 = new BitCounter32();
        EWAHCompressedBitmap32.orWithContainer(bitCounter32, eWAHCompressedBitmap32Array);
        return bitCounter32.getCount();
    }

    public EWAHCompressedBitmap32 shift(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative shifts unsupported at the moment.");
        }
        int n3 = this.buffer.sizeInWords();
        int n4 = n2 > 0 ? n3 + (n2 + 31) / 32 : n3;
        EWAHCompressedBitmap32 eWAHCompressedBitmap32 = new EWAHCompressedBitmap32(n4);
        IteratingRLW32 iteratingRLW32 = this.getIteratingRLW();
        int n5 = n2 / 32;
        int n6 = n2 % 32;
        eWAHCompressedBitmap32.addStreamOfEmptyWords(false, n5);
        if (n6 == 0) {
            do {
                int n7;
                if ((n7 = iteratingRLW32.getRunningLength()) > 0) {
                    eWAHCompressedBitmap32.addStreamOfEmptyWords(iteratingRLW32.getRunningBit(), n7);
                }
                int n8 = iteratingRLW32.getNumberOfLiteralWords();
                for (int i2 = 0; i2 < n8; ++i2) {
                    eWAHCompressedBitmap32.addWord(iteratingRLW32.getLiteralWordAt(i2));
                }
            } while (iteratingRLW32.next());
        } else {
            boolean bl2;
            int n9 = 0;
            do {
                int n10;
                int n11 = iteratingRLW32.getRunningLength();
                boolean bl3 = bl2 = (this.sizeInBits + 32 - 1) % 32 + n6 >= 32;
                if (n11 > 0) {
                    if (iteratingRLW32.getRunningBit()) {
                        n10 = n9 | -1 << n6;
                        eWAHCompressedBitmap32.addWord(n10);
                        n9 = -1 >>> 32 - n6;
                    } else {
                        eWAHCompressedBitmap32.addWord(n9);
                        n9 = 0;
                    }
                    if (n11 > 1) {
                        eWAHCompressedBitmap32.addStreamOfEmptyWords(iteratingRLW32.getRunningBit(), n11 - 1);
                    }
                }
                n10 = iteratingRLW32.getNumberOfLiteralWords();
                for (int i3 = 0; i3 < n10; ++i3) {
                    int n12 = iteratingRLW32.getLiteralWordAt(i3);
                    int n13 = n9 | n12 << n6;
                    eWAHCompressedBitmap32.addWord(n13);
                    n9 = n12 >>> 32 - n6;
                }
            } while (iteratingRLW32.next());
            if (bl2) {
                eWAHCompressedBitmap32.addWord(n9);
            }
        }
        eWAHCompressedBitmap32.sizeInBits = this.sizeInBits + n2;
        return eWAHCompressedBitmap32;
    }
}

