/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;

final class ClearIntIterator32
implements IntIterator {
    private final EWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ClearIntIterator32(EWAHIterator32 eWAHIterator32, int n2) {
        this.ewahIter = eWAHIterator32;
        this.sizeInBits = n2;
        this.buffer = eWAHIterator32.buffer();
        this.hasNext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int n2;
        if (this.runningHasNext()) {
            n2 = this.position++;
        } else {
            int n3 = this.word & -this.word;
            n2 = this.literalPosition + Integer.bitCount(n3 - 1);
            this.word ^= n3;
        }
        this.hasNext = this.moveToNext();
        return n2;
    }

    private void setRunningLengthWord(RunningLengthWord32 runningLengthWord32) {
        this.runningLength = Math.min(this.sizeInBits, 32 * runningLengthWord32.getRunningLength() + this.position);
        if (runningLengthWord32.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + runningLengthWord32.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            int n2;
            this.word = ~this.buffer.getWord(this.wordPosition++);
            if (this.wordPosition == this.wordLength && !this.ewahIter.hasNext() && (n2 = this.sizeInBits % 32) > 0) {
                this.word &= -1 >>> 32 - n2;
            }
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

