/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;

final class ChunkIteratorImpl32
implements ChunkIterator {
    private final EWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private int word;
    private int wordMask;
    private int wordPosition;
    private int wordLength;
    private boolean hasNext;
    private Boolean nextBit;
    private int nextLength;

    ChunkIteratorImpl32(EWAHIterator32 eWAHIterator32, int n2) {
        this.ewahIter = eWAHIterator32;
        this.sizeInBits = n2;
        this.buffer = eWAHIterator32.buffer();
        this.hasNext = this.moveToNextRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean nextBit() {
        return this.nextBit;
    }

    @Override
    public int nextLength() {
        return this.nextLength;
    }

    @Override
    public void move() {
        this.move(this.nextLength);
    }

    @Override
    public void move(int n2) {
        this.nextLength -= n2;
        if (this.nextLength <= 0) {
            do {
                this.nextBit = null;
                this.updateNext();
                this.hasNext = this.moveToNextRLW();
            } while (this.nextLength <= 0 && this.hasNext);
        }
    }

    private boolean moveToNextRLW() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.hasNextRLW()) {
                return this.nextBit != null;
            }
            this.setRLW(this.nextRLW());
            this.updateNext();
        }
        return true;
    }

    private void setRLW(RunningLengthWord32 runningLengthWord32) {
        this.runningLength = Math.min(this.sizeInBits, this.position + 32 * runningLengthWord32.getRunningLength());
        this.runningBit = runningLengthWord32.getRunningBit();
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + runningLengthWord32.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordMask == 0 && this.wordPosition < this.wordLength) {
            this.word = this.buffer.getWord(this.wordPosition++);
            this.wordMask = 1;
        }
        return (this.word != 0 || this.wordMask != 0 || !this.hasNextRLW()) && this.position < this.sizeInBits;
    }

    private boolean hasNextRLW() {
        return this.ewahIter.hasNext();
    }

    private RunningLengthWord32 nextRLW() {
        return this.ewahIter.next();
    }

    private void updateNext() {
        if (this.runningHasNext()) {
            if (this.nextBit == null || this.nextBit == this.runningBit) {
                this.nextBit = this.runningBit;
                int n2 = this.runningOffset();
                this.nextLength += n2;
                this.movePosition(n2);
                this.updateNext();
            }
        } else if (this.literalHasNext()) {
            boolean bl2 = this.currentWordBit();
            if (this.nextBit == null || this.nextBit == bl2) {
                this.nextBit = bl2;
                ++this.nextLength;
                this.movePosition(1);
                this.shiftWordMask();
                this.updateNext();
            }
        } else {
            this.moveToNextRLW();
        }
    }

    private int runningOffset() {
        return this.runningLength - this.position;
    }

    private void movePosition(int n2) {
        this.position += n2;
    }

    private boolean currentWordBit() {
        return (this.word & this.wordMask) != 0;
    }

    private void shiftWordMask() {
        this.word &= ~this.wordMask;
        this.wordMask <<= 1;
    }
}

