/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.RunningLengthWord32;

public final class BufferedRunningLengthWord32
implements Cloneable {
    public int literalWordOffset = 0;
    protected int NumberOfLiteralWords;
    public boolean RunningBit;
    public int RunningLength;

    public BufferedRunningLengthWord32(int n2) {
        this.NumberOfLiteralWords = n2 >>> 17;
        this.RunningBit = (n2 & 1) != 0;
        this.RunningLength = n2 >>> 1 & 0xFFFF;
    }

    public BufferedRunningLengthWord32(RunningLengthWord32 runningLengthWord32) {
        this(runningLengthWord32.buffer.getWord(runningLengthWord32.position));
    }

    public void discardFirstWords(int n2) {
        if (this.RunningLength >= n2) {
            this.RunningLength -= n2;
            return;
        }
        this.RunningLength = 0;
        this.literalWordOffset += (n2 -= this.RunningLength);
        this.NumberOfLiteralWords -= n2;
    }

    public int getNumberOfLiteralWords() {
        return this.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.RunningBit;
    }

    public int getRunningLength() {
        return this.RunningLength;
    }

    public void reset(int n2) {
        this.NumberOfLiteralWords = n2 >>> 17;
        this.RunningBit = (n2 & 1) != 0;
        this.RunningLength = n2 >>> 1 & 0xFFFF;
        this.literalWordOffset = 0;
    }

    public void reset(RunningLengthWord32 runningLengthWord32) {
        this.reset(runningLengthWord32.buffer.getWord(runningLengthWord32.position));
    }

    public void setNumberOfLiteralWords(int n2) {
        this.NumberOfLiteralWords = n2;
    }

    public void setRunningBit(boolean bl2) {
        this.RunningBit = bl2;
    }

    public void setRunningLength(int n2) {
        this.RunningLength = n2;
    }

    public int size() {
        return this.RunningLength + this.NumberOfLiteralWords;
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public BufferedRunningLengthWord32 clone() {
        BufferedRunningLengthWord32 bufferedRunningLengthWord32 = (BufferedRunningLengthWord32)super.clone();
        bufferedRunningLengthWord32.literalWordOffset = this.literalWordOffset;
        bufferedRunningLengthWord32.NumberOfLiteralWords = this.NumberOfLiteralWords;
        bufferedRunningLengthWord32.RunningBit = this.RunningBit;
        bufferedRunningLengthWord32.RunningLength = this.RunningLength;
        return bufferedRunningLengthWord32;
    }
}

