/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Arrays;

public final class ThresholdFuncBitmap
extends UpdateableBitmapFunction {
    private final int min;
    private long[] buffers;
    private int bufferUsed;
    private final int[] bufCounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap(int n2) {
        this.min = n2;
        this.buffers = new long[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage bitmapStorage, int n2, int n3) {
        int n4 = n3 - n2;
        if (this.hammingWeight >= this.min) {
            bitmapStorage.addStreamOfEmptyWords(true, n4);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            bitmapStorage.addStreamOfEmptyWords(false, n4);
        } else {
            int n5 = this.min - this.hammingWeight;
            if (n5 == 1) {
                this.orLiterals(bitmapStorage, n2, n4);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == n5) {
                this.andLiterals(bitmapStorage, n2, n4);
            } else {
                this.generalLiterals(n5, bitmapStorage, n2, n4);
            }
        }
    }

    private long threshold2buf(int n2, long[] lArray, int n3) {
        int n4;
        long l2 = 0L;
        int[] nArray = this.bufCounters;
        System.arraycopy(zeroes64, 0, nArray, 0, 64);
        for (n4 = 0; n4 < n3; ++n4) {
            long l3;
            for (long i2 = lArray[n4]; i2 != 0L; i2 ^= l3) {
                l3 = i2 & -i2;
                int n5 = Long.bitCount(l3 - 1L);
                nArray[n5] = nArray[n5] + 1;
            }
        }
        for (n4 = 0; n4 < 64; ++n4) {
            if (nArray[n4] < n2) continue;
            l2 |= 1L << n4;
        }
        return l2;
    }

    private static long threshold3(int n2, long[] lArray, int n3) {
        if (lArray.length == 0) {
            return 0L;
        }
        long[] lArray2 = new long[n2];
        lArray2[0] = lArray[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4;
            long l2 = lArray[i2];
            for (int i3 = n4 = Math.min(n2 - 1, i2); i3 >= 1; --i3) {
                int n5 = i3;
                lArray2[n5] = lArray2[n5] | l2 & lArray2[i3 - 1];
            }
            lArray2[0] = lArray2[0] | l2;
        }
        return lArray2[n2 - 1];
    }

    private long threshold4(int n2, long[] lArray, int n3) {
        if (n2 >= 128) {
            return this.threshold2buf(n2, lArray, n3);
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += Long.bitCount(lArray[i2]);
        }
        if (2 * n4 >= n3 * n2) {
            return ThresholdFuncBitmap.threshold3(n2, lArray, n3);
        }
        return this.threshold2buf(n2, lArray, n3);
    }

    private void orLiterals(BitmapStorage bitmapStorage, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = 0L;
            for (EWAHPointer eWAHPointer : this.getLiterals()) {
                l2 |= eWAHPointer.iterator.getLiteralWordAt(i2 + n2 - eWAHPointer.beginOfRun());
            }
            bitmapStorage.addWord(l2);
        }
    }

    private void andLiterals(BitmapStorage bitmapStorage, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = -1L;
            for (EWAHPointer eWAHPointer : this.getLiterals()) {
                l2 &= eWAHPointer.iterator.getLiteralWordAt(i2 + n2 - eWAHPointer.beginOfRun());
            }
            bitmapStorage.addWord(l2);
        }
    }

    private void generalLiterals(int n2, BitmapStorage bitmapStorage, int n3, int n4) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (EWAHPointer eWAHPointer : this.getLiterals()) {
                this.buffers[n5++] = eWAHPointer.iterator.getLiteralWordAt(i2 + n3 - eWAHPointer.beginOfRun());
            }
            bitmapStorage.addWord(this.threshold4(n2, this.buffers, this.bufferUsed));
        }
    }
}

