/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;

public final class EWAHPointer
implements Comparable {
    private int endrun;
    private final int pos;
    private boolean isLiteral;
    private boolean value;
    private boolean dead = false;
    public final IteratingBufferedRunningLengthWord iterator;

    public EWAHPointer(int n2, IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord, int n3) {
        this.pos = n3;
        this.iterator = iteratingBufferedRunningLengthWord;
        if (this.iterator.getRunningLength() > 0L) {
            this.endrun = n2 + (int)this.iterator.getRunningLength();
            this.isLiteral = false;
            this.value = this.iterator.getRunningBit();
        } else if (this.iterator.getNumberOfLiteralWords() > 0) {
            this.isLiteral = true;
            this.endrun = n2 + this.iterator.getNumberOfLiteralWords();
        } else {
            this.endrun = n2;
            this.dead = true;
        }
    }

    public int endOfRun() {
        return this.endrun;
    }

    public int beginOfRun() {
        if (this.isLiteral) {
            return this.endrun - this.iterator.getNumberOfLiteralWords();
        }
        return (int)((long)this.endrun - this.iterator.getRunningLength());
    }

    public void parseNextRun() {
        if (this.isLiteral || this.iterator.getNumberOfLiteralWords() == 0) {
            this.iterator.discardFirstWords(this.iterator.size());
            if (this.iterator.getRunningLength() > 0L) {
                this.endrun += (int)this.iterator.getRunningLength();
                this.isLiteral = false;
                this.value = this.iterator.getRunningBit();
            } else if (this.iterator.getNumberOfLiteralWords() > 0) {
                this.isLiteral = true;
                this.endrun += this.iterator.getNumberOfLiteralWords();
            } else {
                this.dead = true;
            }
        } else {
            this.isLiteral = true;
            this.endrun += this.iterator.getNumberOfLiteralWords();
        }
    }

    public boolean hasNoData() {
        return this.dead;
    }

    public void callbackUpdate(UpdateableBitmapFunction updateableBitmapFunction) {
        if (this.dead) {
            updateableBitmapFunction.setZero(this.pos);
        } else if (this.isLiteral) {
            updateableBitmapFunction.setLiteral(this.pos);
        } else if (this.value) {
            updateableBitmapFunction.setOne(this.pos);
        } else {
            updateableBitmapFunction.setZero(this.pos);
        }
    }

    public int compareTo(EWAHPointer eWAHPointer) {
        return this.endrun - eWAHPointer.endrun;
    }
}

