/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import java.util.Comparator;

public final class PriorityQ {
    final Object[] a;
    int lastIndex;
    final Comparator comp;

    public PriorityQ(int n2, Comparator comparator) {
        this.a = new Object[n2 + 1];
        this.lastIndex = 0;
        this.comp = comparator;
    }

    public int size() {
        return this.lastIndex;
    }

    private int compare(Object object, Object object2) {
        return this.comp.compare(object, object2);
    }

    public void toss(Object object) {
        this.a[++this.lastIndex] = object;
    }

    public Object peek() {
        return this.a[1];
    }

    public void buildHeap() {
        for (int i2 = this.lastIndex / 2; i2 > 0; --i2) {
            this.percolateDown(i2);
        }
    }

    public void percolateDown() {
        this.percolateDown(1);
    }

    private void percolateDown(int n2) {
        Object object = this.a[n2];
        while (true) {
            int n3 = 2 * n2;
            int n4 = n3 + 1;
            int n5 = n2;
            if (n4 <= this.lastIndex) {
                if (this.compare(this.a[n3], object) < 0) {
                    n5 = n3;
                    if (this.compare(this.a[n4], this.a[n5]) < 0) {
                        n5 = n4;
                    }
                } else if (this.compare(this.a[n4], object) < 0) {
                    n5 = n4;
                }
            } else if (n3 <= this.lastIndex && this.compare(this.a[n3], object) < 0) {
                n5 = n3;
            }
            if (n2 == n5) break;
            this.a[n2] = this.a[n5];
            n2 = n5;
        }
        this.a[n5] = object;
    }

    public Object poll() {
        Object object = this.a[1];
        this.a[1] = this.a[this.lastIndex--];
        this.percolateDown(1);
        return object;
    }

    public boolean isEmpty() {
        return this.lastIndex == 0;
    }
}

