/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.datastructure.BitSet;
import com.googlecode.javaewah.datastructure.ImmutableBitSet$1;
import com.googlecode.javaewah.datastructure.ImmutableBitSet$2;
import com.googlecode.javaewah.datastructure.ImmutableBitSet$3;
import com.googlecode.javaewah.datastructure.WordArray;
import java.nio.LongBuffer;
import java.util.Iterator;

public class ImmutableBitSet
implements WordArray,
Cloneable,
Iterable {
    private LongBuffer data;

    public ImmutableBitSet(LongBuffer longBuffer) {
        int n2 = (int)longBuffer.get(0);
        LongBuffer longBuffer2 = longBuffer.slice();
        longBuffer2.position(1);
        this.data = longBuffer2.slice();
        this.data.limit(n2);
    }

    public BitSet asBitSet() {
        BitSet bitSet = new BitSet(this.size());
        this.data.rewind();
        this.data.get(bitSet.data, 0, bitSet.data.length);
        return bitSet;
    }

    public int cardinality() {
        int n2 = 0;
        int n3 = this.data.limit();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += Long.bitCount(this.data.get(i2));
        }
        return n2;
    }

    public ImmutableBitSet clone() {
        try {
            ImmutableBitSet immutableBitSet = (ImmutableBitSet)super.clone();
            immutableBitSet.data = this.data.duplicate();
            return immutableBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WordArray) {
            WordArray wordArray = (WordArray)object;
            for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
                if (this.getWord(i2) == wordArray.getWord(i2)) continue;
                return false;
            }
            WordArray wordArray2 = wordArray.getNumberOfWords() < this.getNumberOfWords() ? this : wordArray;
            for (int i3 = Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); i3 < Math.max(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i3) {
                if (wordArray2.getWord(i3) == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean empty() {
        int n2 = this.data.limit();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.data.get(i2) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n2) {
        return (this.data.get(n2 / 64) & 1L << n2 % 64) != 0L;
    }

    public int hashCode() {
        int n2 = 31;
        long l2 = 0L;
        int n3 = this.data.limit();
        for (int i2 = 0; i2 < n3; ++i2) {
            long l3 = this.data.get(i2);
            l2 = l2 * (long)n2 + l3;
        }
        return (int)l2;
    }

    public IntIterator intIterator() {
        return new ImmutableBitSet$1(this);
    }

    public Iterator iterator() {
        return new ImmutableBitSet$2(this);
    }

    public boolean intersects(BitSet bitSet) {
        for (int i2 = 0; i2 < Math.min(this.data.limit(), bitSet.data.length); ++i2) {
            if ((this.data.get(i2) & bitSet.data[i2]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int n2) {
        int n3 = n2 / 64;
        if (n3 >= this.data.limit()) {
            return -1;
        }
        long l2 = this.data.get(n3);
        if ((l2 >>>= n2 % 64) != 0L) {
            return n2 + Long.numberOfTrailingZeros(l2);
        }
        ++n3;
        while (n3 < this.data.limit()) {
            if (this.data.get(n3) != 0L) {
                return n3 * 64 + Long.numberOfTrailingZeros(this.data.get(n3));
            }
            ++n3;
        }
        return -1;
    }

    public int nextUnsetBit(int n2) {
        int n3 = n2 / 64;
        if (n3 >= this.data.limit()) {
            return -1;
        }
        long l2 = this.data.get(n3) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((l2 >>>= n2 % 64) != 0L) {
            return n2 + Long.numberOfTrailingZeros(l2);
        }
        ++n3;
        while (n3 < this.data.limit()) {
            if (this.data.get(n3) != -1L) {
                return n3 * 64 + Long.numberOfTrailingZeros(this.data.get(n3) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++n3;
        }
        return -1;
    }

    public int size() {
        return this.data.limit() * 64;
    }

    public IntIterator unsetIntIterator() {
        return new ImmutableBitSet$3(this);
    }

    @Override
    public int getNumberOfWords() {
        return this.data.limit();
    }

    @Override
    public long getWord(int n2) {
        return this.data.get(n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntIterator intIterator = this.intIterator();
        stringBuilder.append("{");
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(",");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

