/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.datastructure.BitSet$1;
import com.googlecode.javaewah.datastructure.BitSet$2;
import com.googlecode.javaewah.datastructure.BitSet$3;
import com.googlecode.javaewah.datastructure.WordArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;

public class BitSet
implements WordArray,
Externalizable,
Cloneable,
Iterable {
    long[] data;
    static final long serialVersionUID = 7997698588986878754L;

    public BitSet(int n2) {
        this.data = new long[(n2 + 63) / 64];
    }

    public BitSet() {
        this.data = new long[0];
    }

    public void and(WordArray wordArray) {
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] & wordArray.getWord(i2);
        }
    }

    public int andcardinality(WordArray wordArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            n2 += Long.bitCount(this.getWord(i2) & wordArray.getWord(i2));
        }
        return n2;
    }

    public void andNot(WordArray wordArray) {
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] & (wordArray.getWord(i2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int andNotcardinality(WordArray wordArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            n2 += Long.bitCount(this.getWord(i2) & (wordArray.getWord(i2) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return n2;
    }

    public int cardinality() {
        int n2 = 0;
        for (long l2 : this.data) {
            n2 += Long.bitCount(l2);
        }
        return n2;
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public void clear(int n2) {
        this.unset(n2);
    }

    public void clear(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n2 / 64;
        int n5 = (n3 - 1) / 64;
        if (n4 == n5) {
            int n6 = n4;
            this.data[n6] = this.data[n6] & (-1L << n2 & -1L >>> -n3 ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n7 = n4;
        this.data[n7] = this.data[n7] & (-1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i2 = n4 + 1; i2 < n5; ++i2) {
            this.data[i2] = 0L;
        }
        int n8 = n5;
        this.data[n8] = this.data[n8] & (-1L >>> -n3 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public BitSet clone() {
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.data = Arrays.copyOf(this.data, this.getNumberOfWords());
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WordArray) {
            WordArray wordArray = (WordArray)object;
            for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
                if (this.getWord(i2) == wordArray.getWord(i2)) continue;
                return false;
            }
            WordArray wordArray2 = wordArray.getNumberOfWords() < this.getNumberOfWords() ? this : wordArray;
            for (int i3 = Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); i3 < Math.max(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i3) {
                if (wordArray2.getWord(i3) == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean empty() {
        for (long l2 : this.data) {
            if (l2 == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int n2) {
        int n3 = n2 / 64;
        this.data[n3] = this.data[n3] ^ 1L << n2 % 64;
    }

    public void flip(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n2 / 64;
        int n5 = (n3 - 1) / 64;
        int n6 = n4;
        this.data[n6] = this.data[n6] ^ (-1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i2 = n4; i2 < n5; ++i2) {
            this.data[i2] = this.data[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n7 = n5;
        this.data[n7] = this.data[n7] ^ -1L >>> -n3;
    }

    public boolean get(int n2) {
        return (this.data[n2 / 64] & 1L << n2 % 64) != 0L;
    }

    public int hashCode() {
        int n2 = 31;
        long l2 = 0L;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            long l3 = this.getWord(i2);
            l2 = l2 * (long)n2 + l3;
        }
        return (int)l2;
    }

    public IntIterator intIterator() {
        return new BitSet$1(this);
    }

    public Iterator iterator() {
        return new BitSet$2(this);
    }

    public boolean intersects(WordArray wordArray) {
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            if ((this.getWord(i2) & wordArray.getWord(i2)) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int n2) {
        int n3 = n2 / 64;
        if (n3 >= this.getNumberOfWords()) {
            return -1;
        }
        long l2 = this.data[n3];
        if ((l2 >>>= n2) != 0L) {
            return n2 + Long.numberOfTrailingZeros(l2);
        }
        ++n3;
        while (n3 < this.getNumberOfWords()) {
            if (this.data[n3] != 0L) {
                return n3 * 64 + Long.numberOfTrailingZeros(this.data[n3]);
            }
            ++n3;
        }
        return -1;
    }

    public int nextUnsetBit(int n2) {
        int n3 = n2 / 64;
        if (n3 >= this.getNumberOfWords()) {
            return -1;
        }
        long l2 = this.data[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((l2 >>>= n2) != 0L) {
            return n2 + Long.numberOfTrailingZeros(l2);
        }
        ++n3;
        while (n3 < this.getNumberOfWords()) {
            if (this.data[n3] != -1L) {
                return n3 * 64 + Long.numberOfTrailingZeros(this.data[n3] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++n3;
        }
        return -1;
    }

    public void or(WordArray wordArray) {
        if (this.getNumberOfWords() < wordArray.getNumberOfWords()) {
            this.resize(wordArray.getNumberOfWords() * 64);
        }
        for (int i2 = 0; i2 < this.getNumberOfWords(); ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] | wordArray.getWord(i2);
        }
    }

    public int orcardinality(WordArray wordArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            n2 += Long.bitCount(this.getWord(i2) | wordArray.getWord(i2));
        }
        WordArray wordArray2 = wordArray.getNumberOfWords() < this.getNumberOfWords() ? this : wordArray;
        for (int i3 = Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); i3 < Math.max(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i3) {
            n2 += Long.bitCount(wordArray2.getWord(i3));
        }
        return n2;
    }

    public void removeWord(int n2) {
        long[] lArray = new long[this.data.length - 1];
        if (n2 == 0) {
            System.arraycopy(this.data, 1, lArray, 0, n2 - 1);
        }
        System.arraycopy(this.data, 0, lArray, 0, n2 - 1);
        System.arraycopy(this.data, n2, lArray, n2 - 1, this.data.length - n2);
        this.data = lArray;
    }

    public void resize(int n2) {
        this.data = Arrays.copyOf(this.data, (n2 + 63) / 64);
    }

    public void set(int n2) {
        int n3 = n2 / 64;
        this.data[n3] = this.data[n3] | 1L << n2 % 64;
    }

    public void set(int n2, boolean bl2) {
        if (bl2) {
            this.set(n2);
        } else {
            this.unset(n2);
        }
    }

    public void set(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n2 / 64;
        int n5 = (n3 - 1) / 64;
        if (n4 == n5) {
            int n6 = n4;
            this.data[n6] = this.data[n6] | -1L << n2 & -1L >>> -n3;
            return;
        }
        int n7 = n4;
        this.data[n7] = this.data[n7] | -1L << n2;
        for (int i2 = n4 + 1; i2 < n5; ++i2) {
            this.data[i2] = -1L;
        }
        int n8 = n5;
        this.data[n8] = this.data[n8] | -1L >>> -n3;
    }

    public void set(int n2, int n3, boolean bl2) {
        if (bl2) {
            this.set(n2, n3);
        } else {
            this.clear(n2, n3);
        }
    }

    public int size() {
        return this.getNumberOfWords() * 64;
    }

    public void trim() {
        for (int i2 = this.getNumberOfWords() - 1; i2 >= 0; --i2) {
            if (this.getWord(i2) == 0L) continue;
            if (i2 + 1 < this.getNumberOfWords()) {
                this.data = Arrays.copyOf(this.data, i2 + 1);
            }
            return;
        }
        this.data = new long[0];
    }

    public void unset(int n2) {
        int n3 = n2 / 64;
        this.data[n3] = this.data[n3] & (1L << n2 % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IntIterator unsetIntIterator() {
        return new BitSet$3(this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        this.serialize(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        this.deserialize(objectInput);
    }

    public void serialize(DataOutput dataOutput) {
        dataOutput.writeLong(this.getNumberOfWords());
        for (long l2 : this.data) {
            dataOutput.writeLong(l2);
        }
    }

    public void deserialize(DataInput dataInput) {
        int n2 = (int)dataInput.readLong();
        this.data = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.data[i2] = dataInput.readLong();
        }
    }

    public void xor(WordArray wordArray) {
        if (this.getNumberOfWords() < wordArray.getNumberOfWords()) {
            this.resize(wordArray.getNumberOfWords() * 64);
        }
        for (int i2 = 0; i2 < this.getNumberOfWords(); ++i2) {
            int n2 = i2;
            this.data[n2] = this.data[n2] ^ wordArray.getWord(i2);
        }
    }

    public int xorcardinality(WordArray wordArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords()); ++i2) {
            n2 += Long.bitCount(this.getWord(i2) ^ wordArray.getWord(i2));
        }
        WordArray wordArray2 = wordArray.getNumberOfWords() < this.getNumberOfWords() ? this : wordArray;
        int n3 = Math.min(this.getNumberOfWords(), wordArray.getNumberOfWords());
        int n4 = Math.max(this.getNumberOfWords(), wordArray.getNumberOfWords());
        for (int i3 = n3; i3 < n4; ++i3) {
            n2 += Long.bitCount(wordArray2.getWord(i3));
        }
        return n2;
    }

    @Override
    public int getNumberOfWords() {
        return this.data.length;
    }

    @Override
    public long getWord(int n2) {
        return this.data[n2];
    }

    public static BitSet bitmapOf(int ... nArray) {
        int n2 = 0;
        for (int n3 : nArray) {
            if (n2 >= n3) continue;
            n2 = n3;
        }
        Object object = new BitSet(n2 + 1);
        for (int n4 : nArray) {
            ((BitSet)object).set(n4);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntIterator intIterator = this.intIterator();
        stringBuilder.append("{");
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(",");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

