/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;

public final class RunningLengthWord
implements Cloneable {
    final Buffer buffer;
    int position;
    public static final int RUNNING_LENGTH_BITS = 32;
    private static final int LITERAL_BITS = 31;
    public static final int LARGEST_LITERAL_COUNT = Integer.MAX_VALUE;
    public static final long LARGEST_RUNNING_LENGTH_COUNT = 0xFFFFFFFFL;
    private static final long RUNNING_LENGTH_PLUS_RUNNING_BIT = 0x1FFFFFFFFL;
    private static final long SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = 0x1FFFFFFFEL;
    private static final long NOT_RUNNING_LENGTH_PLUS_RUNNING_BIT = -8589934592L;
    private static final long NOT_SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = -8589934591L;

    RunningLengthWord(Buffer buffer, int n2) {
        this.buffer = buffer;
        this.position = n2;
    }

    public int getNumberOfLiteralWords() {
        return RunningLengthWord.getNumberOfLiteralWords(this.buffer, this.position);
    }

    static int getNumberOfLiteralWords(Buffer buffer, int n2) {
        return (int)(buffer.getWord(n2) >>> 33);
    }

    public boolean getRunningBit() {
        return RunningLengthWord.getRunningBit(this.buffer, this.position);
    }

    static boolean getRunningBit(Buffer buffer, int n2) {
        return (buffer.getWord(n2) & 1L) != 0L;
    }

    public long getRunningLength() {
        return RunningLengthWord.getRunningLength(this.buffer, this.position);
    }

    static long getRunningLength(Buffer buffer, int n2) {
        return buffer.getWord(n2) >>> 1 & 0xFFFFFFFFL;
    }

    public void setNumberOfLiteralWords(long l2) {
        RunningLengthWord.setNumberOfLiteralWords(this.buffer, this.position, l2);
    }

    static void setNumberOfLiteralWords(Buffer buffer, int n2, long l2) {
        buffer.orWord(n2, -8589934592L);
        buffer.andWord(n2, l2 << 33 | 0x1FFFFFFFFL);
    }

    public void setRunningBit(boolean bl2) {
        RunningLengthWord.setRunningBit(this.buffer, this.position, bl2);
    }

    static void setRunningBit(Buffer buffer, int n2, boolean bl2) {
        if (bl2) {
            buffer.orWord(n2, 1L);
        } else {
            buffer.andWord(n2, -2L);
        }
    }

    public void setRunningLength(long l2) {
        RunningLengthWord.setRunningLength(this.buffer, this.position, l2);
    }

    static void setRunningLength(Buffer buffer, int n2, long l2) {
        buffer.orWord(n2, 0x1FFFFFFFEL);
        buffer.andWord(n2, l2 << 1 | 0xFFFFFFFE00000001L);
    }

    public long size() {
        return this.getRunningLength() + (long)this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public RunningLengthWord clone() {
        return (RunningLengthWord)super.clone();
    }
}

