/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.ReverseEWAHIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class ReverseIntIterator
implements IntIterator {
    private final ReverseEWAHIterator ewahIter;
    private final int sizeInBits;
    private final Buffer buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator(ReverseEWAHIterator reverseEWAHIterator, int n2) {
        this.ewahIter = reverseEWAHIterator;
        this.sizeInBits = n2;
        this.buffer = reverseEWAHIterator.buffer();
        this.runningLength = n2 - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int n2;
        if (this.literalHasNext()) {
            long l2 = this.word & -this.word;
            n2 = this.literalPosition - Long.bitCount(l2 - 1L);
            this.word ^= l2;
        } else {
            n2 = this.position--;
        }
        this.hasNext = this.moveToPreviousRLW();
        return n2;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord runningLengthWord) {
        int n2;
        this.wordLength = runningLengthWord.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength = (int)((long)this.runningLength - 64L * (runningLengthWord.getRunningLength() + (long)this.wordLength));
        if (this.position == this.sizeInBits - 1 && (n2 = this.sizeInBits % 64) > 0) {
            this.runningLength += 64 - n2;
            if (this.wordLength > 0) {
                this.word = Long.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
                this.word >>>= 64 - n2;
                this.literalPosition = this.position;
                this.position -= n2;
            }
        }
        this.runningBit = runningLengthWord.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordLength > 0) {
            this.word = Long.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            this.literalPosition = this.position;
            this.position -= 64;
        }
        return this.word != 0L;
    }
}

