/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import java.nio.LongBuffer;

final class LongBufferWrapper
implements Buffer,
Cloneable {
    private int actualSizeInWords = 1;
    private LongBuffer buffer;

    public LongBufferWrapper(LongBuffer longBuffer) {
        this.buffer = longBuffer;
    }

    public LongBufferWrapper(LongBuffer longBuffer, int n2) {
        this.buffer = longBuffer;
        this.actualSizeInWords = n2;
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int n2) {
        if (n2 > this.buffer.capacity()) {
            throw new RuntimeException("Cannot increase buffer capacity. Current capacity: " + this.buffer.capacity() + ". New capacity: " + n2);
        }
    }

    @Override
    public long getWord(int n2) {
        return this.buffer.get(n2);
    }

    @Override
    public long getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.setWord(0, 0L);
    }

    @Override
    public void trim() {
    }

    @Override
    public void setWord(int n2, long l2) {
        this.buffer.put(n2, l2);
    }

    @Override
    public void setLastWord(long l2) {
        this.setWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void push_back(long l2) {
        this.setWord(this.actualSizeInWords++, l2);
    }

    @Override
    public void push_back(Buffer buffer, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.push_back(buffer.getWord(n2 + i2));
        }
    }

    @Override
    public void negative_push_back(Buffer buffer, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.push_back(buffer.getWord(n2 + i2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0L);
    }

    @Override
    public void negateWord(int n2) {
        this.setWord(n2, this.getWord(n2) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void andWord(int n2, long l2) {
        this.setWord(n2, this.getWord(n2) & l2);
    }

    @Override
    public void orWord(int n2, long l2) {
        this.setWord(n2, this.getWord(n2) | l2);
    }

    @Override
    public void andLastWord(long l2) {
        this.andWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void orLastWord(long l2) {
        this.orWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void expand(int n2, int n3) {
        for (int i2 = this.actualSizeInWords - n2 - 1; i2 >= 0; --i2) {
            this.setWord(n2 + n3 + i2, this.getWord(n2 + i2));
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void collapse(int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.actualSizeInWords - n2 - n3; ++n4) {
            this.setWord(n2 + n4, this.getWord(n2 + n3 + n4));
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.removeLastWord();
        }
    }

    @Override
    public LongBufferWrapper clone() {
        return new LongBufferWrapper(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void swap(Buffer buffer) {
        if (buffer instanceof LongBufferWrapper) {
            LongBufferWrapper longBufferWrapper = (LongBufferWrapper)buffer;
            LongBuffer longBuffer = this.buffer;
            int n2 = this.actualSizeInWords;
            this.actualSizeInWords = longBufferWrapper.actualSizeInWords;
            this.buffer = longBufferWrapper.buffer;
            longBufferWrapper.actualSizeInWords = n2;
            longBufferWrapper.buffer = longBuffer;
        } else {
            buffer.swap(this);
        }
    }
}

