/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import java.util.Arrays;

final class LongArray
implements Buffer,
Cloneable {
    private int actualSizeInWords = 1;
    private long[] buffer = null;
    private static final int DEFAULT_BUFFER_SIZE = 4;

    public LongArray() {
        this(4);
    }

    public LongArray(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.buffer = new long[n2];
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int n2) {
        this.resizeBuffer(n2 - this.actualSizeInWords);
    }

    @Override
    public long getWord(int n2) {
        return this.buffer[n2];
    }

    @Override
    public long getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.buffer[0] = 0L;
    }

    @Override
    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void setWord(int n2, long l2) {
        this.buffer[n2] = l2;
    }

    @Override
    public void setLastWord(long l2) {
        this.setWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void push_back(long l2) {
        this.resizeBuffer(1);
        this.buffer[this.actualSizeInWords++] = l2;
    }

    @Override
    public void push_back(Buffer buffer, int n2, int n3) {
        this.resizeBuffer(n3);
        if (buffer instanceof LongArray) {
            long[] lArray = ((LongArray)buffer).buffer;
            System.arraycopy(lArray, n2, this.buffer, this.actualSizeInWords, n3);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.buffer[this.actualSizeInWords + i2] = buffer.getWord(n2 + i2);
            }
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void negative_push_back(Buffer buffer, int n2, int n3) {
        this.resizeBuffer(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.buffer[this.actualSizeInWords + i2] = buffer.getWord(n2 + i2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualSizeInWords += n3;
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0L);
    }

    @Override
    public void negateWord(int n2) {
        this.buffer[n2] = this.buffer[n2] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void andWord(int n2, long l2) {
        int n3 = n2;
        this.buffer[n3] = this.buffer[n3] & l2;
    }

    @Override
    public void orWord(int n2, long l2) {
        int n3 = n2;
        this.buffer[n3] = this.buffer[n3] | l2;
    }

    @Override
    public void andLastWord(long l2) {
        this.andWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void orLastWord(long l2) {
        this.orWord(this.actualSizeInWords - 1, l2);
    }

    @Override
    public void expand(int n2, int n3) {
        this.resizeBuffer(n3);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + n3, this.actualSizeInWords - n2);
        this.actualSizeInWords += n3;
    }

    @Override
    public void collapse(int n2, int n3) {
        System.arraycopy(this.buffer, n2 + n3, this.buffer, n2, this.actualSizeInWords - n2 - n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.removeLastWord();
        }
    }

    @Override
    public LongArray clone() {
        LongArray longArray = null;
        try {
            longArray = (LongArray)super.clone();
            longArray.buffer = (long[])this.buffer.clone();
            longArray.actualSizeInWords = this.actualSizeInWords;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return longArray;
    }

    @Override
    public void swap(Buffer buffer) {
        if (buffer instanceof LongArray) {
            long[] lArray = this.buffer;
            this.buffer = ((LongArray)buffer).buffer;
            ((LongArray)buffer).buffer = lArray;
            int n2 = this.actualSizeInWords;
            this.actualSizeInWords = ((LongArray)buffer).actualSizeInWords;
            ((LongArray)buffer).actualSizeInWords = n2;
        } else {
            int n3;
            long[] lArray = new long[buffer.sizeInWords()];
            for (n3 = 0; n3 < buffer.sizeInWords(); ++n3) {
                lArray[n3] = buffer.getWord(n3);
            }
            n3 = buffer.sizeInWords();
            buffer.clear();
            buffer.removeLastWord();
            buffer.push_back(this, 0, this.sizeInWords());
            this.buffer = lArray;
            this.actualSizeInWords = n3;
        }
    }

    private void resizeBuffer(int n2) {
        int n3 = this.newSizeInWords(n2);
        if (n3 >= this.buffer.length) {
            long[] lArray = this.buffer;
            this.buffer = new long[n3];
            System.arraycopy(lArray, 0, this.buffer, 0, lArray.length);
        }
    }

    private int newSizeInWords(int n2) {
        int n3 = this.actualSizeInWords + n2;
        if (n3 >= this.buffer.length) {
            n3 = n3 < 32768 ? (n3 *= 2) : (n3 * 3 / 2 < n3 ? Integer.MAX_VALUE : n3 * 3 / 2);
        }
        return n3;
    }
}

