/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorOverIteratingRLW;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorUtil$1;
import java.util.Iterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static IntIterator toSetBitsIntIterator(IteratingRLW iteratingRLW) {
        return new IntIteratorOverIteratingRLW(iteratingRLW);
    }

    public static Iterator toSetBitsIterator(IteratingRLW iteratingRLW) {
        return new IteratorUtil$1(iteratingRLW);
    }

    public static void materialize(IteratingRLW iteratingRLW, BitmapStorage bitmapStorage) {
        do {
            if (iteratingRLW.getRunningLength() > 0L) {
                bitmapStorage.addStreamOfEmptyWords(iteratingRLW.getRunningBit(), iteratingRLW.getRunningLength());
            }
            int n2 = iteratingRLW.getNumberOfLiteralWords();
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(i2));
            }
        } while (iteratingRLW.next());
    }

    public static int cardinality(IteratingRLW iteratingRLW) {
        int n2 = 0;
        do {
            if (iteratingRLW.getRunningBit()) {
                n2 += (int)(iteratingRLW.getRunningLength() * 64L);
            }
            int n3 = iteratingRLW.getNumberOfLiteralWords();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += Long.bitCount(iteratingRLW.getLiteralWordAt(i2));
            }
        } while (iteratingRLW.next());
        return n2;
    }

    public static IteratingRLW[] toIterators(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        IteratingRLW[] iteratingRLWArray = new IteratingRLW[eWAHCompressedBitmapArray.length];
        for (int i2 = 0; i2 < iteratingRLWArray.length; ++i2) {
            iteratingRLWArray[i2] = new IteratingBufferedRunningLengthWord(eWAHCompressedBitmapArray[i2]);
        }
        return iteratingRLWArray;
    }

    public static long materialize(IteratingRLW iteratingRLW, BitmapStorage bitmapStorage, long l2) {
        long l3 = l2;
        do {
            long l4;
            if (iteratingRLW.getRunningLength() > 0L) {
                l4 = iteratingRLW.getRunningLength();
                if (l4 > l2) {
                    l4 = l2;
                }
                bitmapStorage.addStreamOfEmptyWords(iteratingRLW.getRunningBit(), l4);
                l2 -= l4;
            }
            l4 = iteratingRLW.getNumberOfLiteralWords();
            int n2 = 0;
            while ((long)n2 < l4) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(n2));
                ++n2;
            }
        } while (l2 > 0L && iteratingRLW.next());
        return l3 - l2;
    }

    public static EWAHCompressedBitmap materialize(IteratingRLW iteratingRLW) {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap();
        IteratorUtil.materialize(iteratingRLW, eWAHCompressedBitmap);
        return eWAHCompressedBitmap;
    }
}

