/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.BufferedAndIterator;
import com.googlecode.javaewah.BufferedIterator;
import com.googlecode.javaewah.BufferedORIterator;
import com.googlecode.javaewah.BufferedXORIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation$1;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public final class IteratorAggregation {
    public static final int DEFAULT_MAX_BUF_SIZE = 65536;

    private IteratorAggregation() {
    }

    public static IteratingRLW not(IteratingRLW iteratingRLW) {
        return new IteratorAggregation$1(iteratingRLW);
    }

    public static IteratingRLW bufferedand(IteratingRLW ... iteratingRLWArray) {
        return IteratorAggregation.bufferedand(65536, iteratingRLWArray);
    }

    public static IteratingRLW bufferedand(int n2, IteratingRLW ... iteratingRLWArray) {
        if (iteratingRLWArray.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLWArray.length == 1) {
            return iteratingRLWArray[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLWArray);
        return new BufferedIterator(new BufferedAndIterator(linkedList, n2));
    }

    public static IteratingRLW bufferedor(IteratingRLW ... iteratingRLWArray) {
        return IteratorAggregation.bufferedor(65536, iteratingRLWArray);
    }

    public static IteratingRLW bufferedor(int n2, IteratingRLW ... iteratingRLWArray) {
        if (iteratingRLWArray.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLWArray.length == 1) {
            return iteratingRLWArray[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLWArray);
        return new BufferedIterator(new BufferedORIterator(linkedList, n2));
    }

    public static IteratingRLW bufferedxor(IteratingRLW ... iteratingRLWArray) {
        return IteratorAggregation.bufferedxor(65536, iteratingRLWArray);
    }

    public static IteratingRLW bufferedxor(int n2, IteratingRLW ... iteratingRLWArray) {
        if (iteratingRLWArray.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (iteratingRLWArray.length == 1) {
            return iteratingRLWArray[0];
        }
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, iteratingRLWArray);
        return new BufferedIterator(new BufferedXORIterator(linkedList, n2));
    }

    protected static void dischargeAsEmpty(BitmapStorage bitmapStorage, IteratingRLW iteratingRLW) {
        while (iteratingRLW.size() > 0L) {
            bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW.size());
            iteratingRLW.next();
        }
    }

    protected static long discharge(BitmapStorage bitmapStorage, IteratingRLW iteratingRLW, long l2) {
        long l3;
        long l4;
        for (l3 = 0L; iteratingRLW.size() > 0L && l3 < l2; l3 += l4) {
            long l5 = iteratingRLW.getRunningLength();
            if (l5 > 0L) {
                if (l5 + l3 > l2) {
                    l5 = l2 - l3;
                }
                bitmapStorage.addStreamOfEmptyWords(iteratingRLW.getRunningBit(), l5);
                l3 += l5;
            }
            if ((l4 = (long)iteratingRLW.getNumberOfLiteralWords()) + l3 > l2) {
                l4 = l2 - l3;
            }
            int n2 = 0;
            while ((long)n2 < l4) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(n2));
                ++n2;
            }
            iteratingRLW.discardFirstWords(l4 + l5);
        }
        return l3;
    }

    protected static long dischargeNegated(BitmapStorage bitmapStorage, IteratingRLW iteratingRLW, long l2) {
        long l3;
        long l4;
        for (l3 = 0L; iteratingRLW.size() > 0L && l3 < l2; l3 += l4) {
            long l5 = iteratingRLW.getRunningLength();
            if (l5 > 0L) {
                if (l5 + l3 > l2) {
                    l5 = l2 - l3;
                }
                bitmapStorage.addStreamOfEmptyWords(!iteratingRLW.getRunningBit(), l5);
                l3 += l5;
            }
            if ((l4 = (long)iteratingRLW.getNumberOfLiteralWords()) + l3 > l2) {
                l4 = l2 - l3;
            }
            int n2 = 0;
            while ((long)n2 < l4) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(n2) ^ 0xFFFFFFFFFFFFFFFFL);
                ++n2;
            }
            iteratingRLW.discardFirstWords(l4 + l5);
        }
        return l3;
    }

    static void andToContainer(BitmapStorage bitmapStorage, int n2, IteratingRLW iteratingRLW, IteratingRLW iteratingRLW2) {
        while (iteratingRLW.size() > 0L && iteratingRLW2.size() > 0L && n2-- > 0) {
            int n3;
            while (iteratingRLW.getRunningLength() > 0L || iteratingRLW2.getRunningLength() > 0L) {
                IteratingRLW iteratingRLW3;
                n3 = iteratingRLW.getRunningLength() < iteratingRLW2.getRunningLength() ? 1 : 0;
                IteratingRLW iteratingRLW4 = n3 != 0 ? iteratingRLW : iteratingRLW2;
                IteratingRLW iteratingRLW5 = iteratingRLW3 = n3 != 0 ? iteratingRLW2 : iteratingRLW;
                if (!iteratingRLW3.getRunningBit()) {
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW3.getRunningLength());
                    iteratingRLW4.discardFirstWords(iteratingRLW3.getRunningLength());
                    iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
                    continue;
                }
                long l2 = IteratorAggregation.discharge(bitmapStorage, iteratingRLW4, iteratingRLW3.getRunningLength());
                bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW3.getRunningLength() - l2);
                iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
            }
            n3 = Math.min(iteratingRLW.getNumberOfLiteralWords(), iteratingRLW2.getNumberOfLiteralWords());
            if (n3 <= 0) continue;
            n2 -= n3;
            for (int i2 = 0; i2 < n3; ++i2) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(i2) & iteratingRLW2.getLiteralWordAt(i2));
            }
            iteratingRLW.discardFirstWords(n3);
            iteratingRLW2.discardFirstWords(n3);
        }
    }

    static void andToContainer(BitmapStorage bitmapStorage, IteratingRLW iteratingRLW, IteratingRLW iteratingRLW2) {
        while (iteratingRLW.size() > 0L && iteratingRLW2.size() > 0L) {
            int n2;
            while (iteratingRLW.getRunningLength() > 0L || iteratingRLW2.getRunningLength() > 0L) {
                IteratingRLW iteratingRLW3;
                n2 = iteratingRLW.getRunningLength() < iteratingRLW2.getRunningLength() ? 1 : 0;
                IteratingRLW iteratingRLW4 = n2 != 0 ? iteratingRLW : iteratingRLW2;
                IteratingRLW iteratingRLW5 = iteratingRLW3 = n2 != 0 ? iteratingRLW2 : iteratingRLW;
                if (!iteratingRLW3.getRunningBit()) {
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW3.getRunningLength());
                    iteratingRLW4.discardFirstWords(iteratingRLW3.getRunningLength());
                    iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
                    continue;
                }
                long l2 = IteratorAggregation.discharge(bitmapStorage, iteratingRLW4, iteratingRLW3.getRunningLength());
                bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW3.getRunningLength() - l2);
                iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
            }
            n2 = Math.min(iteratingRLW.getNumberOfLiteralWords(), iteratingRLW2.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(i2) & iteratingRLW2.getLiteralWordAt(i2));
            }
            iteratingRLW.discardFirstWords(n2);
            iteratingRLW2.discardFirstWords(n2);
        }
    }

    public static void xorToContainer(BitmapStorage bitmapStorage, int n2, IteratingRLW iteratingRLW, IteratingRLW iteratingRLW2) {
        while (iteratingRLW.size() > 0L && iteratingRLW2.size() > 0L && n2-- > 0) {
            int n3;
            while (iteratingRLW.getRunningLength() > 0L || iteratingRLW2.getRunningLength() > 0L) {
                long l2;
                IteratingRLW iteratingRLW3;
                n3 = iteratingRLW.getRunningLength() < iteratingRLW2.getRunningLength() ? 1 : 0;
                IteratingRLW iteratingRLW4 = n3 != 0 ? iteratingRLW : iteratingRLW2;
                IteratingRLW iteratingRLW5 = iteratingRLW3 = n3 != 0 ? iteratingRLW2 : iteratingRLW;
                if (!iteratingRLW3.getRunningBit()) {
                    l2 = IteratorAggregation.discharge(bitmapStorage, iteratingRLW4, iteratingRLW3.getRunningLength());
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingRLW3.getRunningLength() - l2);
                    iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
                    continue;
                }
                l2 = IteratorAggregation.dischargeNegated(bitmapStorage, iteratingRLW4, iteratingRLW3.getRunningLength());
                bitmapStorage.addStreamOfEmptyWords(true, iteratingRLW3.getRunningLength() - l2);
                iteratingRLW3.discardFirstWords(iteratingRLW3.getRunningLength());
            }
            n3 = Math.min(iteratingRLW.getNumberOfLiteralWords(), iteratingRLW2.getNumberOfLiteralWords());
            if (n3 <= 0) continue;
            n2 -= n3;
            for (int i2 = 0; i2 < n3; ++i2) {
                bitmapStorage.addWord(iteratingRLW.getLiteralWordAt(i2) ^ iteratingRLW2.getLiteralWordAt(i2));
            }
            iteratingRLW.discardFirstWords(n3);
            iteratingRLW2.discardFirstWords(n3);
        }
    }

    protected static int inplaceor(long[] lArray, IteratingRLW iteratingRLW) {
        long l2;
        int n2 = 0;
        while ((l2 = iteratingRLW.size()) > 0L) {
            int n3;
            int n4;
            int n5;
            if ((long)n2 + l2 < (long)lArray.length) {
                n5 = (int)iteratingRLW.getRunningLength();
                if (iteratingRLW.getRunningBit()) {
                    Arrays.fill(lArray, n2, n2 + n5, -1L);
                }
                n2 += n5;
                n4 = iteratingRLW.getNumberOfLiteralWords();
                for (n3 = 0; n3 < n4; ++n3) {
                    int n6 = n2++;
                    lArray[n6] = lArray[n6] | iteratingRLW.getLiteralWordAt(n3);
                }
                if (iteratingRLW.next()) continue;
                return n2;
            }
            n5 = lArray.length - n2;
            n4 = (int)iteratingRLW.getRunningLength();
            if (n2 + n4 > lArray.length) {
                if (iteratingRLW.getRunningBit()) {
                    Arrays.fill(lArray, n2, lArray.length, -1L);
                }
                iteratingRLW.discardFirstWords(n5);
                return lArray.length;
            }
            if (iteratingRLW.getRunningBit()) {
                Arrays.fill(lArray, n2, n2 + n4, -1L);
            }
            n2 += n4;
            n3 = 0;
            while (n2 < lArray.length) {
                int n7 = n2++;
                lArray[n7] = lArray[n7] | iteratingRLW.getLiteralWordAt(n3);
                ++n3;
            }
            iteratingRLW.discardFirstWords(n5);
            return n2;
        }
        return n2;
    }

    protected static int inplacexor(long[] lArray, IteratingRLW iteratingRLW) {
        long l2;
        int n2 = 0;
        while ((l2 = iteratingRLW.size()) > 0L) {
            int n3;
            int n4;
            int n5;
            if ((long)n2 + l2 < (long)lArray.length) {
                n5 = (int)iteratingRLW.getRunningLength();
                if (iteratingRLW.getRunningBit()) {
                    for (n4 = n2; n4 < n2 + n5; ++n4) {
                        lArray[n4] = lArray[n4] ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
                n2 += n5;
                n4 = iteratingRLW.getNumberOfLiteralWords();
                for (n3 = 0; n3 < n4; ++n3) {
                    int n6 = n2++;
                    lArray[n6] = lArray[n6] ^ iteratingRLW.getLiteralWordAt(n3);
                }
                if (iteratingRLW.next()) continue;
                return n2;
            }
            n5 = lArray.length - n2;
            n4 = (int)iteratingRLW.getRunningLength();
            if (n2 + n4 > lArray.length) {
                if (iteratingRLW.getRunningBit()) {
                    for (n3 = n2; n3 < lArray.length; ++n3) {
                        lArray[n3] = lArray[n3] ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
                iteratingRLW.discardFirstWords(n5);
                return lArray.length;
            }
            if (iteratingRLW.getRunningBit()) {
                for (n3 = n2; n3 < n2 + n4; ++n3) {
                    lArray[n3] = lArray[n3] ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            n2 += n4;
            n3 = 0;
            while (n2 < lArray.length) {
                int n7 = n2++;
                lArray[n7] = lArray[n7] ^ iteratingRLW.getLiteralWordAt(n3);
                ++n3;
            }
            iteratingRLW.discardFirstWords(n5);
            return n2;
        }
        return n2;
    }

    protected static int inplaceand(long[] lArray, IteratingRLW iteratingRLW) {
        long l2;
        int n2 = 0;
        while ((l2 = iteratingRLW.size()) > 0L) {
            int n3;
            int n4;
            int n5;
            if ((long)n2 + l2 < (long)lArray.length) {
                n5 = (int)iteratingRLW.getRunningLength();
                if (!iteratingRLW.getRunningBit()) {
                    for (n4 = n2; n4 < n2 + n5; ++n4) {
                        lArray[n4] = 0L;
                    }
                }
                n2 += n5;
                n4 = iteratingRLW.getNumberOfLiteralWords();
                for (n3 = 0; n3 < n4; ++n3) {
                    int n6 = n2++;
                    lArray[n6] = lArray[n6] & iteratingRLW.getLiteralWordAt(n3);
                }
                if (iteratingRLW.next()) continue;
                return n2;
            }
            n5 = lArray.length - n2;
            n4 = (int)iteratingRLW.getRunningLength();
            if (n2 + n4 > lArray.length) {
                if (!iteratingRLW.getRunningBit()) {
                    for (n3 = n2; n3 < lArray.length; ++n3) {
                        lArray[n3] = 0L;
                    }
                }
                iteratingRLW.discardFirstWords(n5);
                return lArray.length;
            }
            if (!iteratingRLW.getRunningBit()) {
                for (n3 = n2; n3 < n2 + n4; ++n3) {
                    lArray[n3] = 0L;
                }
            }
            n2 += n4;
            n3 = 0;
            while (n2 < lArray.length) {
                int n7 = n2++;
                lArray[n7] = lArray[n7] & iteratingRLW.getLiteralWordAt(n3);
                ++n3;
            }
            iteratingRLW.discardFirstWords(n5);
            return n2;
        }
        return n2;
    }
}

