/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;

public final class IteratingBufferedRunningLengthWord
implements IteratingRLW,
Cloneable {
    private BufferedRunningLengthWord brlw;
    private final Buffer buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator eWAHIterator) {
        this.iterator = eWAHIterator;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord(EWAHCompressedBitmap eWAHCompressedBitmap) {
        this(EWAHIterator.getEWAHIterator(eWAHCompressedBitmap));
    }

    @Override
    public void discardFirstWords(long l2) {
        while (l2 > 0L) {
            if (this.brlw.runningLength > l2) {
                this.brlw.runningLength -= l2;
                return;
            }
            this.brlw.runningLength = 0L;
            long l3 = (l2 -= this.brlw.runningLength) > (long)this.brlw.numberOfLiteralWords ? (long)this.brlw.numberOfLiteralWords : l2;
            this.literalWordStartPosition += (int)l3;
            this.brlw.numberOfLiteralWords = (int)((long)this.brlw.numberOfLiteralWords - l3);
            if ((l2 -= l3) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardLiteralWords(long l2) {
        this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + l2);
        this.brlw.numberOfLiteralWords = (int)((long)this.brlw.numberOfLiteralWords - l2);
        if (this.brlw.numberOfLiteralWords == 0) {
            if (!this.iterator.hasNext()) {
                return;
            }
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.runningLength = 0L;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext()) {
            this.brlw.numberOfLiteralWords = 0;
            this.brlw.runningLength = 0L;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    public long discharge(BitmapStorage bitmapStorage, long l2) {
        long l3 = 0L;
        do {
            if (l3 + this.getRunningLength() > l2) {
                int n2 = (int)(l2 - l3);
                bitmapStorage.addStreamOfEmptyWords(this.getRunningBit(), n2);
                this.brlw.runningLength -= (long)n2;
                return l2;
            }
            bitmapStorage.addStreamOfEmptyWords(this.getRunningBit(), this.getRunningLength());
            if ((long)this.getNumberOfLiteralWords() + (l3 += this.getRunningLength()) > l2) {
                int n3 = (int)(l2 - l3);
                this.writeLiteralWords(n3, bitmapStorage);
                this.brlw.runningLength = 0L;
                this.brlw.numberOfLiteralWords -= n3;
                this.literalWordStartPosition += n3;
                return l2;
            }
            this.writeLiteralWords(this.getNumberOfLiteralWords(), bitmapStorage);
            l3 += (long)this.getNumberOfLiteralWords();
        } while (this.next());
        return l3;
    }

    public long dischargeNegated(BitmapStorage bitmapStorage, long l2) {
        long l3;
        int n2;
        for (l3 = 0L; l3 < l2 && this.size() > 0L; l3 += (long)n2) {
            long l4 = this.getRunningLength();
            if (l3 + l4 > l2) {
                l4 = l2 - l3;
            }
            bitmapStorage.addStreamOfEmptyWords(!this.getRunningBit(), l4);
            n2 = this.getNumberOfLiteralWords();
            if ((long)n2 + (l3 += l4) > l2) {
                n2 = (int)(l2 - l3);
            }
            this.writeNegatedLiteralWords(n2, bitmapStorage);
            this.discardFirstWords(l4 + (long)n2);
        }
        return l3;
    }

    public void dischargeAsEmpty(BitmapStorage bitmapStorage) {
        while (this.size() > 0L) {
            bitmapStorage.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage bitmapStorage) {
        this.brlw.literalWordOffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord.discharge(this.brlw, this.iterator, bitmapStorage);
    }

    @Override
    public long getLiteralWordAt(int n2) {
        return this.buffer.getWord(this.literalWordStartPosition + n2);
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.numberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.runningBit;
    }

    @Override
    public long getRunningLength() {
        return this.brlw.runningLength;
    }

    @Override
    public long size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int n2, BitmapStorage bitmapStorage) {
        bitmapStorage.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, n2);
    }

    public void writeNegatedLiteralWords(int n2, BitmapStorage bitmapStorage) {
        bitmapStorage.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, n2);
    }

    private static void discharge(BufferedRunningLengthWord bufferedRunningLengthWord, EWAHIterator eWAHIterator, BitmapStorage bitmapStorage) {
        BufferedRunningLengthWord bufferedRunningLengthWord2 = bufferedRunningLengthWord;
        while (true) {
            long l2 = bufferedRunningLengthWord2.getRunningLength();
            bitmapStorage.addStreamOfEmptyWords(bufferedRunningLengthWord2.getRunningBit(), l2);
            bitmapStorage.addStreamOfLiteralWords(eWAHIterator.buffer(), eWAHIterator.literalWords() + bufferedRunningLengthWord2.literalWordOffset, bufferedRunningLengthWord2.getNumberOfLiteralWords());
            if (!eWAHIterator.hasNext()) break;
            bufferedRunningLengthWord2 = new BufferedRunningLengthWord(eWAHIterator.next());
        }
    }

    @Override
    public IteratingBufferedRunningLengthWord clone() {
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = (IteratingBufferedRunningLengthWord)super.clone();
        iteratingBufferedRunningLengthWord.brlw = this.brlw.clone();
        iteratingBufferedRunningLengthWord.iterator = this.iterator.clone();
        return iteratingBufferedRunningLengthWord;
    }
}

