/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class IntIteratorImpl
implements IntIterator {
    private final EWAHIterator ewahIter;
    private final Buffer buffer;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    IntIteratorImpl(EWAHIterator eWAHIterator) {
        this.ewahIter = eWAHIterator;
        this.buffer = eWAHIterator.buffer();
        this.hasNext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int n2;
        if (this.runningHasNext()) {
            n2 = this.position++;
        } else {
            long l2 = this.word & -this.word;
            n2 = this.literalPosition + Long.bitCount(l2 - 1L);
            this.word ^= l2;
        }
        this.hasNext = this.moveToNext();
        return n2;
    }

    private void setRunningLengthWord(RunningLengthWord runningLengthWord) {
        this.runningLength = 64 * (int)runningLengthWord.getRunningLength() + this.position;
        if (!runningLengthWord.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + runningLengthWord.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            this.word = this.buffer.getWord(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

