/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.RunningLengthWord;

public final class EWAHIterator
implements Cloneable {
    private int pointer;
    final RunningLengthWord rlw;
    private final int size;

    public EWAHIterator(Buffer buffer) {
        this.rlw = new RunningLengthWord(buffer, 0);
        this.size = buffer.sizeInWords();
        this.pointer = 0;
    }

    private EWAHIterator(int n2, RunningLengthWord runningLengthWord, int n3) {
        this.pointer = n2;
        this.rlw = runningLengthWord;
        this.size = n3;
    }

    public static EWAHIterator getEWAHIterator(EWAHCompressedBitmap eWAHCompressedBitmap) {
        return eWAHCompressedBitmap.getEWAHIterator();
    }

    public Buffer buffer() {
        return this.rlw.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator clone() {
        return new EWAHIterator(this.pointer, this.rlw.clone(), this.size);
    }
}

