/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitCounter;
import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.ChunkIteratorImpl;
import com.googlecode.javaewah.ClearIntIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap$1;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.LongArray;
import com.googlecode.javaewah.LongBufferWrapper;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.NonEmptyVirtualStorage$NonEmptyException;
import com.googlecode.javaewah.ReverseEWAHIterator;
import com.googlecode.javaewah.ReverseIntIterator;
import com.googlecode.javaewah.RunningLengthWord;
import com.googlecode.javaewah.symmetric.RunningBitmapMerge;
import com.googlecode.javaewah.symmetric.ThresholdFuncBitmap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap
implements BitmapStorage,
LogicalElement,
Externalizable,
Cloneable,
Iterable {
    final Buffer buffer;
    private RunningLengthWord rlw = null;
    private int sizeInBits = 0;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 64;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap() {
        this(new LongArray());
    }

    public EWAHCompressedBitmap(int n2) {
        this(new LongArray(n2));
    }

    public EWAHCompressedBitmap(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.sizeInBits = intBuffer.get(0);
        int n2 = intBuffer.get(1);
        int n3 = intBuffer.get(2 + n2 * 2);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.position(1);
        this.buffer = new LongBufferWrapper(longBuffer.slice(), n2);
        this.rlw = new RunningLengthWord(this.buffer, n3);
    }

    public EWAHCompressedBitmap(LongBuffer longBuffer) {
        this(new LongBufferWrapper(longBuffer));
    }

    private EWAHCompressedBitmap(Buffer buffer) {
        this.buffer = buffer;
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    @Deprecated
    public void add(long l2) {
        this.addWord(l2);
    }

    @Deprecated
    public void add(long l2, int n2) {
        this.addWord(l2, n2);
    }

    @Override
    public void addWord(long l2) {
        this.addWord(l2, 64);
    }

    public void addWord(long l2, int n2) {
        this.sizeInBits += n2;
        if (l2 == 0L) {
            this.insertEmptyWord(false);
        } else if (l2 == -1L) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(l2);
        }
    }

    private void insertEmptyWord(boolean bl2) {
        boolean bl3 = this.rlw.getNumberOfLiteralWords() == 0;
        long l2 = this.rlw.getRunningLength();
        if (bl3 && l2 == 0L) {
            this.rlw.setRunningBit(bl2);
        }
        if (bl3 && this.rlw.getRunningBit() == bl2 && l2 < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(l2 + 1L);
            return;
        }
        this.buffer.push_back(0L);
        this.rlw.position = this.buffer.sizeInWords() - 1;
        this.rlw.setRunningBit(bl2);
        this.rlw.setRunningLength(1L);
    }

    @Override
    public void addLiteralWord(long l2) {
        this.sizeInBits += 64;
        this.insertLiteralWord(l2);
    }

    private void insertLiteralWord(long l2) {
        int n2 = this.rlw.getNumberOfLiteralWords();
        if (n2 >= Integer.MAX_VALUE) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.buffer.push_back(l2);
        } else {
            this.rlw.setNumberOfLiteralWords(n2 + 1);
            this.buffer.push_back(l2);
        }
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this.rlw.getNumberOfLiteralWords();
            int n6 = n4 < Integer.MAX_VALUE - n5 ? n4 : Integer.MAX_VALUE - n5;
            this.rlw.setNumberOfLiteralWords(n5 + n6);
            this.buffer.push_back(buffer, n2, n6);
            this.sizeInBits += n6 * 64;
            if ((n4 -= n6) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean bl2, long l2) {
        if (l2 == 0L) {
            return;
        }
        this.sizeInBits += (int)(l2 * 64L);
        this.fastaddStreamOfEmptyWords(bl2, l2);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this.rlw.getNumberOfLiteralWords();
            int n6 = n4 < Integer.MAX_VALUE - n5 ? n4 : Integer.MAX_VALUE - n5;
            this.rlw.setNumberOfLiteralWords(n5 + n6);
            this.buffer.negative_push_back(buffer, n2, n6);
            this.sizeInBits += n6 * 64;
            if ((n4 -= n6) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    public EWAHCompressedBitmap and(EWAHCompressedBitmap eWAHCompressedBitmap) {
        int n2 = this.buffer.sizeInWords() > eWAHCompressedBitmap.buffer.sizeInWords() ? this.buffer.sizeInWords() : eWAHCompressedBitmap.buffer.sizeInWords();
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        this.andToContainer(eWAHCompressedBitmap, eWAHCompressedBitmap2);
        return eWAHCompressedBitmap2;
    }

    public void andToContainer(EWAHCompressedBitmap eWAHCompressedBitmap, BitmapStorage bitmapStorage) {
        bitmapStorage.clear();
        EWAHIterator eWAHIterator = eWAHCompressedBitmap.getEWAHIterator();
        EWAHIterator eWAHIterator2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = new IteratingBufferedRunningLengthWord(eWAHIterator);
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord2 = new IteratingBufferedRunningLengthWord(eWAHIterator2);
        while (iteratingBufferedRunningLengthWord.size() > 0L && iteratingBufferedRunningLengthWord2.size() > 0L) {
            int n2;
            while (iteratingBufferedRunningLengthWord.getRunningLength() > 0L || iteratingBufferedRunningLengthWord2.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord3;
                n2 = iteratingBufferedRunningLengthWord.getRunningLength() < iteratingBufferedRunningLengthWord2.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord4 = n2 != 0 ? iteratingBufferedRunningLengthWord : iteratingBufferedRunningLengthWord2;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord5 = iteratingBufferedRunningLengthWord3 = n2 != 0 ? iteratingBufferedRunningLengthWord2 : iteratingBufferedRunningLengthWord;
                if (!iteratingBufferedRunningLengthWord3.getRunningBit()) {
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord3.getRunningLength());
                    iteratingBufferedRunningLengthWord4.discardFirstWords(iteratingBufferedRunningLengthWord3.getRunningLength());
                } else {
                    long l2 = iteratingBufferedRunningLengthWord4.discharge(bitmapStorage, iteratingBufferedRunningLengthWord3.getRunningLength());
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord3.getRunningLength() - l2);
                }
                iteratingBufferedRunningLengthWord3.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord2.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingBufferedRunningLengthWord.getLiteralWordAt(i2) & iteratingBufferedRunningLengthWord2.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord2.discardLiteralWords(n2);
        }
        bitmapStorage.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap eWAHCompressedBitmap) {
        BitCounter bitCounter = new BitCounter();
        this.andToContainer(eWAHCompressedBitmap, bitCounter);
        return bitCounter.getCount();
    }

    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap eWAHCompressedBitmap) {
        int n2 = this.buffer.sizeInWords() > eWAHCompressedBitmap.buffer.sizeInWords() ? this.buffer.sizeInWords() : eWAHCompressedBitmap.buffer.sizeInWords();
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        this.andNotToContainer(eWAHCompressedBitmap, eWAHCompressedBitmap2);
        return eWAHCompressedBitmap2;
    }

    public void andNotToContainer(EWAHCompressedBitmap eWAHCompressedBitmap, BitmapStorage bitmapStorage) {
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord;
        int n2;
        bitmapStorage.clear();
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        EWAHIterator eWAHIterator2 = eWAHCompressedBitmap.getEWAHIterator();
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord2 = new IteratingBufferedRunningLengthWord(eWAHIterator);
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord3 = new IteratingBufferedRunningLengthWord(eWAHIterator2);
        while (iteratingBufferedRunningLengthWord2.size() > 0L && iteratingBufferedRunningLengthWord3.size() > 0L) {
            while (iteratingBufferedRunningLengthWord2.getRunningLength() > 0L || iteratingBufferedRunningLengthWord3.getRunningLength() > 0L) {
                long l2;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord4;
                n2 = iteratingBufferedRunningLengthWord2.getRunningLength() < iteratingBufferedRunningLengthWord3.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord5 = n2 != 0 ? iteratingBufferedRunningLengthWord2 : iteratingBufferedRunningLengthWord3;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord6 = iteratingBufferedRunningLengthWord4 = n2 != 0 ? iteratingBufferedRunningLengthWord3 : iteratingBufferedRunningLengthWord2;
                if (iteratingBufferedRunningLengthWord4.getRunningBit() && n2 != 0 || !iteratingBufferedRunningLengthWord4.getRunningBit() && n2 == 0) {
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord4.getRunningLength());
                    iteratingBufferedRunningLengthWord5.discardFirstWords(iteratingBufferedRunningLengthWord4.getRunningLength());
                } else if (n2 != 0) {
                    l2 = iteratingBufferedRunningLengthWord5.discharge(bitmapStorage, iteratingBufferedRunningLengthWord4.getRunningLength());
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord4.getRunningLength() - l2);
                } else {
                    l2 = iteratingBufferedRunningLengthWord5.dischargeNegated(bitmapStorage, iteratingBufferedRunningLengthWord4.getRunningLength());
                    bitmapStorage.addStreamOfEmptyWords(true, iteratingBufferedRunningLengthWord4.getRunningLength() - l2);
                }
                iteratingBufferedRunningLengthWord4.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord2.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord3.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingBufferedRunningLengthWord2.getLiteralWordAt(i2) & (iteratingBufferedRunningLengthWord3.getLiteralWordAt(i2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            iteratingBufferedRunningLengthWord2.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord3.discardLiteralWords(n2);
        }
        n2 = iteratingBufferedRunningLengthWord2.size() > 0L ? 1 : 0;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord7 = iteratingBufferedRunningLengthWord = n2 != 0 ? iteratingBufferedRunningLengthWord2 : iteratingBufferedRunningLengthWord3;
        if (n2 != 0) {
            iteratingBufferedRunningLengthWord.discharge(bitmapStorage);
        }
        bitmapStorage.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap eWAHCompressedBitmap) {
        BitCounter bitCounter = new BitCounter();
        this.andNotToContainer(eWAHCompressedBitmap, bitCounter);
        return bitCounter.getCount();
    }

    public int cardinality() {
        int n2 = 0;
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        while (eWAHIterator.hasNext()) {
            RunningLengthWord runningLengthWord = eWAHIterator.next();
            if (runningLengthWord.getRunningBit()) {
                n2 += (int)(64L * runningLengthWord.getRunningLength());
            }
            int n3 = runningLengthWord.getNumberOfLiteralWords();
            int n4 = eWAHIterator.literalWords();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += Long.bitCount(eWAHIterator.buffer().getWord(n4 + i2));
            }
        }
        return n2;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.buffer.clear();
        this.rlw.position = 0;
    }

    public EWAHCompressedBitmap clone() {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(this.buffer.clone());
        eWAHCompressedBitmap.sizeInBits = this.sizeInBits;
        eWAHCompressedBitmap.rlw = new RunningLengthWord(eWAHCompressedBitmap.buffer, this.rlw.position);
        return eWAHCompressedBitmap;
    }

    public void serialize(DataOutput dataOutput) {
        dataOutput.writeInt(this.sizeInBits);
        int n2 = this.buffer.sizeInWords();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeLong(this.buffer.getWord(i2));
        }
        dataOutput.writeInt(this.rlw.position);
    }

    public void deserialize(DataInput dataInput) {
        this.sizeInBits = dataInput.readInt();
        int n2 = dataInput.readInt();
        this.buffer.clear();
        this.buffer.removeLastWord();
        this.buffer.ensureCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.push_back(dataInput.readLong());
        }
        this.rlw = new RunningLengthWord(this.buffer, dataInput.readInt());
    }

    public boolean equals(Object object) {
        if (object instanceof EWAHCompressedBitmap) {
            try {
                this.xorToContainer((EWAHCompressedBitmap)object, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage$NonEmptyException nonEmptyVirtualStorage$NonEmptyException) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean bl2, long l2) {
        if (this.rlw.getRunningBit() != bl2 && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(bl2);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != bl2) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
        }
        long l3 = this.rlw.getRunningLength();
        long l4 = l2 < 0xFFFFFFFFL - l3 ? l2 : 0xFFFFFFFFL - l3;
        this.rlw.setRunningLength(l3 + l4);
        l2 -= l4;
        while (l2 >= 0xFFFFFFFFL) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            l2 -= 0xFFFFFFFFL;
        }
        if (l2 > 0L) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (bl2) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(l2);
        }
    }

    public EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer);
    }

    private ReverseEWAHIterator getReverseEWAHIterator() {
        return new ReverseEWAHIterator(this.buffer);
    }

    public IteratingRLW getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord(this);
    }

    @Deprecated
    public List getPositions() {
        return this.toList();
    }

    public List toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        int n2 = 0;
        while (eWAHIterator.hasNext()) {
            long l2;
            RunningLengthWord runningLengthWord = eWAHIterator.next();
            if (runningLengthWord.getRunningBit()) {
                long l3 = runningLengthWord.getRunningLength();
                for (l2 = 0L; l2 < l3; ++l2) {
                    for (int i2 = 0; i2 < 64; ++i2) {
                        arrayList.add(n2++);
                    }
                }
            } else {
                n2 += (int)(64L * runningLengthWord.getRunningLength());
            }
            int n3 = runningLengthWord.getNumberOfLiteralWords();
            for (int i3 = 0; i3 < n3; ++i3) {
                long l4;
                for (l2 = eWAHIterator.buffer().getWord(eWAHIterator.literalWords() + i3); l2 != 0L; l2 ^= l4) {
                    l4 = l2 & -l2;
                    arrayList.add(Long.bitCount(l4 - 1L) + n2);
                }
                n2 += 64;
            }
        }
        while (arrayList.size() > 0 && (Integer)arrayList.get(arrayList.size() - 1) >= this.sizeInBits) {
            arrayList.remove(arrayList.size() - 1);
        }
        return arrayList;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = -1640531535;
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        while (eWAHIterator.hasNext()) {
            eWAHIterator.next();
            if (eWAHIterator.rlw.getRunningBit()) {
                long l2 = eWAHIterator.rlw.getRunningLength();
                n2 += (int)(-1640531535L * (l2 & 0xFFFFFFFFFFFFFFFFL));
                n2 += (int)(-1640531535L * (l2 >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
            int n4 = eWAHIterator.rlw.getNumberOfLiteralWords();
            int n5 = eWAHIterator.literalWords();
            for (int i2 = 0; i2 < n4; ++i2) {
                long l3 = this.buffer.getWord(n5 + i2);
                n2 = (int)((long)n2 + -1640531535L * (l3 & 0xFFFFFFFFFFFFFFFFL));
                n2 = (int)((long)n2 + -1640531535L * (l3 >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
        }
        return n2;
    }

    public boolean intersects(EWAHCompressedBitmap eWAHCompressedBitmap) {
        NonEmptyVirtualStorage nonEmptyVirtualStorage = new NonEmptyVirtualStorage();
        try {
            this.andToContainer(eWAHCompressedBitmap, nonEmptyVirtualStorage);
        }
        catch (NonEmptyVirtualStorage$NonEmptyException nonEmptyVirtualStorage$NonEmptyException) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl(this.getEWAHIterator(), this.sizeInBits);
    }

    public Iterator iterator() {
        return new EWAHCompressedBitmap$1(this);
    }

    @Override
    public void not() {
        int n2;
        RunningLengthWord runningLengthWord;
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        if (!eWAHIterator.hasNext()) {
            return;
        }
        do {
            runningLengthWord.setRunningBit(!(runningLengthWord = eWAHIterator.next()).getRunningBit());
            int n3 = runningLengthWord.getNumberOfLiteralWords();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = eWAHIterator.literalWords() + n2;
                eWAHIterator.buffer().negateWord(n4);
            }
        } while (eWAHIterator.hasNext());
        n2 = this.sizeInBits % 64;
        if (n2 == 0) {
            return;
        }
        if (runningLengthWord.getNumberOfLiteralWords() == 0) {
            if (runningLengthWord.getRunningLength() > 0L && runningLengthWord.getRunningBit()) {
                if (runningLengthWord.getRunningLength() == 1L && runningLengthWord.position > 0) {
                    EWAHIterator eWAHIterator2 = this.getEWAHIterator();
                    int n5 = this.rlw.position;
                    while (eWAHIterator2.hasNext()) {
                        RunningLengthWord runningLengthWord2 = eWAHIterator2.next();
                        if (runningLengthWord2.position >= runningLengthWord.position) break;
                        n5 = runningLengthWord2.position;
                    }
                    this.rlw.position = n5;
                    this.buffer.removeLastWord();
                } else {
                    runningLengthWord.setRunningLength(runningLengthWord.getRunningLength() - 1L);
                }
                this.insertLiteralWord(-1L >>> 64 - n2);
            }
            return;
        }
        eWAHIterator.buffer().andWord(eWAHIterator.literalWords() + runningLengthWord.getNumberOfLiteralWords() - 1, -1L >>> 64 - n2);
    }

    public EWAHCompressedBitmap or(EWAHCompressedBitmap eWAHCompressedBitmap) {
        int n2 = this.buffer.sizeInWords() + eWAHCompressedBitmap.buffer.sizeInWords();
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        this.orToContainer(eWAHCompressedBitmap, eWAHCompressedBitmap2);
        return eWAHCompressedBitmap2;
    }

    public void orToContainer(EWAHCompressedBitmap eWAHCompressedBitmap, BitmapStorage bitmapStorage) {
        int n2;
        bitmapStorage.clear();
        EWAHIterator eWAHIterator = eWAHCompressedBitmap.getEWAHIterator();
        EWAHIterator eWAHIterator2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = new IteratingBufferedRunningLengthWord(eWAHIterator);
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord2 = new IteratingBufferedRunningLengthWord(eWAHIterator2);
        while (iteratingBufferedRunningLengthWord.size() > 0L && iteratingBufferedRunningLengthWord2.size() > 0L) {
            while (iteratingBufferedRunningLengthWord.getRunningLength() > 0L || iteratingBufferedRunningLengthWord2.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord3;
                n2 = iteratingBufferedRunningLengthWord.getRunningLength() < iteratingBufferedRunningLengthWord2.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord4 = n2 != 0 ? iteratingBufferedRunningLengthWord : iteratingBufferedRunningLengthWord2;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord5 = iteratingBufferedRunningLengthWord3 = n2 != 0 ? iteratingBufferedRunningLengthWord2 : iteratingBufferedRunningLengthWord;
                if (iteratingBufferedRunningLengthWord3.getRunningBit()) {
                    bitmapStorage.addStreamOfEmptyWords(true, iteratingBufferedRunningLengthWord3.getRunningLength());
                    iteratingBufferedRunningLengthWord4.discardFirstWords(iteratingBufferedRunningLengthWord3.getRunningLength());
                } else {
                    long l2 = iteratingBufferedRunningLengthWord4.discharge(bitmapStorage, iteratingBufferedRunningLengthWord3.getRunningLength());
                    bitmapStorage.addStreamOfEmptyWords(false, iteratingBufferedRunningLengthWord3.getRunningLength() - l2);
                }
                iteratingBufferedRunningLengthWord3.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord2.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingBufferedRunningLengthWord.getLiteralWordAt(i2) | iteratingBufferedRunningLengthWord2.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord2.discardLiteralWords(n2);
        }
        n2 = iteratingBufferedRunningLengthWord.size() > 0L ? 1 : 0;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord6 = n2 != 0 ? iteratingBufferedRunningLengthWord : iteratingBufferedRunningLengthWord2;
        iteratingBufferedRunningLengthWord6.discharge(bitmapStorage);
        bitmapStorage.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap eWAHCompressedBitmap) {
        BitCounter bitCounter = new BitCounter();
        this.orToContainer(eWAHCompressedBitmap, bitCounter);
        return bitCounter.getCount();
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        this.deserialize(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        this.serialize(objectOutput);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int n2) {
        if (n2 < 0 || n2 >= this.sizeInBits) {
            return false;
        }
        IteratingRLW iteratingRLW = this.getIteratingRLW();
        int n3 = n2 / 64;
        for (int i2 = 0; i2 <= n3; i2 += iteratingRLW.getNumberOfLiteralWords()) {
            if (n3 < (i2 += (int)iteratingRLW.getRunningLength())) {
                return iteratingRLW.getRunningBit();
            }
            if (n3 < i2 + iteratingRLW.getNumberOfLiteralWords()) {
                long l2 = iteratingRLW.getLiteralWordAt(n3 - i2);
                return (l2 & 1L << n2) != 0L;
            }
            iteratingRLW.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int n2 = 0;
        int n3 = this.buffer.sizeInWords();
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = RunningLengthWord.getRunningLength(this.buffer, i2);
            boolean bl2 = RunningLengthWord.getRunningBit(this.buffer, i2);
            if (l2 > 0L && bl2) {
                return n2 * 64;
            }
            n2 += (int)l2;
            long l3 = RunningLengthWord.getNumberOfLiteralWords(this.buffer, i2);
            int n4 = i2 + 1;
            while ((long)n4 <= (long)i2 + l3) {
                long l4 = this.buffer.getWord(n4);
                if (l4 != 0L) {
                    long l5 = l4 & -l4;
                    return n2 * 64 + Long.bitCount(l5 - 1L);
                }
                ++n2;
                ++n4;
            }
        }
        return -1;
    }

    public boolean clear(int n2) {
        return this.set(n2, false);
    }

    public boolean set(int n2) {
        return this.set(n2, true);
    }

    private boolean set(int n2, boolean bl2) {
        if (n2 > 0x7FFFFFBF || n2 < 0) {
            throw new IndexOutOfBoundsException("Position should be between 0 and 2147483583");
        }
        if (n2 < this.sizeInBits) {
            this.locateAndSet(n2, bl2);
        } else {
            this.extendAndSet(n2, bl2);
        }
        return true;
    }

    private void extendAndSet(int n2, boolean bl2) {
        int n3 = this.distanceInWords(n2);
        this.sizeInBits = n2 + 1;
        if (bl2) {
            if (n3 > 0) {
                if (this.rlw.getNumberOfLiteralWords() > 0 && this.buffer.getLastWord() == 0L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(false);
                }
                if (n3 > 1) {
                    this.fastaddStreamOfEmptyWords(false, n3 - 1);
                }
                this.insertLiteralWord(1L << n2 % 64);
                return;
            }
            if (this.rlw.getNumberOfLiteralWords() == 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                this.insertLiteralWord(1L << n2 % 64);
                return;
            }
            this.buffer.orLastWord(1L << n2 % 64);
            if (this.buffer.getLastWord() == -1L) {
                this.buffer.removeLastWord();
                this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                this.insertEmptyWord(true);
            }
        } else if (n3 > 0) {
            this.fastaddStreamOfEmptyWords(false, n3);
        }
    }

    private void locateAndSet(int n2, boolean bl2) {
        long l2;
        int n3 = 0;
        int n4 = this.buffer.sizeInWords();
        for (int i2 = 0; i2 < n4; i2 += (int)(l2 + 1L)) {
            long l3 = RunningLengthWord.getRunningLength(this.buffer, i2);
            boolean bl3 = RunningLengthWord.getRunningBit(this.buffer, i2);
            l2 = RunningLengthWord.getNumberOfLiteralWords(this.buffer, i2);
            long l4 = l3 * 64L;
            if ((long)n2 < (long)n3 + l4) {
                this.setInRunningLength(bl2, n2, n3, i2, l3, bl3, l2);
                return;
            }
            long l5 = l2 * 64L;
            if ((long)n2 < (long)(n3 += (int)l4) + l5) {
                this.setInLiteralWords(bl2, n2, n3, i2, l3, bl3, l2);
                return;
            }
            n3 += (int)l5;
        }
    }

    private void setInRunningLength(boolean bl2, int n2, int n3, int n4, long l2, boolean bl3, long l3) {
        if (bl2 != bl3) {
            int n5 = (n2 - n3) / 64 + 1;
            int n6 = (long)n5 == l2 ? 1 : 2;
            this.buffer.expand(n4 + 1, n6);
            long l4 = 1L << n2 % 64;
            this.buffer.setWord(n4 + 1, bl2 ? l4 : l4 ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.rlw.position >= n4 + 1) {
                this.rlw.position += n6;
            }
            if (n6 == 1) {
                this.setRLWInfo(n4, bl3, l2 - 1L, l3 + 1L);
            } else {
                this.setRLWInfo(n4, bl3, n5 - 1, 1L);
                this.setRLWInfo(n4 + 2, bl3, l2 - (long)n5, l3);
                if (this.rlw.position == n4) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(boolean bl2, int n2, int n3, int n4, long l2, boolean bl3, long l3) {
        long l4;
        int n5 = (n2 - n3) / 64 + 1;
        long l5 = 1L << n2 % 64;
        if (bl2) {
            this.buffer.orWord(n4 + n5, l5);
        } else {
            this.buffer.andWord(n4 + n5, l5 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        long l6 = l4 = bl2 ? -1L : 0L;
        if (this.buffer.getWord(n4 + n5) == l4) {
            boolean bl4 = this.mergeLiteralWordInCurrentRunningLength(bl2, bl3, l2, n5);
            boolean bl5 = this.mergeLiteralWordInNextRunningLength(bl2, l3, n4, n5);
            if (bl4 && bl5) {
                long l7 = RunningLengthWord.getRunningLength(this.buffer, n4 + 2);
                long l8 = RunningLengthWord.getNumberOfLiteralWords(this.buffer, n4 + 2);
                this.buffer.collapse(n4, 2);
                this.setRLWInfo(n4, bl2, l2 + 1L + l7, l8);
                if (this.rlw.position >= n4 + 2) {
                    this.rlw.position -= 2;
                }
            } else if (bl4) {
                this.buffer.collapse(n4 + 1, 1);
                this.setRLWInfo(n4, bl2, l2 + 1L, l3 - 1L);
                if (this.rlw.position >= n4 + 2) {
                    --this.rlw.position;
                }
            } else if (bl5) {
                int n6 = (int)((long)n4 + l3 + 1L);
                long l9 = RunningLengthWord.getRunningLength(this.buffer, n6);
                long l10 = RunningLengthWord.getNumberOfLiteralWords(this.buffer, n6);
                this.buffer.collapse(n4 + n5, 1);
                this.setRLWInfo(n4, bl3, l2, l3 - 1L);
                this.setRLWInfo(n4 + n5, bl2, l9 + 1L, l10);
                if (this.rlw.position >= n6) {
                    this.rlw.position = (int)((long)this.rlw.position - (l3 + 1L - (long)n5));
                }
            } else {
                this.setRLWInfo(n4, bl3, l2, n5 - 1);
                this.setRLWInfo(n4 + n5, bl2, 1L, l3 - (long)n5);
                if (this.rlw.position == n4) {
                    this.rlw.position += n5;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean bl2, boolean bl3, long l2, int n2) {
        return (bl2 == bl3 || l2 == 0L) && n2 == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(boolean bl2, long l2, int n2, int n3) {
        int n4 = (int)((long)n2 + l2 + 1L);
        if (l2 == (long)n3 && n4 < this.buffer.sizeInWords()) {
            long l3 = RunningLengthWord.getRunningLength(this.buffer, n4);
            boolean bl3 = RunningLengthWord.getRunningBit(this.buffer, n4);
            return bl2 == bl3 || l3 == 0L;
        }
        return false;
    }

    private void setRLWInfo(int n2, boolean bl2, long l2, long l3) {
        RunningLengthWord.setRunningBit(this.buffer, n2, bl2);
        RunningLengthWord.setRunningLength(this.buffer, n2, l2);
        RunningLengthWord.setNumberOfLiteralWords(this.buffer, n2, l3);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int n2) {
        if ((n2 + 64 - 1) / 64 > (this.sizeInBits + 64 - 1) / 64) {
            this.setSizeInBits(n2, false);
            return;
        }
        if ((n2 + 64 - 1) / 64 != (this.sizeInBits + 64 - 1) / 64) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInBits(int,boolean).");
        }
        this.sizeInBits = n2;
        int n3 = this.sizeInBits % 64;
        if (n3 == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0L) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                long l2 = this.rlw.getRunningBit() ? -1L >>> 64 - n3 : 0L;
                this.insertLiteralWord(l2);
            }
            return;
        }
        this.buffer.andLastWord(-1L >>> 64 - n3);
    }

    public boolean setSizeInBits(int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 64 != 0) {
            if (!bl2) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    n5 = n2 - this.sizeInBits;
                    n4 = this.sizeInBits % 64;
                    n3 = 64 - n4;
                    if (this.buffer.getLastWord() == 0L) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        this.buffer.removeLastWord();
                        this.sizeInBits -= n4;
                    } else if (n4 > 0) {
                        this.sizeInBits += Math.min(n5, n3);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                    this.insertLiteralWord(0L);
                }
                n5 = Math.min(64 - this.sizeInBits % 64, n2 - this.sizeInBits);
                n4 = this.sizeInBits % 64;
                long l2 = -1L >>> 64 - n5 << n4;
                this.buffer.orLastWord(l2);
                if (this.buffer.getLastWord() == -1L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += n5;
            }
        }
        this.addStreamOfEmptyWords(bl2, n2 / 64 - this.sizeInBits / 64);
        if (this.sizeInBits < n2) {
            n5 = this.distanceInWords(n2 - 1);
            if (n5 > 0) {
                this.insertLiteralWord(0L);
            }
            if (bl2) {
                n4 = n2 - this.sizeInBits;
                n3 = this.sizeInBits % 64;
                long l3 = -1L >>> 64 - n4 << n3;
                this.buffer.orLastWord(l3);
            }
            this.sizeInBits = n2;
        }
        return true;
    }

    private int distanceInWords(int n2) {
        return (n2 + 64) / 64 - (this.sizeInBits + 64 - 1) / 64;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.sizeInWords() * 8;
    }

    public static EWAHCompressedBitmap threshold(int n2, EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap();
        EWAHCompressedBitmap.thresholdWithContainer(eWAHCompressedBitmap, n2, eWAHCompressedBitmapArray);
        return eWAHCompressedBitmap;
    }

    static int maxSizeInBits(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        int n2 = 0;
        for (EWAHCompressedBitmap eWAHCompressedBitmap : eWAHCompressedBitmapArray) {
            n2 = Math.max(n2, eWAHCompressedBitmap.sizeInBits());
        }
        return n2;
    }

    public static void thresholdWithContainer(BitmapStorage bitmapStorage, int n2, EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        new RunningBitmapMerge().symmetric(new ThresholdFuncBitmap(n2), bitmapStorage, eWAHCompressedBitmapArray);
    }

    public int[] toArray() {
        int[] nArray = new int[this.cardinality()];
        int n2 = 0;
        int n3 = 0;
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        while (eWAHIterator.hasNext()) {
            int n4;
            int n5;
            RunningLengthWord runningLengthWord = eWAHIterator.next();
            long l2 = runningLengthWord.getRunningLength();
            if (runningLengthWord.getRunningBit()) {
                n5 = 0;
                while ((long)n5 < l2) {
                    for (n4 = 0; n4 < 64; ++n4) {
                        nArray[n2++] = n3++;
                    }
                    ++n5;
                }
            } else {
                n3 = (int)((long)n3 + 64L * l2);
            }
            n5 = runningLengthWord.getNumberOfLiteralWords();
            n4 = eWAHIterator.literalWords();
            for (int i2 = 0; i2 < n5; ++i2) {
                long l3;
                for (long i3 = eWAHIterator.buffer().getWord(n4 + i2); i3 != 0L; i3 ^= l3) {
                    l3 = i3 & -i3;
                    nArray[n2++] = Long.bitCount(l3 - 1L) + n3;
                }
                n3 += 64;
            }
        }
        return nArray;
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"size in bits\":");
        stringBuilder.append(this.sizeInBits).append(", \"size in words\":");
        stringBuilder.append(this.buffer.sizeInWords()).append(",");
        EWAHIterator eWAHIterator = this.getEWAHIterator();
        stringBuilder.append(" \"content\": [");
        boolean bl2 = true;
        while (eWAHIterator.hasNext()) {
            long l2;
            RunningLengthWord runningLengthWord = eWAHIterator.next();
            if (!bl2) {
                stringBuilder.append(",");
            }
            bl2 = false;
            stringBuilder.append("[");
            if (runningLengthWord.getRunningBit()) {
                stringBuilder.append(runningLengthWord.getRunningLength()).append(",").append(" \"1x11\", ");
            } else {
                stringBuilder.append(runningLengthWord.getRunningLength()).append(",").append(" \"0x00\", ");
            }
            stringBuilder.append("[");
            int n2 = 0;
            while (n2 + 1 < runningLengthWord.getNumberOfLiteralWords()) {
                l2 = eWAHIterator.buffer().getWord(eWAHIterator.literalWords() + n2);
                stringBuilder.append("\"0x").append(Long.toHexString(l2)).append("\",");
                ++n2;
            }
            if (n2 < runningLengthWord.getNumberOfLiteralWords()) {
                l2 = eWAHIterator.buffer().getWord(eWAHIterator.literalWords() + n2);
                stringBuilder.append("\"0x").append(Long.toHexString(l2)).append("\"");
            }
            stringBuilder.append("]]");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        IntIterator intIterator = this.intIterator();
        stringBuilder.append("{");
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(",");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void swap(EWAHCompressedBitmap eWAHCompressedBitmap) {
        this.buffer.swap(eWAHCompressedBitmap.buffer);
        int n2 = this.rlw.position;
        this.rlw.position = eWAHCompressedBitmap.rlw.position;
        eWAHCompressedBitmap.rlw.position = n2;
        int n3 = this.sizeInBits;
        this.sizeInBits = eWAHCompressedBitmap.sizeInBits;
        eWAHCompressedBitmap.sizeInBits = n3;
    }

    public void trim() {
        this.buffer.trim();
    }

    public EWAHCompressedBitmap xor(EWAHCompressedBitmap eWAHCompressedBitmap) {
        int n2 = this.buffer.sizeInWords() + eWAHCompressedBitmap.buffer.sizeInWords();
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        this.xorToContainer(eWAHCompressedBitmap, eWAHCompressedBitmap2);
        return eWAHCompressedBitmap2;
    }

    public void xorToContainer(EWAHCompressedBitmap eWAHCompressedBitmap, BitmapStorage bitmapStorage) {
        int n2;
        bitmapStorage.clear();
        EWAHIterator eWAHIterator = eWAHCompressedBitmap.getEWAHIterator();
        EWAHIterator eWAHIterator2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = new IteratingBufferedRunningLengthWord(eWAHIterator);
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord2 = new IteratingBufferedRunningLengthWord(eWAHIterator2);
        while (iteratingBufferedRunningLengthWord.size() > 0L && iteratingBufferedRunningLengthWord2.size() > 0L) {
            while (iteratingBufferedRunningLengthWord.getRunningLength() > 0L || iteratingBufferedRunningLengthWord2.getRunningLength() > 0L) {
                n2 = iteratingBufferedRunningLengthWord.getRunningLength() < iteratingBufferedRunningLengthWord2.getRunningLength() ? 1 : 0;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord3 = n2 != 0 ? iteratingBufferedRunningLengthWord : iteratingBufferedRunningLengthWord2;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord4 = n2 != 0 ? iteratingBufferedRunningLengthWord2 : iteratingBufferedRunningLengthWord;
                long l2 = !iteratingBufferedRunningLengthWord4.getRunningBit() ? iteratingBufferedRunningLengthWord3.discharge(bitmapStorage, iteratingBufferedRunningLengthWord4.getRunningLength()) : iteratingBufferedRunningLengthWord3.dischargeNegated(bitmapStorage, iteratingBufferedRunningLengthWord4.getRunningLength());
                bitmapStorage.addStreamOfEmptyWords(iteratingBufferedRunningLengthWord4.getRunningBit(), iteratingBufferedRunningLengthWord4.getRunningLength() - l2);
                iteratingBufferedRunningLengthWord4.discardRunningWords();
            }
            n2 = Math.min(iteratingBufferedRunningLengthWord.getNumberOfLiteralWords(), iteratingBufferedRunningLengthWord2.getNumberOfLiteralWords());
            if (n2 <= 0) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitmapStorage.addWord(iteratingBufferedRunningLengthWord.getLiteralWordAt(i2) ^ iteratingBufferedRunningLengthWord2.getLiteralWordAt(i2));
            }
            iteratingBufferedRunningLengthWord.discardLiteralWords(n2);
            iteratingBufferedRunningLengthWord2.discardLiteralWords(n2);
        }
        n2 = iteratingBufferedRunningLengthWord.size() > 0L ? 1 : 0;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord5 = n2 != 0 ? iteratingBufferedRunningLengthWord : iteratingBufferedRunningLengthWord2;
        iteratingBufferedRunningLengthWord5.discharge(bitmapStorage);
        bitmapStorage.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), eWAHCompressedBitmap.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap eWAHCompressedBitmap) {
        BitCounter bitCounter = new BitCounter();
        this.xorToContainer(eWAHCompressedBitmap, bitCounter);
        return bitCounter.getCount();
    }

    public EWAHCompressedBitmap compose(EWAHCompressedBitmap eWAHCompressedBitmap) {
        int n2 = this.buffer.sizeInWords();
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        this.composeToContainer(eWAHCompressedBitmap, eWAHCompressedBitmap2);
        return eWAHCompressedBitmap2;
    }

    public void composeToContainer(EWAHCompressedBitmap eWAHCompressedBitmap, EWAHCompressedBitmap eWAHCompressedBitmap2) {
        eWAHCompressedBitmap2.clear();
        ChunkIterator chunkIterator = this.chunkIterator();
        ChunkIterator chunkIterator2 = eWAHCompressedBitmap.chunkIterator();
        int n2 = 0;
        while (chunkIterator.hasNext() && chunkIterator2.hasNext()) {
            int n3;
            if (!chunkIterator.nextBit()) {
                n3 = chunkIterator.nextLength();
                eWAHCompressedBitmap2.setSizeInBits(n2 += n3, false);
                chunkIterator.move(n3);
                continue;
            }
            n3 = Math.min(chunkIterator.nextLength(), chunkIterator2.nextLength());
            eWAHCompressedBitmap2.setSizeInBits(n2 += n3, chunkIterator2.nextBit());
            chunkIterator.move(n3);
            chunkIterator2.move(n3);
        }
        eWAHCompressedBitmap2.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage bitmapStorage, EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (eWAHCompressedBitmapArray.length == 2) {
            eWAHCompressedBitmapArray[0].andToContainer(eWAHCompressedBitmapArray[1], bitmapStorage);
            return;
        }
        int n2 = EWAHCompressedBitmap.calculateInitialSize(eWAHCompressedBitmapArray);
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(n2);
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        eWAHCompressedBitmapArray[0].andToContainer(eWAHCompressedBitmapArray[1], eWAHCompressedBitmap);
        for (int i2 = 2; i2 < eWAHCompressedBitmapArray.length - 1; ++i2) {
            eWAHCompressedBitmap.andToContainer(eWAHCompressedBitmapArray[i2], eWAHCompressedBitmap2);
            EWAHCompressedBitmap eWAHCompressedBitmap3 = eWAHCompressedBitmap;
            eWAHCompressedBitmap = eWAHCompressedBitmap2;
            eWAHCompressedBitmap2 = eWAHCompressedBitmap3;
            eWAHCompressedBitmap2.clear();
        }
        eWAHCompressedBitmap.andToContainer(eWAHCompressedBitmapArray[eWAHCompressedBitmapArray.length - 1], bitmapStorage);
    }

    private static int calculateInitialSize(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        int n2 = 0;
        for (EWAHCompressedBitmap eWAHCompressedBitmap : eWAHCompressedBitmapArray) {
            n2 = Math.max(eWAHCompressedBitmap.buffer.sizeInWords(), n2);
        }
        return n2;
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            return eWAHCompressedBitmapArray[0];
        }
        if (eWAHCompressedBitmapArray.length == 2) {
            return eWAHCompressedBitmapArray[0].and(eWAHCompressedBitmapArray[1]);
        }
        int n2 = EWAHCompressedBitmap.calculateInitialSize(eWAHCompressedBitmapArray);
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(n2);
        EWAHCompressedBitmap eWAHCompressedBitmap2 = new EWAHCompressedBitmap(n2);
        eWAHCompressedBitmapArray[0].andToContainer(eWAHCompressedBitmapArray[1], eWAHCompressedBitmap);
        for (int i2 = 2; i2 < eWAHCompressedBitmapArray.length; ++i2) {
            eWAHCompressedBitmap.andToContainer(eWAHCompressedBitmapArray[i2], eWAHCompressedBitmap2);
            eWAHCompressedBitmap2.swap(eWAHCompressedBitmap);
            eWAHCompressedBitmap2.clear();
        }
        return eWAHCompressedBitmap;
    }

    public static int andCardinality(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            return eWAHCompressedBitmapArray[0].cardinality();
        }
        BitCounter bitCounter = new BitCounter();
        EWAHCompressedBitmap.andWithContainer(bitCounter, eWAHCompressedBitmapArray);
        return bitCounter.getCount();
    }

    public static EWAHCompressedBitmap bitmapOf(int ... nArray) {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap();
        for (int n2 : nArray) {
            eWAHCompressedBitmap.set(n2);
        }
        return eWAHCompressedBitmap;
    }

    public static void orWithContainer(BitmapStorage bitmapStorage, EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + eWAHCompressedBitmapArray.length);
        }
        FastAggregation.orToContainer(bitmapStorage, eWAHCompressedBitmapArray);
    }

    public static void xorWithContainer(BitmapStorage bitmapStorage, EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + eWAHCompressedBitmapArray.length);
        }
        FastAggregation.xorToContainer(bitmapStorage, eWAHCompressedBitmapArray);
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            return eWAHCompressedBitmapArray[0];
        }
        int n2 = EWAHCompressedBitmap.calculateInitialSize(eWAHCompressedBitmapArray);
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap((int)((double)n2 * 1.5));
        EWAHCompressedBitmap.orWithContainer(eWAHCompressedBitmap, eWAHCompressedBitmapArray);
        return eWAHCompressedBitmap;
    }

    public static EWAHCompressedBitmap xor(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            return eWAHCompressedBitmapArray[0];
        }
        int n2 = EWAHCompressedBitmap.calculateInitialSize(eWAHCompressedBitmapArray);
        int n3 = (int)((double)n2 * 1.5);
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(n3);
        EWAHCompressedBitmap.xorWithContainer(eWAHCompressedBitmap, eWAHCompressedBitmapArray);
        return eWAHCompressedBitmap;
    }

    public static int orCardinality(EWAHCompressedBitmap ... eWAHCompressedBitmapArray) {
        if (eWAHCompressedBitmapArray.length == 1) {
            return eWAHCompressedBitmapArray[0].cardinality();
        }
        BitCounter bitCounter = new BitCounter();
        EWAHCompressedBitmap.orWithContainer(bitCounter, eWAHCompressedBitmapArray);
        return bitCounter.getCount();
    }

    public EWAHCompressedBitmap shift(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative shifts unsupported at the moment.");
        }
        int n3 = this.buffer.sizeInWords();
        int n4 = n2 > 0 ? n3 + (n2 + 63) / 64 : n3;
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap(n4);
        IteratingRLW iteratingRLW = this.getIteratingRLW();
        int n5 = n2 / 64;
        int n6 = n2 % 64;
        eWAHCompressedBitmap.addStreamOfEmptyWords(false, n5);
        if (n6 == 0) {
            do {
                long l2;
                if ((l2 = iteratingRLW.getRunningLength()) > 0L) {
                    eWAHCompressedBitmap.addStreamOfEmptyWords(iteratingRLW.getRunningBit(), l2);
                }
                int n7 = iteratingRLW.getNumberOfLiteralWords();
                for (int i2 = 0; i2 < n7; ++i2) {
                    eWAHCompressedBitmap.addWord(iteratingRLW.getLiteralWordAt(i2));
                }
            } while (iteratingRLW.next());
        } else {
            boolean bl2 = (this.sizeInBits + 64 - 1) % 64 + n6 >= 64;
            long l3 = 0L;
            do {
                long l4;
                if ((l4 = iteratingRLW.getRunningLength()) > 0L) {
                    if (iteratingRLW.getRunningBit()) {
                        long l5 = l3 | -1L << n6;
                        eWAHCompressedBitmap.addWord(l5);
                        l3 = -1L >>> 64 - n6;
                    } else {
                        eWAHCompressedBitmap.addWord(l3);
                        l3 = 0L;
                    }
                    if (l4 > 1L) {
                        eWAHCompressedBitmap.addStreamOfEmptyWords(iteratingRLW.getRunningBit(), l4 - 1L);
                    }
                }
                int n8 = iteratingRLW.getNumberOfLiteralWords();
                for (int i3 = 0; i3 < n8; ++i3) {
                    long l6 = iteratingRLW.getLiteralWordAt(i3);
                    long l7 = l3 | l6 << n6;
                    eWAHCompressedBitmap.addWord(l7);
                    l3 = l6 >>> 64 - n6;
                }
            } while (iteratingRLW.next());
            if (bl2) {
                eWAHCompressedBitmap.addWord(l3);
            }
        }
        eWAHCompressedBitmap.sizeInBits = this.sizeInBits + n2;
        return eWAHCompressedBitmap;
    }
}

