/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.RunningLengthWord;

public final class BufferedRunningLengthWord
implements Cloneable {
    protected int literalWordOffset = 0;
    protected int numberOfLiteralWords;
    protected boolean runningBit;
    protected long runningLength;

    public BufferedRunningLengthWord(long l2) {
        this.numberOfLiteralWords = (int)(l2 >>> 33);
        this.runningBit = (l2 & 1L) != 0L;
        this.runningLength = (int)(l2 >>> 1 & 0xFFFFFFFFL);
    }

    public BufferedRunningLengthWord(RunningLengthWord runningLengthWord) {
        this(runningLengthWord.buffer.getWord(runningLengthWord.position));
    }

    public void discardFirstWords(long l2) {
        if (this.runningLength >= l2) {
            this.runningLength -= l2;
            return;
        }
        this.runningLength = 0L;
        this.literalWordOffset += (int)(l2 -= this.runningLength);
        this.numberOfLiteralWords -= (int)l2;
    }

    public int getNumberOfLiteralWords() {
        return this.numberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.runningBit;
    }

    public long getRunningLength() {
        return this.runningLength;
    }

    public void reset(long l2) {
        this.numberOfLiteralWords = (int)(l2 >>> 33);
        this.runningBit = (l2 & 1L) != 0L;
        this.runningLength = (int)(l2 >>> 1 & 0xFFFFFFFFL);
        this.literalWordOffset = 0;
    }

    public void reset(RunningLengthWord runningLengthWord) {
        this.reset(runningLengthWord.buffer.getWord(runningLengthWord.position));
    }

    public void setNumberOfLiteralWords(int n2) {
        this.numberOfLiteralWords = n2;
    }

    public void setRunningBit(boolean bl2) {
        this.runningBit = bl2;
    }

    public void setRunningLength(long l2) {
        this.runningLength = l2;
    }

    public long size() {
        return this.runningLength + (long)this.numberOfLiteralWords;
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public BufferedRunningLengthWord clone() {
        BufferedRunningLengthWord bufferedRunningLengthWord = (BufferedRunningLengthWord)super.clone();
        bufferedRunningLengthWord.literalWordOffset = this.literalWordOffset;
        bufferedRunningLengthWord.numberOfLiteralWords = this.numberOfLiteralWords;
        bufferedRunningLengthWord.runningBit = this.runningBit;
        bufferedRunningLengthWord.runningLength = this.runningLength;
        return bufferedRunningLengthWord;
    }
}

