/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BufferedXORIterator;
import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class BufferedORIterator
implements CloneableIterator {
    final EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    final long[] hardBitmap;
    final LinkedList ll;

    BufferedORIterator(LinkedList linkedList, int n2) {
        this.ll = linkedList;
        this.hardBitmap = new long[n2];
    }

    @Override
    public BufferedXORIterator clone() {
        BufferedXORIterator bufferedXORIterator = (BufferedXORIterator)super.clone();
        bufferedXORIterator.buffer = this.buffer.clone();
        bufferedXORIterator.hardbitmap = (long[])this.hardBitmap.clone();
        bufferedXORIterator.ll = (LinkedList)this.ll.clone();
        return bufferedXORIterator;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        long l2 = 0L;
        Iterator iterator = this.ll.iterator();
        while (iterator.hasNext()) {
            IteratingRLW iteratingRLW = (IteratingRLW)iterator.next();
            if (iteratingRLW.size() > 0L) {
                int n2 = IteratorAggregation.inplaceor(this.hardBitmap, iteratingRLW);
                if ((long)n2 <= l2) continue;
                l2 = n2;
                continue;
            }
            iterator.remove();
        }
        int n3 = 0;
        while ((long)n3 < l2) {
            this.buffer.addWord(this.hardBitmap[n3]);
            ++n3;
        }
        Arrays.fill(this.hardBitmap, 0L);
        return this.buffer.getEWAHIterator();
    }
}

