/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import java.util.Iterator;
import java.util.LinkedList;

class BufferedAndIterator
implements CloneableIterator {
    EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    LinkedList ll;
    final int bufferSize;

    public BufferedAndIterator(LinkedList linkedList, int n2) {
        this.ll = linkedList;
        this.bufferSize = n2;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public BufferedAndIterator clone() {
        BufferedAndIterator bufferedAndIterator = (BufferedAndIterator)super.clone();
        bufferedAndIterator.buffer = this.buffer.clone();
        bufferedAndIterator.ll = (LinkedList)this.ll.clone();
        return bufferedAndIterator;
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        IteratorAggregation.andToContainer(this.buffer, this.bufferSize * this.ll.size(), (IteratingRLW)this.ll.get(0), (IteratingRLW)this.ll.get(1));
        if (this.ll.size() > 2) {
            Iterator iterator = this.ll.iterator();
            iterator.next();
            iterator.next();
            Object object = new EWAHCompressedBitmap();
            while (iterator.hasNext() && this.buffer.sizeInBytes() > 0) {
                IteratorAggregation.andToContainer((BitmapStorage)object, this.buffer.getIteratingRLW(), (IteratingRLW)iterator.next());
                this.buffer.swap((EWAHCompressedBitmap)object);
                ((EWAHCompressedBitmap)object).clear();
            }
        }
        for (Object object : this.ll) {
            if (object.size() != 0L) continue;
            this.ll.clear();
            break;
        }
        return this.buffer.getEWAHIterator();
    }
}

