/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;

public final class BitCounter
implements BitmapStorage {
    private int oneBits;

    @Override
    public void addWord(long l2) {
        this.oneBits += Long.bitCount(l2);
    }

    @Override
    public void addLiteralWord(long l2) {
        this.oneBits += Long.bitCount(l2);
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.addLiteralWord(buffer.getWord(i2));
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean bl2, long l2) {
        if (bl2) {
            this.oneBits += (int)(l2 * 64L);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.addLiteralWord(buffer.getWord(i2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.oneBits = 0;
    }

    public int getCount() {
        return this.oneBits;
    }

    @Override
    public void setSizeInBitsWithinLastWord(int n2) {
    }
}

