/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$Adapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldsData;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.stream.JsonReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class ReflectiveTypeAdapterFactory$RecordAdapter
extends ReflectiveTypeAdapterFactory$Adapter {
    static final Map PRIMITIVE_DEFAULTS = ReflectiveTypeAdapterFactory$RecordAdapter.primitiveDefaults();
    private final Constructor constructor;
    private final Object[] constructorArgsDefaults;
    private final Map componentIndices = new HashMap();

    ReflectiveTypeAdapterFactory$RecordAdapter(Class clazz, ReflectiveTypeAdapterFactory$FieldsData reflectiveTypeAdapterFactory$FieldsData, boolean bl2) {
        super(reflectiveTypeAdapterFactory$FieldsData);
        this.constructor = ReflectionHelper.getCanonicalRecordConstructor(clazz);
        if (bl2) {
            ReflectiveTypeAdapterFactory.access$000(null, this.constructor);
        } else {
            ReflectionHelper.makeAccessible(this.constructor);
        }
        String[] stringArray = ReflectionHelper.getRecordComponentNames(clazz);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.componentIndices.put(stringArray[i2], i2);
        }
        Class<?>[] classArray = this.constructor.getParameterTypes();
        this.constructorArgsDefaults = new Object[classArray.length];
        for (int i3 = 0; i3 < classArray.length; ++i3) {
            this.constructorArgsDefaults[i3] = PRIMITIVE_DEFAULTS.get(classArray[i3]);
        }
    }

    private static Map primitiveDefaults() {
        HashMap<Class<Serializable>, Serializable> hashMap = new HashMap<Class<Serializable>, Serializable>();
        hashMap.put(Byte.TYPE, Byte.valueOf((byte)0));
        hashMap.put(Short.TYPE, Short.valueOf((short)0));
        hashMap.put(Integer.TYPE, Integer.valueOf(0));
        hashMap.put(Long.TYPE, Long.valueOf(0L));
        hashMap.put(Float.TYPE, Float.valueOf(0.0f));
        hashMap.put(Double.TYPE, Double.valueOf(0.0));
        hashMap.put(Character.TYPE, Character.valueOf('\u0000'));
        hashMap.put(Boolean.TYPE, Boolean.valueOf(false));
        return hashMap;
    }

    Object[] createAccumulator() {
        return (Object[])this.constructorArgsDefaults.clone();
    }

    void readField(Object[] objectArray, JsonReader jsonReader, ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField) {
        Integer n2 = (Integer)this.componentIndices.get(reflectiveTypeAdapterFactory$BoundField.fieldName);
        if (n2 == null) {
            throw new IllegalStateException("Could not find the index in the constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' for field with name '" + reflectiveTypeAdapterFactory$BoundField.fieldName + "', unable to determine which argument in the constructor the field corresponds to. This is unexpected behavior, as we expect the RecordComponents to have the same names as the fields in the Java class, and that the order of the RecordComponents is the same as the order of the canonical constructor parameters.");
        }
        reflectiveTypeAdapterFactory$BoundField.readIntoArray(jsonReader, n2, objectArray);
    }

    Object finalize(Object[] objectArray) {
        try {
            return this.constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
        }
        catch (IllegalArgumentException | InstantiationException exception) {
            throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), invocationTargetException.getCause());
        }
    }
}

