/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.ArrayList;
import java.util.Map;

final class MapTypeAdapterFactory$Adapter
extends TypeAdapter {
    private final TypeAdapter keyTypeAdapter;
    private final TypeAdapter valueTypeAdapter;
    private final ObjectConstructor constructor;
    final /* synthetic */ MapTypeAdapterFactory this$0;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, TypeAdapter typeAdapter, TypeAdapter typeAdapter2, ObjectConstructor objectConstructor) {
        this.this$0 = mapTypeAdapterFactory;
        this.keyTypeAdapter = typeAdapter;
        this.valueTypeAdapter = typeAdapter2;
        this.constructor = objectConstructor;
    }

    @Override
    public Map read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Map map = (Map)this.constructor.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                Object object = this.keyTypeAdapter.read(jsonReader);
                Object object2 = this.valueTypeAdapter.read(jsonReader);
                Object object3 = map.put(object, object2);
                if (object3 != null) {
                    throw new JsonSyntaxException("duplicate key: " + object);
                }
                jsonReader.endArray();
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                Object object;
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                Object object4 = this.keyTypeAdapter.read(jsonReader);
                Object object5 = map.put(object4, object = this.valueTypeAdapter.read(jsonReader));
                if (object5 == null) continue;
                throw new JsonSyntaxException("duplicate key: " + object4);
            }
            jsonReader.endObject();
        }
        return map;
    }

    public void write(JsonWriter jsonWriter, Map map) {
        JsonElement jsonElement;
        if (map == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!this.this$0.complexMapKeySerialization) {
            jsonWriter.beginObject();
            for (Map.Entry entry : map.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean bl2 = false;
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(map.size());
        ArrayList arrayList2 = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
            arrayList.add(jsonElement);
            arrayList2.add(entry.getValue());
            bl2 |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
        }
        if (bl2) {
            jsonWriter.beginArray();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList.get(i2), jsonWriter);
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i2));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
        } else {
            jsonWriter.beginObject();
            int n3 = arrayList.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                jsonElement = (JsonElement)arrayList.get(i3);
                jsonWriter.name(this.keyToString(jsonElement));
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i3));
            }
            jsonWriter.endObject();
        }
    }

    private String keyToString(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return String.valueOf(jsonPrimitive.getAsNumber());
            }
            if (jsonPrimitive.isBoolean()) {
                return Boolean.toString(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            throw new AssertionError();
        }
        if (jsonElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }
}

