/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.EnumTypeAdapter$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class EnumTypeAdapter
extends TypeAdapter {
    static final TypeAdapterFactory FACTORY = new EnumTypeAdapter$1();
    private final Map nameToConstant = new HashMap();
    private final Map stringToConstant = new HashMap();
    private final Map constantToName = new HashMap();

    private EnumTypeAdapter(Class clazz) {
        try {
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            int n2 = 0;
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                if (!((Field)accessibleObject).isEnumConstant()) continue;
                accessibleObjectArray[n2++] = accessibleObject;
            }
            accessibleObjectArray = Arrays.copyOf(accessibleObjectArray, n2);
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                Enum enum_ = (Enum)((Field)accessibleObject).get(null);
                String string = enum_.name();
                String string2 = enum_.toString();
                SerializedName serializedName = ((Field)accessibleObject).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string = serializedName.value();
                    for (String string3 : serializedName.alternate()) {
                        this.nameToConstant.put(string3, enum_);
                    }
                }
                this.nameToConstant.put(string, enum_);
                this.stringToConstant.put(string2, enum_);
                this.constantToName.put(enum_, string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    @Override
    public Enum read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        Enum enum_ = (Enum)this.nameToConstant.get(string);
        return enum_ == null ? (Enum)this.stringToConstant.get(string) : enum_;
    }

    public void write(JsonWriter jsonWriter, Enum enum_) {
        jsonWriter.value(enum_ == null ? null : (String)this.constantToName.get(enum_));
    }

    /* synthetic */ EnumTypeAdapter(Class clazz, EnumTypeAdapter$1 enumTypeAdapter$1) {
        this(clazz);
    }
}

