/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.DefaultDateTypeAdapter$1;
import com.google.gson.internal.bind.DefaultDateTypeAdapter$DateType;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public final class DefaultDateTypeAdapter
extends TypeAdapter {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    public static final TypeAdapterFactory DEFAULT_STYLE_FACTORY = new DefaultDateTypeAdapter$1();
    private final DefaultDateTypeAdapter$DateType dateType;
    private final List dateFormats = new ArrayList();

    private DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType dateType, String string) {
        this.dateType = Objects.requireNonNull(dateType);
        this.dateFormats.add(new SimpleDateFormat(string, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(new SimpleDateFormat(string));
        }
    }

    private DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType dateType, int n2, int n3) {
        this.dateType = Objects.requireNonNull(dateType);
        this.dateFormats.add(DateFormat.getDateTimeInstance(n2, n3, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(n2, n3));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUsDateTimeFormat(n2, n3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonWriter jsonWriter, Date date) {
        String string;
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        DateFormat dateFormat = (DateFormat)this.dateFormats.get(0);
        List list = this.dateFormats;
        synchronized (list) {
            string = dateFormat.format(date);
        }
        jsonWriter.value(string);
    }

    @Override
    public Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Date date = this.deserializeToDate(jsonReader);
        return this.dateType.deserialize(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonReader jsonReader) {
        String string = jsonReader.nextString();
        List list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                TimeZone timeZone = dateFormat.getTimeZone();
                try {
                    Date date = dateFormat.parse(string);
                    return date;
                }
                catch (ParseException parseException) {}
                continue;
                finally {
                    dateFormat.setTimeZone(timeZone);
                }
            }
        }
        try {
            return ISO8601Utils.parse(string, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    public String toString() {
        DateFormat dateFormat = (DateFormat)this.dateFormats.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)dateFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + dateFormat.getClass().getSimpleName() + ')';
    }

    /* synthetic */ DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType dateType, int n2, int n3, DefaultDateTypeAdapter$1 var4_4) {
        this(dateType, n2, n3);
    }

    /* synthetic */ DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType dateType, String string, DefaultDateTypeAdapter$1 var3_3) {
        this(dateType, string);
    }
}

