/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.Collection;

final class CollectionTypeAdapterFactory$Adapter
extends TypeAdapter {
    private final TypeAdapter elementTypeAdapter;
    private final ObjectConstructor constructor;

    public CollectionTypeAdapterFactory$Adapter(TypeAdapter typeAdapter, ObjectConstructor objectConstructor) {
        this.elementTypeAdapter = typeAdapter;
        this.constructor = objectConstructor;
    }

    @Override
    public Collection read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Collection collection = (Collection)this.constructor.construct();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            Object object = this.elementTypeAdapter.read(jsonReader);
            collection.add(object);
        }
        jsonReader.endArray();
        return collection;
    }

    public void write(JsonWriter jsonWriter, Collection collection) {
        if (collection == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        for (Object e2 : collection) {
            this.elementTypeAdapter.write(jsonWriter, e2);
        }
        jsonWriter.endArray();
    }
}

