/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ArrayTypeAdapter$1;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class ArrayTypeAdapter
extends TypeAdapter {
    public static final TypeAdapterFactory FACTORY = new ArrayTypeAdapter$1();
    private final Class componentType;
    private final TypeAdapter componentTypeAdapter;

    public ArrayTypeAdapter(Gson gson, TypeAdapter typeAdapter, Class clazz) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter, clazz);
        this.componentType = clazz;
    }

    @Override
    public Object read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            Object object = this.componentTypeAdapter.read(jsonReader);
            arrayList.add(object);
        }
        jsonReader.endArray();
        int n2 = arrayList.size();
        if (this.componentType.isPrimitive()) {
            Object object = Array.newInstance(this.componentType, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Array.set(object, i2, arrayList.get(i2));
            }
            return object;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n2);
        return arrayList.toArray(objectArray);
    }

    @Override
    public void write(JsonWriter jsonWriter, Object object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = Array.get(object, i2);
            this.componentTypeAdapter.write(jsonWriter, object2);
        }
        jsonWriter.endArray();
    }
}

