/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.internal.LinkedTreeMap$1;
import com.google.gson.internal.LinkedTreeMap$EntrySet;
import com.google.gson.internal.LinkedTreeMap$KeySet;
import com.google.gson.internal.LinkedTreeMap$Node;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class LinkedTreeMap
extends AbstractMap
implements Serializable {
    private static final Comparator NATURAL_ORDER = new LinkedTreeMap$1();
    private final Comparator comparator;
    private final boolean allowNullValues;
    LinkedTreeMap$Node root;
    int size = 0;
    int modCount = 0;
    final LinkedTreeMap$Node header;
    private LinkedTreeMap$EntrySet entrySet;
    private LinkedTreeMap$KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER, true);
    }

    public LinkedTreeMap(boolean bl2) {
        this(NATURAL_ORDER, bl2);
    }

    public LinkedTreeMap(Comparator comparator, boolean bl2) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.allowNullValues = bl2;
        this.header = new LinkedTreeMap$Node(bl2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(Object object) {
        LinkedTreeMap$Node linkedTreeMap$Node = this.findByObject(object);
        return linkedTreeMap$Node != null ? linkedTreeMap$Node.value : null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    @CanIgnoreReturnValue
    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("key == null");
        }
        if (object2 == null && !this.allowNullValues) {
            throw new NullPointerException("value == null");
        }
        LinkedTreeMap$Node linkedTreeMap$Node = this.find(object, true);
        Object object3 = linkedTreeMap$Node.value;
        linkedTreeMap$Node.value = object2;
        return object3;
    }

    @Override
    public void clear() {
        LinkedTreeMap$Node linkedTreeMap$Node;
        this.root = null;
        this.size = 0;
        ++this.modCount;
        linkedTreeMap$Node.next = linkedTreeMap$Node.prev = (linkedTreeMap$Node = this.header);
    }

    @Override
    public Object remove(Object object) {
        LinkedTreeMap$Node linkedTreeMap$Node = this.removeInternalByKey(object);
        return linkedTreeMap$Node != null ? linkedTreeMap$Node.value : null;
    }

    LinkedTreeMap$Node find(Object object, boolean bl2) {
        LinkedTreeMap$Node linkedTreeMap$Node;
        Object object2;
        Comparator comparator = this.comparator;
        LinkedTreeMap$Node linkedTreeMap$Node2 = this.root;
        int n2 = 0;
        if (linkedTreeMap$Node2 != null) {
            object2 = comparator == NATURAL_ORDER ? (Comparable)object : null;
            while (true) {
                int n3 = n2 = object2 != null ? object2.compareTo(linkedTreeMap$Node2.key) : comparator.compare(object, linkedTreeMap$Node2.key);
                if (n2 == 0) {
                    return linkedTreeMap$Node2;
                }
                LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node = n2 < 0 ? linkedTreeMap$Node2.left : linkedTreeMap$Node2.right;
                if (linkedTreeMap$Node == null) break;
                linkedTreeMap$Node2 = linkedTreeMap$Node;
            }
        }
        if (!bl2) {
            return null;
        }
        object2 = this.header;
        if (linkedTreeMap$Node2 == null) {
            if (comparator == NATURAL_ORDER && !(object instanceof Comparable)) {
                throw new ClassCastException(object.getClass().getName() + " is not Comparable");
            }
            this.root = linkedTreeMap$Node = new LinkedTreeMap$Node(this.allowNullValues, linkedTreeMap$Node2, object, (LinkedTreeMap$Node)object2, ((LinkedTreeMap$Node)object2).prev);
        } else {
            linkedTreeMap$Node = new LinkedTreeMap$Node(this.allowNullValues, linkedTreeMap$Node2, object, (LinkedTreeMap$Node)object2, ((LinkedTreeMap$Node)object2).prev);
            if (n2 < 0) {
                linkedTreeMap$Node2.left = linkedTreeMap$Node;
            } else {
                linkedTreeMap$Node2.right = linkedTreeMap$Node;
            }
            this.rebalance(linkedTreeMap$Node2, true);
        }
        ++this.size;
        ++this.modCount;
        return linkedTreeMap$Node;
    }

    LinkedTreeMap$Node findByObject(Object object) {
        try {
            return object != null ? this.find(object, false) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    LinkedTreeMap$Node findByEntry(Map.Entry entry) {
        LinkedTreeMap$Node linkedTreeMap$Node = this.findByObject(entry.getKey());
        boolean bl2 = linkedTreeMap$Node != null && LinkedTreeMap.equal(linkedTreeMap$Node.value, entry.getValue());
        return bl2 ? linkedTreeMap$Node : null;
    }

    private static boolean equal(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    void removeInternal(LinkedTreeMap$Node linkedTreeMap$Node, boolean bl2) {
        if (bl2) {
            linkedTreeMap$Node.prev.next = linkedTreeMap$Node.next;
            linkedTreeMap$Node.next.prev = linkedTreeMap$Node.prev;
        }
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node.parent;
        if (linkedTreeMap$Node2 != null && linkedTreeMap$Node3 != null) {
            LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node2.height > linkedTreeMap$Node3.height ? linkedTreeMap$Node2.last() : linkedTreeMap$Node3.first();
            this.removeInternal(linkedTreeMap$Node5, false);
            int n2 = 0;
            linkedTreeMap$Node2 = linkedTreeMap$Node.left;
            if (linkedTreeMap$Node2 != null) {
                n2 = linkedTreeMap$Node2.height;
                linkedTreeMap$Node5.left = linkedTreeMap$Node2;
                linkedTreeMap$Node2.parent = linkedTreeMap$Node5;
                linkedTreeMap$Node.left = null;
            }
            int n3 = 0;
            linkedTreeMap$Node3 = linkedTreeMap$Node.right;
            if (linkedTreeMap$Node3 != null) {
                n3 = linkedTreeMap$Node3.height;
                linkedTreeMap$Node5.right = linkedTreeMap$Node3;
                linkedTreeMap$Node3.parent = linkedTreeMap$Node5;
                linkedTreeMap$Node.right = null;
            }
            linkedTreeMap$Node5.height = Math.max(n2, n3) + 1;
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node5);
            return;
        }
        if (linkedTreeMap$Node2 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node2);
            linkedTreeMap$Node.left = null;
        } else if (linkedTreeMap$Node3 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
            linkedTreeMap$Node.right = null;
        } else {
            this.replaceInParent(linkedTreeMap$Node, null);
        }
        this.rebalance(linkedTreeMap$Node4, false);
        --this.size;
        ++this.modCount;
    }

    LinkedTreeMap$Node removeInternalByKey(Object object) {
        LinkedTreeMap$Node linkedTreeMap$Node = this.findByObject(object);
        if (linkedTreeMap$Node != null) {
            this.removeInternal(linkedTreeMap$Node, true);
        }
        return linkedTreeMap$Node;
    }

    private void replaceInParent(LinkedTreeMap$Node linkedTreeMap$Node, LinkedTreeMap$Node linkedTreeMap$Node2) {
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.parent;
        linkedTreeMap$Node.parent = null;
        if (linkedTreeMap$Node2 != null) {
            linkedTreeMap$Node2.parent = linkedTreeMap$Node3;
        }
        if (linkedTreeMap$Node3 != null) {
            if (linkedTreeMap$Node3.left == linkedTreeMap$Node) {
                linkedTreeMap$Node3.left = linkedTreeMap$Node2;
            } else {
                assert (linkedTreeMap$Node3.right == linkedTreeMap$Node);
                linkedTreeMap$Node3.right = linkedTreeMap$Node2;
            }
        } else {
            this.root = linkedTreeMap$Node2;
        }
    }

    private void rebalance(LinkedTreeMap$Node linkedTreeMap$Node, boolean bl2) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node;
        while (linkedTreeMap$Node2 != null) {
            int n2;
            LinkedTreeMap$Node linkedTreeMap$Node3;
            int n3;
            int n4;
            LinkedTreeMap$Node linkedTreeMap$Node4;
            LinkedTreeMap$Node linkedTreeMap$Node5;
            int n5;
            LinkedTreeMap$Node linkedTreeMap$Node6 = linkedTreeMap$Node2.left;
            int n6 = linkedTreeMap$Node6 != null ? linkedTreeMap$Node6.height : 0;
            int n7 = n6 - (n5 = (linkedTreeMap$Node5 = linkedTreeMap$Node2.right) != null ? linkedTreeMap$Node5.height : 0);
            if (n7 == -2) {
                linkedTreeMap$Node4 = linkedTreeMap$Node5.left;
                n4 = linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0;
                n2 = n4 - (n3 = (linkedTreeMap$Node3 = linkedTreeMap$Node5.right) != null ? linkedTreeMap$Node3.height : 0);
                if (n2 == -1 || n2 == 0 && !bl2) {
                    this.rotateLeft(linkedTreeMap$Node2);
                } else {
                    assert (n2 == 1);
                    this.rotateRight(linkedTreeMap$Node5);
                    this.rotateLeft(linkedTreeMap$Node2);
                }
                if (bl2) {
                    break;
                }
            } else if (n7 == 2) {
                linkedTreeMap$Node4 = linkedTreeMap$Node6.left;
                n4 = linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0;
                n2 = n4 - (n3 = (linkedTreeMap$Node3 = linkedTreeMap$Node6.right) != null ? linkedTreeMap$Node3.height : 0);
                if (n2 == 1 || n2 == 0 && !bl2) {
                    this.rotateRight(linkedTreeMap$Node2);
                } else {
                    assert (n2 == -1);
                    this.rotateLeft(linkedTreeMap$Node6);
                    this.rotateRight(linkedTreeMap$Node2);
                }
                if (bl2) {
                    break;
                }
            } else if (n7 == 0) {
                linkedTreeMap$Node2.height = n6 + 1;
                if (bl2) {
                    break;
                }
            } else {
                assert (n7 == -1 || n7 == 1);
                linkedTreeMap$Node2.height = Math.max(n6, n5) + 1;
                if (!bl2) break;
            }
            linkedTreeMap$Node2 = linkedTreeMap$Node2.parent;
        }
    }

    private void rotateLeft(LinkedTreeMap$Node linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node3.left;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node3.right;
        linkedTreeMap$Node.right = linkedTreeMap$Node4;
        if (linkedTreeMap$Node4 != null) {
            linkedTreeMap$Node4.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
        linkedTreeMap$Node3.left = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node3;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node2 != null ? linkedTreeMap$Node2.height : 0, linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0) + 1;
        linkedTreeMap$Node3.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
    }

    private void rotateRight(LinkedTreeMap$Node linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node3.left;
        linkedTreeMap$Node.left = linkedTreeMap$Node2 = linkedTreeMap$Node3.right;
        if (linkedTreeMap$Node2 != null) {
            linkedTreeMap$Node2.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
        linkedTreeMap$Node3.right = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node3;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0, linkedTreeMap$Node2 != null ? linkedTreeMap$Node2.height : 0) + 1;
        linkedTreeMap$Node3.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
    }

    @Override
    public Set entrySet() {
        LinkedTreeMap$EntrySet linkedTreeMap$EntrySet = this.entrySet;
        return linkedTreeMap$EntrySet != null ? linkedTreeMap$EntrySet : (this.entrySet = new LinkedTreeMap$EntrySet(this));
    }

    @Override
    public Set keySet() {
        LinkedTreeMap$KeySet linkedTreeMap$KeySet = this.keySet;
        return linkedTreeMap$KeySet != null ? linkedTreeMap$KeySet : (this.keySet = new LinkedTreeMap$KeySet(this));
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Deserialization is unsupported");
    }
}

