/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.internal.Excluder$1;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List serializationStrategies = Collections.emptyList();
    private List deserializationStrategies = Collections.emptyList();

    protected Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        excluder.version = d2;
        return excluder;
    }

    public Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        excluder.modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        excluder.serializeInnerClasses = false;
        return excluder;
    }

    public Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        excluder.requireExpose = true;
        return excluder;
    }

    public Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl2, boolean bl3) {
        Excluder excluder = this.clone();
        if (bl2) {
            excluder.serializationStrategies = new ArrayList(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl3) {
            excluder.deserializationStrategies = new ArrayList(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public TypeAdapter create(Gson gson, TypeToken typeToken) {
        Class clazz = typeToken.getRawType();
        boolean bl2 = this.excludeClass(clazz, true);
        boolean bl3 = this.excludeClass(clazz, false);
        if (!bl2 && !bl3) {
            return null;
        }
        return new Excluder$1(this, bl3, bl2, gson, typeToken);
    }

    public boolean excludeField(Field field, boolean bl2) {
        Object object;
        if ((this.modifiers & field.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field.getAnnotation(Since.class), field.getAnnotation(Until.class))) {
            return true;
        }
        if (field.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((object = field.getAnnotation(Expose.class)) == null || (bl2 ? !object.serialize() : !object.deserialize()))) {
            return true;
        }
        if (this.excludeClass(field.getType(), bl2)) {
            return true;
        }
        Object object2 = object = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!object.isEmpty()) {
            FieldAttributes fieldAttributes = new FieldAttributes(field);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ExclusionStrategy exclusionStrategy = (ExclusionStrategy)iterator.next();
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean excludeClass(Class clazz, boolean bl2) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.isInnerClass(clazz)) {
            return true;
        }
        if (!bl2 && !Enum.class.isAssignableFrom(clazz) && ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return true;
        }
        List list = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        for (ExclusionStrategy exclusionStrategy : list) {
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInnerClass(Class clazz) {
        return clazz.isMemberClass() && !ReflectionHelper.isStatic(clazz);
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        if (since != null) {
            double d2 = since.value();
            return this.version >= d2;
        }
        return true;
    }

    private boolean isValidUntil(Until until) {
        if (until != null) {
            double d2 = until.value();
            return this.version < d2;
        }
        return true;
    }
}

