/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter$FilterResult;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.TroubleshootingGuide;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ConstructorConstructor {
    private final Map instanceCreators;
    private final boolean useJdkUnsafe;
    private final List reflectionFilters;

    public ConstructorConstructor(Map map, boolean bl2, List list) {
        this.instanceCreators = map;
        this.useJdkUnsafe = bl2;
        this.reflectionFilters = list;
    }

    static String checkInstantiable(Class clazz) {
        int n2 = clazz.getModifiers();
        if (Modifier.isInterface(n2)) {
            return "Interfaces can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Interface name: " + clazz.getName();
        }
        if (Modifier.isAbstract(n2)) {
            return "Abstract classes can't be instantiated! Adjust the R8 configuration or register an InstanceCreator or a TypeAdapter for this type. Class name: " + clazz.getName() + "\nSee " + TroubleshootingGuide.createUrl("r8-abstract-class");
        }
        return null;
    }

    public ObjectConstructor get(TypeToken typeToken) {
        Type type = typeToken.getType();
        Class clazz = typeToken.getRawType();
        InstanceCreator instanceCreator = (InstanceCreator)this.instanceCreators.get(type);
        if (instanceCreator != null) {
            return () -> instanceCreator.createInstance(type);
        }
        InstanceCreator instanceCreator2 = (InstanceCreator)this.instanceCreators.get(clazz);
        if (instanceCreator2 != null) {
            return () -> instanceCreator2.createInstance(type);
        }
        ObjectConstructor objectConstructor = ConstructorConstructor.newSpecialCollectionConstructor(type, clazz);
        if (objectConstructor != null) {
            return objectConstructor;
        }
        ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
        ObjectConstructor objectConstructor2 = ConstructorConstructor.newDefaultConstructor(clazz, reflectionAccessFilter$FilterResult);
        if (objectConstructor2 != null) {
            return objectConstructor2;
        }
        ObjectConstructor objectConstructor3 = ConstructorConstructor.newDefaultImplementationConstructor(type, clazz);
        if (objectConstructor3 != null) {
            return objectConstructor3;
        }
        String string = ConstructorConstructor.checkInstantiable(clazz);
        if (string != null) {
            return () -> {
                throw new JsonIOException(string);
            };
        }
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.ALLOW) {
            return this.newUnsafeAllocator(clazz);
        }
        String string2 = "Unable to create instance of " + clazz + "; ReflectionAccessFilter does not permit using reflection or Unsafe. Register an InstanceCreator or a TypeAdapter for this type or adjust the access filter to allow using reflection.";
        return () -> {
            throw new JsonIOException(string2);
        };
    }

    private static ObjectConstructor newSpecialCollectionConstructor(Type type, Class clazz) {
        if (EnumSet.class.isAssignableFrom(clazz)) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (type2 instanceof Class) {
                        EnumSet enumSet = EnumSet.noneOf((Class)type2);
                        return enumSet;
                    }
                    throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                }
                throw new JsonIOException("Invalid EnumSet type: " + type.toString());
            };
        }
        if (clazz == EnumMap.class) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (type2 instanceof Class) {
                        EnumMap enumMap = new EnumMap((Class)type2);
                        return enumMap;
                    }
                    throw new JsonIOException("Invalid EnumMap type: " + type.toString());
                }
                throw new JsonIOException("Invalid EnumMap type: " + type.toString());
            };
        }
        return null;
    }

    private static ObjectConstructor newDefaultConstructor(Class clazz, ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult) {
        String string;
        boolean bl2;
        Constructor constructor;
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        boolean bl3 = bl2 = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.ALLOW || ReflectionAccessFilterHelper.canAccess(constructor, null) && (reflectionAccessFilter$FilterResult != ReflectionAccessFilter$FilterResult.BLOCK_ALL || Modifier.isPublic(constructor.getModifiers()));
        if (!bl2) {
            String string2 = "Unable to invoke no-args constructor of " + clazz + "; constructor is not accessible and ReflectionAccessFilter does not permit making it accessible. Register an InstanceCreator or a TypeAdapter for this type, change the visibility of the constructor or adjust the access filter.";
            return () -> {
                throw new JsonIOException(string2);
            };
        }
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.ALLOW && (string = ReflectionHelper.tryMakeAccessible(constructor)) != null) {
            return () -> {
                throw new JsonIOException(string);
            };
        }
        return () -> {
            try {
                Object t2 = constructor.newInstance(new Object[0]);
                return t2;
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(constructor) + "' with no args", instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(constructor) + "' with no args", invocationTargetException.getCause());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
        };
    }

    private static ObjectConstructor newDefaultImplementationConstructor(Type type, Class clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return () -> new TreeSet();
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return () -> new LinkedHashSet();
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return () -> new ArrayDeque();
            }
            return () -> new ArrayList();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(clazz)) {
                return () -> new ConcurrentSkipListMap();
            }
            if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                return () -> new ConcurrentHashMap();
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return () -> new TreeMap();
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return () -> new LinkedHashMap();
            }
            return () -> new LinkedTreeMap();
        }
        return null;
    }

    private ObjectConstructor newUnsafeAllocator(Class clazz) {
        if (this.useJdkUnsafe) {
            return () -> {
                try {
                    Object object = UnsafeAllocator.INSTANCE.newInstance(clazz);
                    return object;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to create instance of " + clazz + ". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.", exception);
                }
            };
        }
        String string = "Unable to create instance of " + clazz + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        if (clazz.getDeclaredConstructors().length == 0) {
            string = string + " Or adjust your R8 configuration to keep the no-args constructor of the class.";
        }
        String string2 = string;
        return () -> {
            throw new JsonIOException(string2);
        };
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

