/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.FormattingStyle;
import com.google.gson.Gson$1;
import com.google.gson.Gson$2;
import com.google.gson.Gson$3;
import com.google.gson.Gson$4;
import com.google.gson.Gson$5;
import com.google.gson.Gson$FutureTypeAdapter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DefaultDateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.NumberTypeAdapter;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.sql.SqlTypesSupport;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public final class Gson {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    static final Strictness DEFAULT_STRICTNESS = null;
    static final FormattingStyle DEFAULT_FORMATTING_STYLE = FormattingStyle.COMPACT;
    static final boolean DEFAULT_ESCAPE_HTML = true;
    static final boolean DEFAULT_SERIALIZE_NULLS = false;
    static final boolean DEFAULT_COMPLEX_MAP_KEYS = false;
    static final boolean DEFAULT_SPECIALIZE_FLOAT_VALUES = false;
    static final boolean DEFAULT_USE_JDK_UNSAFE = true;
    static final String DEFAULT_DATE_PATTERN = null;
    static final FieldNamingStrategy DEFAULT_FIELD_NAMING_STRATEGY = FieldNamingPolicy.IDENTITY;
    static final ToNumberStrategy DEFAULT_OBJECT_TO_NUMBER_STRATEGY = ToNumberPolicy.DOUBLE;
    static final ToNumberStrategy DEFAULT_NUMBER_TO_NUMBER_STRATEGY = ToNumberPolicy.LAZILY_PARSED_NUMBER;
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ThreadLocal threadLocalAdapterResults = new ThreadLocal();
    private final ConcurrentMap typeTokenCache = new ConcurrentHashMap();
    private final ConstructorConstructor constructorConstructor;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    final List factories;
    final Excluder excluder;
    final FieldNamingStrategy fieldNamingStrategy;
    final Map instanceCreators;
    final boolean serializeNulls;
    final boolean complexMapKeySerialization;
    final boolean generateNonExecutableJson;
    final boolean htmlSafe;
    final FormattingStyle formattingStyle;
    final Strictness strictness;
    final boolean serializeSpecialFloatingPointValues;
    final boolean useJdkUnsafe;
    final String datePattern;
    final int dateStyle;
    final int timeStyle;
    final LongSerializationPolicy longSerializationPolicy;
    final List builderFactories;
    final List builderHierarchyFactories;
    final ToNumberStrategy objectToNumberStrategy;
    final ToNumberStrategy numberToNumberStrategy;
    final List reflectionFilters;

    public Gson() {
        this(Excluder.DEFAULT, DEFAULT_FIELD_NAMING_STRATEGY, Collections.emptyMap(), false, false, false, true, DEFAULT_FORMATTING_STYLE, DEFAULT_STRICTNESS, false, true, LongSerializationPolicy.DEFAULT, DEFAULT_DATE_PATTERN, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), DEFAULT_OBJECT_TO_NUMBER_STRATEGY, DEFAULT_NUMBER_TO_NUMBER_STRATEGY, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map map, boolean bl2, boolean bl3, boolean bl4, boolean bl5, FormattingStyle formattingStyle, Strictness strictness, boolean bl6, boolean bl7, LongSerializationPolicy longSerializationPolicy, String string, int n2, int n3, List list, List list2, List list3, ToNumberStrategy toNumberStrategy, ToNumberStrategy toNumberStrategy2, List list4) {
        this.excluder = excluder;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.instanceCreators = map;
        this.constructorConstructor = new ConstructorConstructor(map, bl7, list4);
        this.serializeNulls = bl2;
        this.complexMapKeySerialization = bl3;
        this.generateNonExecutableJson = bl4;
        this.htmlSafe = bl5;
        this.formattingStyle = formattingStyle;
        this.strictness = strictness;
        this.serializeSpecialFloatingPointValues = bl6;
        this.useJdkUnsafe = bl7;
        this.longSerializationPolicy = longSerializationPolicy;
        this.datePattern = string;
        this.dateStyle = n2;
        this.timeStyle = n3;
        this.builderFactories = list;
        this.builderHierarchyFactories = list2;
        this.objectToNumberStrategy = toNumberStrategy;
        this.numberToNumberStrategy = toNumberStrategy2;
        this.reflectionFilters = list4;
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>();
        arrayList.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        arrayList.add(ObjectTypeAdapter.getFactory(toNumberStrategy));
        arrayList.add(excluder);
        arrayList.addAll(list3);
        arrayList.add(TypeAdapters.STRING_FACTORY);
        arrayList.add(TypeAdapters.INTEGER_FACTORY);
        arrayList.add(TypeAdapters.BOOLEAN_FACTORY);
        arrayList.add(TypeAdapters.BYTE_FACTORY);
        arrayList.add(TypeAdapters.SHORT_FACTORY);
        TypeAdapter typeAdapter = Gson.longAdapter(longSerializationPolicy);
        arrayList.add(TypeAdapters.newFactory(Long.TYPE, Long.class, typeAdapter));
        arrayList.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl6)));
        arrayList.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl6)));
        arrayList.add(NumberTypeAdapter.getFactory(toNumberStrategy2));
        arrayList.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        arrayList.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        arrayList.add(TypeAdapters.newFactory(AtomicLong.class, Gson.atomicLongAdapter(typeAdapter)));
        arrayList.add(TypeAdapters.newFactory(AtomicLongArray.class, Gson.atomicLongArrayAdapter(typeAdapter)));
        arrayList.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        arrayList.add(TypeAdapters.CHARACTER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUILDER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUFFER_FACTORY);
        arrayList.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        arrayList.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        arrayList.add(TypeAdapters.newFactory(LazilyParsedNumber.class, TypeAdapters.LAZILY_PARSED_NUMBER));
        arrayList.add(TypeAdapters.URL_FACTORY);
        arrayList.add(TypeAdapters.URI_FACTORY);
        arrayList.add(TypeAdapters.UUID_FACTORY);
        arrayList.add(TypeAdapters.CURRENCY_FACTORY);
        arrayList.add(TypeAdapters.LOCALE_FACTORY);
        arrayList.add(TypeAdapters.INET_ADDRESS_FACTORY);
        arrayList.add(TypeAdapters.BIT_SET_FACTORY);
        arrayList.add(DefaultDateTypeAdapter.DEFAULT_STYLE_FACTORY);
        arrayList.add(TypeAdapters.CALENDAR_FACTORY);
        if (SqlTypesSupport.SUPPORTS_SQL_TYPES) {
            arrayList.add(SqlTypesSupport.TIME_FACTORY);
            arrayList.add(SqlTypesSupport.DATE_FACTORY);
            arrayList.add(SqlTypesSupport.TIMESTAMP_FACTORY);
        }
        arrayList.add(ArrayTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.CLASS_FACTORY);
        arrayList.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        arrayList.add(new MapTypeAdapterFactory(this.constructorConstructor, bl3));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        arrayList.add(this.jsonAdapterFactory);
        arrayList.add(TypeAdapters.ENUM_FACTORY);
        arrayList.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder, this.jsonAdapterFactory, list4));
        this.factories = Collections.unmodifiableList(arrayList);
    }

    public GsonBuilder newBuilder() {
        return new GsonBuilder(this);
    }

    @Deprecated
    public Excluder excluder() {
        return this.excluder;
    }

    public FieldNamingStrategy fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public boolean serializeNulls() {
        return this.serializeNulls;
    }

    public boolean htmlSafe() {
        return this.htmlSafe;
    }

    private TypeAdapter doubleAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.DOUBLE;
        }
        return new Gson$1(this);
    }

    private TypeAdapter floatAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.FLOAT;
        }
        return new Gson$2(this);
    }

    static void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static TypeAdapter longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new Gson$3();
    }

    private static TypeAdapter atomicLongAdapter(TypeAdapter typeAdapter) {
        return new Gson$4(typeAdapter).nullSafe();
    }

    private static TypeAdapter atomicLongArrayAdapter(TypeAdapter typeAdapter) {
        return new Gson$5(typeAdapter).nullSafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeAdapter getAdapter(TypeToken typeToken) {
        TypeAdapter typeAdapter;
        Objects.requireNonNull(typeToken, "type must not be null");
        TypeAdapter typeAdapter2 = (TypeAdapter)this.typeTokenCache.get(typeToken);
        if (typeAdapter2 != null) {
            TypeAdapter typeAdapter3 = typeAdapter2;
            return typeAdapter3;
        }
        HashMap<TypeToken, TypeAdapter> hashMap = (HashMap<TypeToken, TypeAdapter>)this.threadLocalAdapterResults.get();
        boolean bl2 = false;
        if (hashMap == null) {
            hashMap = new HashMap<TypeToken, TypeAdapter>();
            this.threadLocalAdapterResults.set(hashMap);
            bl2 = true;
        } else {
            typeAdapter = (TypeAdapter)hashMap.get(typeToken);
            if (typeAdapter != null) {
                return typeAdapter;
            }
        }
        typeAdapter = null;
        try {
            Gson$FutureTypeAdapter gson$FutureTypeAdapter = new Gson$FutureTypeAdapter();
            hashMap.put(typeToken, gson$FutureTypeAdapter);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                typeAdapter = typeAdapterFactory.create(this, typeToken);
                if (typeAdapter == null) continue;
                gson$FutureTypeAdapter.setDelegate(typeAdapter);
                hashMap.put(typeToken, typeAdapter);
                break;
            }
        }
        finally {
            if (bl2) {
                this.threadLocalAdapterResults.remove();
            }
        }
        if (typeAdapter == null) {
            throw new IllegalArgumentException("GSON (2.12.1) cannot handle " + typeToken);
        }
        if (bl2) {
            this.typeTokenCache.putAll(hashMap);
        }
        return typeAdapter;
    }

    public TypeAdapter getAdapter(Class clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public TypeAdapter getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken typeToken) {
        Objects.requireNonNull(typeAdapterFactory, "skipPast must not be null");
        Objects.requireNonNull(typeToken, "type must not be null");
        if (this.jsonAdapterFactory.isClassJsonAdapterFactory(typeToken, typeAdapterFactory)) {
            typeAdapterFactory = this.jsonAdapterFactory;
        }
        boolean bl2 = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            TypeAdapter typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        if (bl2) {
            throw new IllegalArgumentException("GSON cannot serialize or deserialize " + typeToken);
        }
        return this.getAdapter(typeToken);
    }

    public JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(object, object.getClass());
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(object, object.getClass());
    }

    public String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, Appendable appendable) {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
        } else {
            this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
        }
    }

    public void toJson(Object object, Type type, Appendable appendable) {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(appendable));
            this.toJson(object, type, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(Object object, Type type, JsonWriter jsonWriter) {
        TypeAdapter typeAdapter = this.getAdapter(TypeToken.get(type));
        Strictness strictness = jsonWriter.getStrictness();
        if (this.strictness != null) {
            jsonWriter.setStrictness(this.strictness);
        } else if (jsonWriter.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonWriter.setStrictness(Strictness.LENIENT);
        }
        boolean bl2 = jsonWriter.isHtmlSafe();
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            typeAdapter.write(jsonWriter, object);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.12.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setStrictness(strictness);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable appendable) {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(appendable));
            this.toJson(jsonElement, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) {
        Strictness strictness = jsonWriter.getStrictness();
        boolean bl2 = jsonWriter.isHtmlSafe();
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        if (this.strictness != null) {
            jsonWriter.setStrictness(this.strictness);
        } else if (jsonWriter.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonWriter.setStrictness(Strictness.LENIENT);
        }
        try {
            Streams.write(jsonElement, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.12.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setStrictness(strictness);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public JsonWriter newJsonWriter(Writer writer) {
        if (this.generateNonExecutableJson) {
            writer.write(JSON_NON_EXECUTABLE_PREFIX);
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setFormattingStyle(this.formattingStyle);
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setStrictness(this.strictness == null ? Strictness.LEGACY_STRICT : this.strictness);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        return jsonWriter;
    }

    public JsonReader newJsonReader(Reader reader) {
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setStrictness(this.strictness == null ? Strictness.LEGACY_STRICT : this.strictness);
        return jsonReader;
    }

    public Object fromJson(String string, Class clazz) {
        Object object = this.fromJson(string, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(object);
    }

    public Object fromJson(String string, Type type) {
        return this.fromJson(string, TypeToken.get(type));
    }

    public Object fromJson(String string, TypeToken typeToken) {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        return this.fromJson((Reader)stringReader, typeToken);
    }

    public Object fromJson(Reader reader, Class clazz) {
        Object object = this.fromJson(reader, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(object);
    }

    public Object fromJson(Reader reader, Type type) {
        return this.fromJson(reader, TypeToken.get(type));
    }

    public Object fromJson(Reader reader, TypeToken typeToken) {
        JsonReader jsonReader = this.newJsonReader(reader);
        Object object = this.fromJson(jsonReader, typeToken);
        Gson.assertFullConsumption(object, jsonReader);
        return object;
    }

    public Object fromJson(JsonReader jsonReader, Type type) {
        return this.fromJson(jsonReader, TypeToken.get(type));
    }

    public Object fromJson(JsonReader jsonReader, TypeToken typeToken) {
        boolean bl2 = true;
        Strictness strictness = jsonReader.getStrictness();
        if (this.strictness != null) {
            jsonReader.setStrictness(this.strictness);
        } else if (jsonReader.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonReader.setStrictness(Strictness.LENIENT);
        }
        try {
            JsonToken jsonToken = jsonReader.peek();
            bl2 = false;
            TypeAdapter typeAdapter = this.getAdapter(typeToken);
            Object object = typeAdapter.read(jsonReader);
            return object;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                Object var6_11 = null;
                return var6_11;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.12.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonReader.setStrictness(strictness);
        }
    }

    public Object fromJson(JsonElement jsonElement, Class clazz) {
        Object object = this.fromJson(jsonElement, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(object);
    }

    public Object fromJson(JsonElement jsonElement, Type type) {
        return this.fromJson(jsonElement, TypeToken.get(type));
    }

    public Object fromJson(JsonElement jsonElement, TypeToken typeToken) {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson((JsonReader)new JsonTreeReader(jsonElement), typeToken);
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public String toString() {
        return "{serializeNulls:" + this.serializeNulls + ",factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }
}

