/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.RestUtils$1;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public abstract class RestUtils {
    public static final String CHARSET_UTF8 = ";charset=UTF-8";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final String DEFAULT_LIMIT = "25";
    public static final String DEFAULT_START = "0";
    public static final int DEFAULT_RECENT_REPOS_LIMIT = 15;
    public static final String DEFAULT_ENTITY_VERSION = "-1";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CHARSET_PREFIX = "charset=";
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("[0-9a-f]{40}", 2);
    private static final int LIMIT = Integer.parseInt("25");
    private static final int START = Integer.parseInt("0");
    private static final String OPTION_AVATAR_SIZE = "avatarSize";
    private static final String OPTION_AVATAR_SCHEME = "avatarScheme";
    private static final String OPTION_AVATAR_URL_MODE = "avatarUrlMode";
    private static final String URL_MODE_ABSOLUTE = "absolute";

    @Nullable
    public static AvatarRequest makeAvatarRequest(@Nonnull ContainerRequest containerRequest) {
        return RestUtils.makeAvatarRequest((HttpRequestContext)containerRequest);
    }

    @Nullable
    public static AvatarRequest makeAvatarRequest(@Nonnull HttpRequestContext httpRequestContext) {
        MultivaluedMap multivaluedMap = Objects.requireNonNull(httpRequestContext, "request").getQueryParameters();
        OptionalInt optionalInt = RestUtils.maybeParseInt(multivaluedMap, OPTION_AVATAR_SIZE);
        if (!optionalInt.isPresent()) {
            return null;
        }
        int n2 = optionalInt.getAsInt();
        if (n2 < 1) {
            throw new BadRequestException(OPTION_AVATAR_SIZE, "\"avatarSize\" must positive; \"" + n2 + "\" is not valid");
        }
        String string = (String)multivaluedMap.getFirst((Object)OPTION_AVATAR_SCHEME);
        boolean bl2 = StringUtils.isEmpty((CharSequence)string) ? httpRequestContext.isSecure() : "https".equalsIgnoreCase(string);
        boolean bl3 = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)((String)multivaluedMap.getFirst((Object)OPTION_AVATAR_URL_MODE))));
        return new AvatarRequest(bl2, n2, bl3);
    }

    @Nonnull
    public static AvatarRequest makeAvatarRequest(@Nonnull RequestManager requestManager, @Nonnull Map map) {
        String string;
        RequestContext requestContext = Objects.requireNonNull(requestManager, "requestManager").getRequestContext();
        Object v2 = Objects.requireNonNull(map, "options").get(OPTION_AVATAR_SIZE);
        int n2 = 64;
        if (v2 != null) {
            if (v2 instanceof Number) {
                n2 = ((Number)v2).intValue();
            } else if (v2 instanceof String) {
                try {
                    n2 = Integer.parseInt((String)v2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        boolean bl2 = (string = (String)map.get(OPTION_AVATAR_SCHEME)) != null ? "https".equals(string) : requestContext == null || requestContext.isSecure();
        boolean bl3 = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)Objects.toString(map.get(OPTION_AVATAR_URL_MODE), null)));
        return new AvatarRequest(bl2, n2, bl3);
    }

    @Nonnull
    public static PageRequest makePageRequest(@Nonnull HttpRequestContext httpRequestContext) {
        return RestUtils.makePageRequest(httpRequestContext, LIMIT);
    }

    @Nonnull
    public static PageRequest makePageRequest(@Nonnull HttpRequestContext httpRequestContext, int n2) {
        MultivaluedMap multivaluedMap = Objects.requireNonNull(httpRequestContext, "request").getQueryParameters();
        int n3 = RestUtils.maybeParseInt(multivaluedMap, "start").orElse(START);
        int n4 = RestUtils.maybeParseInt(multivaluedMap, multivaluedMap.containsKey((Object)"limit") ? "limit" : "pageSize").orElse(n2);
        return PageUtils.newRequest((int)n3, (int)n4);
    }

    @Nonnull
    public static RenderContext makeRenderContext(@Nonnull HttpRequestContext httpRequestContext) {
        MultivaluedMap multivaluedMap = Objects.requireNonNull(httpRequestContext, "request").getQueryParameters();
        return new RenderContext.Builder().hardwrap(RestUtils.parseBoolean(multivaluedMap, "hardwrap")).htmlEscape(RestUtils.parseBoolean(multivaluedMap, "htmlEscape")).includeHeadingId(RestUtils.parseBoolean(multivaluedMap, "includeHeadingId")).urlMode(RestUtils.parseUrlMode(multivaluedMap)).build();
    }

    public static boolean isImmutableObjectId(@Nullable String string) {
        return string != null && COMMIT_ID_PATTERN.matcher(string).matches();
    }

    public static boolean isImmutableBetween(@Nullable String string, @Nullable String string2) {
        return RestUtils.isImmutableObjectId(string) && (string2 == null || RestUtils.isImmutableObjectId(string2));
    }

    @Nonnull
    public static Object notFoundIfNull(@Nullable Object object) {
        if (object == null) {
            throw new NotFoundException();
        }
        return object;
    }

    @Nullable
    public static Object applyOrNull(@Nullable Object object, @Nonnull Function function) {
        if (object == null) {
            return null;
        }
        return Objects.requireNonNull(function, "function").apply(object);
    }

    public static Charset getCharset(@Nonnull ContainerRequest containerRequest, @Nullable Charset charset) {
        int n2;
        String string = StringUtils.lowerCase((String)Objects.requireNonNull(containerRequest, "request").getHeaderValue(CONTENT_TYPE));
        if (string != null && (n2 = string.indexOf(CHARSET_PREFIX)) != -1) {
            return RestUtils.getCharset(string.substring(n2 + CHARSET_PREFIX.length()), charset);
        }
        return charset;
    }

    @Nullable
    public static Object processEntities(@Nullable Object object, @Nonnull Function function) {
        Collection collection;
        Objects.requireNonNull(function, "processCallback");
        if (object instanceof JsonStreamingOutput) {
            return RestUtils.processStreamingOutput((JsonStreamingOutput)object, function);
        }
        if ((object = function.apply(object)) instanceof Page) {
            collection = ((Page)object).getValues();
        } else if (object instanceof Iterable) {
            collection = (Iterable)object;
        } else if (object instanceof RestMapEntity) {
            collection = ((RestMapEntity)object).values();
        } else {
            return object;
        }
        for (Object t2 : collection) {
            RestUtils.processEntities(t2, function);
        }
        return object;
    }

    @Nonnull
    public static Response processAvatarResponse(@Nonnull ContainerRequest containerRequest, @Nullable CacheControl cacheControl, @Nonnull CacheableAvatarSupplier cacheableAvatarSupplier) {
        Objects.requireNonNull(containerRequest, "request");
        Objects.requireNonNull(cacheableAvatarSupplier, "supplier");
        return RestUtils.doConditionalGet((Request)containerRequest, new Date(cacheableAvatarSupplier.getTimestamp()), responseBuilder -> {
            String string = cacheableAvatarSupplier.getContentType();
            if (string != null) {
                responseBuilder.variant(new Variant(MediaType.valueOf((String)string), containerRequest.getLanguage(), null));
            }
            return responseBuilder.entity(outputStream -> {
                try (InputStream inputStream = cacheableAvatarSupplier.open();){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                outputStream.flush();
            }).cacheControl(cacheControl);
        });
    }

    @Nonnull
    public static Response doConditionalGet(@Nonnull Request request, @Nonnull Date date, @Nonnull Function function) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(date, "lastUpdate");
        Objects.requireNonNull(function, "okFunction");
        Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(date);
        if (responseBuilder == null) {
            return ((Response.ResponseBuilder)function.apply(Response.ok().lastModified(date))).build();
        }
        return responseBuilder.build();
    }

    private static Charset getCharset(@Nonnull String string, @Nullable Charset charset) {
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            return charset;
        }
    }

    private static OptionalInt maybeParseInt(MultivaluedMap multivaluedMap, String string) {
        String string2 = (String)multivaluedMap.getFirst((Object)string);
        if (StringUtils.isBlank((CharSequence)string2) || "null".equalsIgnoreCase(string2) || "undefined".equalsIgnoreCase(string2)) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.valueOf(string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadRequestException(string, "\"" + string2 + "\" is not a valid value for \"" + string + "\"; the value should be numeric");
        }
    }

    private static Boolean parseBoolean(MultivaluedMap multivaluedMap, String string) {
        String string2 = (String)multivaluedMap.getFirst((Object)string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return null;
        }
        return Boolean.valueOf(string2);
    }

    private static UrlMode parseUrlMode(MultivaluedMap multivaluedMap) {
        String string = (String)multivaluedMap.getFirst((Object)"urlMode");
        if (StringUtils.isBlank((CharSequence)string)) {
            return UrlMode.RELATIVE;
        }
        try {
            return UrlMode.valueOf((String)string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadRequestException("urlMode", "\"" + string + "\" is not a valid value for \"urlMode\"; valid values are: " + ImmutableList.copyOf((Object[])UrlMode.values()));
        }
    }

    private static JsonStreamingOutput processStreamingOutput(@Nonnull JsonStreamingOutput jsonStreamingOutput, @Nonnull Function function) {
        Objects.requireNonNull(jsonStreamingOutput, "output");
        Objects.requireNonNull(function, "processCallback");
        return new RestUtils$1(jsonStreamingOutput, function);
    }
}

