(function ($) { 

	ThemePress.Events.addEventTypes("bannerWillChange bannerDidChange confluenceHeaderWillChange confluenceHeaderDidChange confluenceSidebarWillChange confluenceSidebarDidChange toolbarWillChange toolbarDidChange structureWillChange structureDidChange");

	ThemePress.Structure = {
		
		bannerCookie: "com.brikit.designer.show.banner",
		headerCookie: "com.brikit.show.header",
		
		// Adjust the header: when not visible, it needs to be just above the banner (if any) to ensure popups that point to 
		// the header aren't drawn offscreen (see PRESS-1035 for an example)
		adjustHeader: function () {
			var cssTop = ThemePress.Structure.isHeaderShowing() ? 0 : -ThemePress.Structure.confluenceHeaderHeightIncludingAdminMessages();
			ThemePress.Structure.confluenceHeader().css({top: cssTop, width: "auto"}); // PRESS-1137 - header doesn't resize with browser

			var leftMargin = ThemePress.Structure.sidebarWidth() + "px";
			ThemePress.Structure.canvas().css("margin-left", leftMargin);
			ThemePress.Structure.toolbar().css("margin-left", leftMargin);
			if (ThemePress.Structure.isConfluence59Dashboard()) $(".brikit-footer-backdrop").css("margin-left", ThemePress.Structure.confluenceSidebarDashboard().width() + "px");
			
			var sidebarTop = ThemePress.Structure.isHeaderShowing() ? ThemePress.Structure.confluenceSidebarTop() : 0;
			if (ThemePress.Structure.isBannerShowing()) sidebarTop += ThemePress.Structure.bannerHeight();

			ThemePress.Structure.confluenceSidebar().css({ top: sidebarTop });

			ThemePress.Structure.adjustHybridPageHeaders();
		},
		
		// For the oddball page collectors and view-in-hierarchy, we need to adjust the header for the sidebar
		adjustHybridPageHeaders: function () {
			// When sidebar is closed, something is causing the widths behave as if it's not. This hack 
			// resolves PRESS-1288: Menu issues on View Recent Blog Posts page 
			var sidebarOffset = ThemePress.Structure.sidebarWidth() == 0 ? 55 : ThemePress.Structure.sidebarWidth();
			ThemePress.Structure.hybridPageHeader().width(ThemePress.Structure.canvas().width() - sidebarOffset);
		},
		
		banner: function () {
			return $("#header-precursor");
		},
		
		bannerHeight: function () {
			return ThemePress.Structure.banner().outerHeight(true);
		},
		
		brikitCanvasContent: function () {
			return $("#brikit-canvas-content");
		},
		
		brikitNonPageContent: function () {
			return $("#brikit-non-page-content");
		},
		
		brikitPageContent: function () {
			return $("#brikit-page-content");
		},

		canvas: function () {
			return $(".brikit-canvas");
		},
		
		confluenceAdminMessage: function () {
			return $("#header-precursor");
		},
		
		confluenceHeader: function () {
			return $("#header");
		},
		
		confluenceHeaderHeight: function () {
			return ThemePress.Structure.confluenceHeader().outerHeight();
		},
	
		confluenceHeaderHeightIncludingAdminMessages: function () {
			return ThemePress.Structure.confluenceHeaderHeight() + 
					ThemePress.Structure.bannerHeight() +
                    ThemePress.Structure.confluenceLicenseBanner().outerHeight();
		},
	
		confluenceHeaderHidden: function () {
			return ThemePress.Structure.confluenceHeader().hasClass("hide");
		},
		
		confluenceLicenseBanner: function () {
			return $("#stp-licenseStatus-banner");
		},
	
		confluenceSidebar: function () {
			return $(".ia-fixed-sidebar");
		},
		
		confluenceSidebarDashboard: function () {
			return $(".aui-sidebar-wrapper");
		},
		
		confluenceSidebarWidth: function () {
			// Need to query the cookie because sidebar change events are sent *before* the sidebar width actually changes
			var cookie = $.cookie("confluence-sidebar.width");
            return ThemePress.Structure.isConfluence59Dashboard() ? ThemePress.Structure.confluenceSidebar().width() : AJS.storageManager('confluence', 'sidebar').getItem("width");
		},
		
		confluenceSidebarTop: function () {
			return ThemePress.Structure.confluenceHeader().outerHeight() + 
            ThemePress.Structure.confluenceLicenseBanner().outerHeight();
		},

		// If mainColumnOnly, return content blocks in the "main" columns in the layers on the page.
		// Main means the widest column. If more than one columns share the widest width, the second one is considered to be main.
		// This is actually set in mainvmd.vm's javascript to ensure it's set before the page draws (eliminates flash)
		contentBlocks: function (mainColumnOnly) {
			var scope = mainColumnOnly ? ThemePress.Structure.contentStack().find(".brikit-content-column-main") : ThemePress.Structure.contentStack();
			return $(".brikit-content-block.original", scope);
		},
	
		contentStack: function () {
			return $(".brikit-content-stack");
		},
		
		// Allow the header for logged in users only, unless explicitly set by the theme for anonymous users
		enableHeader: function () {
			if (themePressMobile) return false;
			return !ThemePress.anonymousUser() || ThemePress.allowHeaderFor == "anonymous";
		},
	
		footer: function () {
			return $(".brikit-footer");
		},
	
		header: function () {
			return $("#main-header.brikit-header");
		},
		
		headerHeight: function () {
			return ThemePress.Structure.header().outerHeight();
		},
		
		headerWidth: function () {
			return ThemePress.Structure.header().outerWidth();
		},
		
		hybridPageHeader: function () {
			return $(".brikit-header", ".view-blogposts-mode, .list-content-tree-mode, .pages-collector-mode");
		},

		isBannerShowing: function () {
			return ThemePress.Structure.banner().isShowing();
		},

		isConfluence59Dashboard: function() {
		    return $("body.dashboard").length && (ThemePress.isConfluenceVersionAtLeast("5.9"));
		},
		
		isHeaderShowing: function () {
			return !ThemePress.Structure.confluenceHeader().hasClass("hide");
		},

		isSidebarShowing: function () {
			return $(".acs-side-bar:visible").length;
		},

		// Process hot keys for working with the designer
		keyPressed: function(event) {
			var keypress = event.which;
			// console.log("which:" + event.which + " keycode:" + event.keyCode + " charCode:" + event.charCode + " shiftKey:" + event.shiftKey);

			if (event.metaKey || event.ctrlKey || event.altKey) return;				// Ignore fancy key combos
			// else if (keypress == 65) ThemePress.Structure.toggleBanner(0);		// a - toggle admin message 97-a 65-A
			// else if (keypress == 72) ThemePress.Structure.toggleConfluenceHeader(0);	// h - toggle confluence header 104-h 72-H
			// else if (keypress == 83) ThemePress.Structure.toggleConfluenceSidebar(0);	// s - toggle confluence sidebar 115-s 83-S
			else return;

			// If we got here, then we've handled the event, so stop anything else from happening
			event.stopPropagation();
	        event.preventDefault();
	        // return AJS.stopEvent(event);
		},
		
		// Deprecated: use brikitNonPageContent()
		nonPageContent: function () {
			return ThemePress.Structure.brikitNonPageContent();
		},
		
		pageMetadata: function () {
			// Need to exclude metadata coming from macros or other sources, so target the metadata in the page header only
			return $("#page-metadata-hide .page-metadata");
		},
	
		saveShowBanner: function (state) {
			ThemePress.cookie(ThemePress.Structure.bannerCookie, state);
		},
	
		saveShowHeader: function (state) {
			ThemePress.cookie(ThemePress.Structure.headerCookie, state);
		},
			
		shouldShowBanner: function () {
			return ThemePress.cookie(ThemePress.Structure.bannerCookie);
		},

		shouldShowHeader: function () {
			if (ThemePress.Browser.iphone || !ThemePress.Structure.enableHeader()) return false;
			var cookie = ThemePress.cookie(ThemePress.Structure.headerCookie);

			if ("off" == cookie) return false;
			return "on" == cookie || ThemePress.Structure.showHeaderByDefault();
		},
		
		// Allow the header for logged in users only, unless explicitly set by the theme for anonymous users
		showHeaderByDefault: function () {
			return ThemePress.anonymousUser() ? ThemePress.showHeaderByDefault == "anonymous" : ThemePress.showHeaderByDefault != "nobody";
		},
		
		sidebarChanged: function () {
			ThemePress.Structure.structureDidChange();
			ThemePress.Events.fireCallbacks(["confluenceSidebarDidChange"]);
		},
		
		sidebarWidth: function () {
			return ThemePress.Structure.isSidebarShowing() ? ThemePress.Structure.confluenceSidebarWidth() : 0;
		},
	
		structureDidChange: function () {
			ThemePress.Structure.adjustHeader();
						
			// Hide the fake title layer if all the elements are hidden
            $(".brikit-title-backdrop").hideIf($(".brikit-breadcrumbs, .brikit-page-title", ".brikit-title-container").isHidden(true));

			ThemePress.Flex.windowResized();
		},
	
		toggleBanner: function (speed) {
			if (!ThemePress.Events.fireCallbacks(["bannerWillChange", "structureWillChange"], ThemePress.Structure.banner())) return false;
			ThemePress.Structure.banner().toggle(speed, function () {
				ThemePress.Structure.saveShowBanner(ThemePress.Structure.isBannerShowing() ? "on" : null);
				ThemePress.Events.fireCallbacks(["bannerDidChange", "structureDidChange"], ThemePress.Structure.banner());
			});
		},
		
		toggleFullWidth: function (event) {
			event.preventDefault();
			var wasFullWidth = $("body").hasClass("full-width");
			$(".brikit-content-layers .brikit-content-column").each(function () {
				$(this).css("min-width", wasFullWidth ? "" : $(this).width());
			});
			$("body").toggleClass("full-width");
			ThemePress.Structure.toggleFullWidthMenuItem().toggleClass("aui")
		},
		
		toggleFullWidthMenuItem: function () {
			return $("#simpleMenuItemToggleFullWidth");
		},
		
		toggleHeader: function (event, skipSavingState) {
			if (event) event.stopPropagation();
			if (event) event.preventDefault();
			
			// When the comment or rte runs, it causes extra events to fire in rapid succession.
			// Until we figure out where to stop that, just wait a bit before firing the toggle to allow the events to flood through.
			clearTimeout(ThemePress.Structure.rteBugFix);
			ThemePress.Structure.rteBugFix = setTimeout(function () {
				ThemePress.Structure.confluenceHeader().toggleClass("hide");
				ThemePress.Structure.toolbar().toggleClass("hide");
				ThemePress.Structure.confluenceSidebar().toggleClass("hide");
				$("body").adjustClass("confluence-header-hidden", ThemePress.Structure.confluenceHeader().hasClass("hide"));
				if (!skipSavingState) ThemePress.Structure.saveShowHeader(ThemePress.Structure.confluenceHeaderHidden() ? "off" : "on");
				$(window).resize(); // Ensure the header toolbar isn't collapsed when opened
				ThemePress.Events.fireCallbacks("structureDidChange");
			}, 100);
			
			return false;
		},

		toolbar: function () {
			// Ignore the toolbar when it's in the header (which would have .header-toolbar instead of .normal)
			return $(".brikit-toolbar.normal");
		},
		
		toolbarHeight: function () {
			return ThemePress.Structure.toolbar().outerHeight();
		}
	
	};
})(jQuery);

ThemePress.toInit( function ($) {
	
	ThemePress.registerCookie(ThemePress.Structure.bannerCookie);	
	ThemePress.registerCookie(ThemePress.Structure.headerCookie);	

	// Make toolbar fit into margin from #main
	// ThemePress.Structure.toolbar().css({marginLeft: "-" + $("#main").css("paddingLeft"), marginRight: "-" + $("#main").css("paddingRight")});
	
	ThemePress.Events.addCallback("editModeDidChange", ThemePress.Structure.structureDidChange);
	ThemePress.Events.addCallback("structureDidChange", ThemePress.Structure.structureDidChange);

    ThemePress.bind("sidebar.collapsed sidebar.expanded", ThemePress.Structure.sidebarChanged);

    // Ensure the canvas size is updated when the sidebar is dragged.
    $(".ia-splitter-handle").on("mousemove.ia-splitter", ThemePress.Structure.sidebarChanged);
	
	if (ThemePress.Structure.shouldShowBanner()) ThemePress.Structure.toggleBanner(0);
	
	if (!ThemePress.Structure.isHeaderShowing() && ThemePress.Structure.shouldShowHeader()) ThemePress.Structure.toggleHeader(null, true);
	
	$(document).keypress(ThemePress.Structure.keyPressed);
});

ThemePress.toFinalize( function ($) {		
	ThemePress.Structure.structureDidChange();
	
	// PRESS-1258: Confluence header flashes when loading page and header is hidden
	$("#header-hide-on-load, .brikit-toolbar").removeAttr("style");

	// Called twice to work with both Confluence 5.5 and 5.7 (yeah, really)
	setTimeout(ThemePress.Structure.adjustHeader, 0); // PRESS-1139: Confluence 5.7 admin banners interfere with the Confluence header
	setTimeout(ThemePress.Structure.adjustHeader, 500); // PRESS-1139: Confluence 5.7 admin banners interfere with the Confluence header
});

ThemePress.toFinalize( function ($) {
	// Fix the empty "More" menu item that periodically appears
	$("#aui-responsive-header-dropdown-trigger-0").closest("li").hide();
	
	$(".brikit-toggle-header-sidebar").click(ThemePress.Structure.toggleHeader);
	
	// Adjust for the new Confluence Dashboard sidebar since we don't receive events for collapsing
	if (ThemePress.Structure.isConfluence59Dashboard()) {
		var adjustForSidebar = function () {
			ThemePress.Structure.structureDidChange();
			setTimeout(adjustForSidebar, 300);
		}
		adjustForSidebar();
	}
	
	ThemePress.Structure.toggleFullWidthMenuItem().click(ThemePress.Structure.toggleFullWidth);
});


