(function ($) {
	
	ThemePress.RichLinkHover = function ($link) {
		var self = this;

		self.link = $link.addClass("rich-link-hover-added");
		self.href = ThemePress.RichLinks.urlFromLink($link);
		self.richLink = false;
		
		self.link.hover(function (e) { self.over(e); }, function (e) { self.hide(e); });

		// For image maps, use the map as the "link" for location calculations
		if ($link.is("area")) self.link = $("#" + $link.closest("map").attr("name"));
	};
	
	var prototype = ThemePress.RichLinkHover.prototype;

	prototype.fetch = function (e) {
		var self = this;
		$.get(
			ThemePress.contextPath + "/plugins/brikit/richlinks/display.action", 
			{ url: self.href }, 
			function (response, textStatus, jqXHR) {
				self.richLink = $(response).removeClass("rich-link-wrapper").addClass("rich-link-hover");

				$("body").append(self.richLink);

				self.richLink.find(".rich-link-image").css("width", self.richLink.height());
				self.show(e);
			}
		);
	};

	prototype.hide = function (e) {
		clearTimeout(this.timeout);
		if (this.richLink) this.richLink.fadeOut();
	};
	
	prototype.over = function (e) {
		var self = this;
		self.timeout = setTimeout(function () { self.show(e); }, 1000);
	};

	prototype.show = function (e) {
		var self = this;
		
		if (!self.richLink) return self.fetch(e);
		
		var offset = self.link.offset();
		if (!offset) return console.log("no offset for " + self.link);
		var top = offset.top + self.link.outerHeight(true);
		if (top + self.richLink.height() > $(document).scrollTop() + $(window).height()) top = offset.top - self.richLink.height();
		
		var left = Math.min(offset.left, $(window).width() - self.richLink.width() - 10);

		self.richLink.css({zIndex: 20000, position: "absolute", top: top + "px", left: left + "px"});
		
		self.richLink.fadeIn("fast");
	};
	
	var initialize = function () {
		$("a:not(.rich-link):not(.rich-link-hover-added):not(.edit-content-block), area:not(.rich-link-hover-added)", ".rich-link-hovers").each(function() { 
			if ($(this).attr("href") && $(this).attr("href").length) new ThemePress.RichLinkHover($(this));
		});
	}

	ThemePress.toFinalize(initialize);
	$(document).ajaxComplete(initialize);
	
})(jQuery);

