(function ($) {
	
	BrikitMenu = function (menu) {
		this.menuHolder = $(menu);
		this.uniqueId = 1000;
		this.initialize();
	}
	
	var prototype = BrikitMenu.prototype;
	
	prototype.initialize = function () {
		var self = this;
			
		// Grab the menu panels before we start pulling apart the menu
		var $firstLayer = self.menu(".brikit-content-layer-backdrop").first();
		var $panels = self.menu(".brikit-content-layer-backdrop").not($firstLayer).remove();

		// Prune illegal levels of menus
		self.menu("li ul ul").remove();
					
		// Grab the first ul element to use as the menu
		var $menus = self.menu("ul").filter(function () { return (!$(this).parents(".brikit-menu ul").length); });
		
		// If no menus, stop
		if (!$menus.length) return;
		
		$primary = $menus.first().addClass("aui-nav");
		
		// Flag the first top menu item
		var $menuItems = $primary.find("li");
		$menuItems.first().addClass("first");
		$menuItems.last().addClass("last");
		
		// Place the ul into the menu template
		var $menu = $("#brikit-menu-template").clone().show().removeAttr("id").addClass("brikit-menu");
		if ($primary) $menu.find(".aui-navgroup-primary").append($primary);
		
		// Replace the rendered secondary menu in the DOM with the new menu
		self.menu().empty().append($menu).show();
		
		// Set up plain top-level menu items -- non-dropdown
		$("li", $primary).filter(function () { return !$("ul", this).length && !$(this).parents(".brikit-menu ul li").length; }).each( function () {
			// Make sure that plain top-level menu items get an extra class
			$(this).addClass("top-level no-dropdown");

			// Make sure that plain text top-level menu items appear as AUI links, and 
			// flag them as invalid to help user know it's the configuration, not the tool
			if (!$("a, #move-simple-toolbar", this).length && !$("a, .do-not-remove", this).length) {
				var $el = ThemePress.Menu.skipParagraph($(this));
				// If an item contains an inline comment, use it's contents for the text
				if ($el.find(".inline-comment-marker").length) $el = $el.find(".inline-comment-marker");
				$(this).html("<a href='#'>" + $el.textForElementOnly() + "</a>").addClass("invalid-top-level-menu-link");
			}
		});

		// Yank out the dropdowns and put them after the menus
		if ($primary) $($primary).find("li ul").each(function () {
			self.uniqueId += 1; 
			var id = "brikit-dropdown-" + self.uniqueId;
			
			// Give the top-level menu an extra class, and make sure it turns off menu panels triggers that are active
			var $listElement = $(this).closest(".brikit-menu li")
				.addClass("top-level has-dropdown")
				.click(function () { self.menu(".brikit-menu-panel-trigger.active").removeClass("active"); });

			// Make sure that plain text items in the dropdown menu appear as AUI links
			$("li", this).each( function () {
				if (!$("a, strong", this).length) {
					$(this).html("<a href='#'>" + $(this).text() + "</a>");
					ThemePress.Menu.markInvalidLink($(this).find("a"));
				}
			});

			var $container = $("#brikit-dropdown-template").clone().attr("id", id).addClass("brikit-secondary-menu-panel").append(this);

			// If the menu item doesn't contain a link element, wrap its text in one, add back the dropdown, 
			// and replace the original menu item with it
			if (!$("a", $listElement).length) $listElement.html("<a href='#'>" + $listElement.textForElementOnly() + "</a>");

			var $trigger = $listElement.find("a").first()
				.attr("href", id)
				.addClass("aui-dropdown2-trigger")
				.attr("aria-owns", id)
				.attr("aria-has-popup", "true");

			self.menu().append($container);
		});
		
		// Make the menu visible before wiring the menu panels so the size calculations have a chance to work
		$primary.show();
		
		// Wire up each dropdown menu panel to the menu tab with matching name
		$panels.each(function () { self.initializeMenuPanel(this); });
		$(".brikit-canvas").click(function () {
			self.menu(".brikit-menu-panel-trigger.active").removeClass("active");
			self.menu(".brikit-menu-panel").hide();
		});
		
		// Remove empty paragraph tags from menu panels (caused by some inline macros)
		self.menu(".brikit-menu-panel p").each(function () {
			if (!jQuery.trim($(this).html()).length) $(this).remove();
		});
		
		// Many any remaining non-link top-level menu items show an error panel when clicked
		self.menu(".brikit-menu .invalid-top-level-menu-link").each(function () {
			ThemePress.Menu.markInvalidLink($("a", this));
		});
	};
	
	prototype.initializeMenuPanel = function (panel) {
		var self = this;

		// Find a matching menu for the menu panel, bailing if no match found
		var $panel = $(panel);
		var panelName = $('<div>').html($panel.data("name")).text();	// PRESS-665
		var $trigger = self.menu(".top-level.no-dropdown").filter(function () {
			var name = panelName;
	        var textTitle = $.trim($("a", this).textForElementOnly());
			if (!textTitle) textTitle = $("a", this).attr("title");
			return name && textTitle && textTitle.toLowerCase() == name.toLowerCase();
		});
		if (!$trigger.length) return;
		
		$trigger.removeClass("invalid-top-level-menu-link no-dropdown").addClass("has-menu-panel").attr("data-panel-name", panelName);
		
		// Get the next unique id
		self.uniqueId += 1; 
		var id = "brikit-dropdown-" + self.uniqueId;

		// Wrap the dropdown in a div connected to the trigger
		var $menuPanel = $(".brikit-container-content", $panel);
		// Transfer any macro-generated styles from the panel to the container
		var styles = $menuPanel.attr("style");
		$menuPanel.attr("style", "");
		var $container = $("#brikit-menu-panel-template").clone()
			.attr("id", id)
			.addClass("brikit-secondary-menu-panel")
			.attr("style", styles)
			.attr("data-position", $panel.data("position"))
			.append($menuPanel);

		// Transfer the width from the layer-container
		var $sourceContainer = $(".brikit-content-layer-container", $panel);
		var containerWidth = $sourceContainer.data("width");
		if (containerWidth) {
			// Convert percentages to pixels based on width of the header
			if (containerWidth.indexOf("%") != -1) containerWidth = parseInt(containerWidth) * ThemePress.Structure.headerWidth() / 100;
			$container.width(containerWidth);
		}
		
		$("body").append($container);
		
		// Trigger the menu panel with the top-level menu item
		var $triggerLink = $trigger.find("a").first()
			.addClass("brikit-menu-panel-trigger aui-style-default")
			.attr("href", id)
			.attr("aria-owns", id)
			.attr("aria-has-popup", "true");
		
		$trigger.click(function (event) {
			event.preventDefault();
            event.stopPropagation();
            if (!$triggerLink.hasClass("active")) $(".brikit-canvas").click(); // Deactivates any previously active menu item
			$triggerLink.toggleClass("active");
			$(".brikit-menu-panel").not($container).hide();
			ThemePress.Menu.positionMenuPanel($trigger);
            $container.toggle();
		})
	};

	prototype.menu = function (selector) {
		return selector ? this.menuHolder.find(selector) : this.menuHolder;
	};

	ThemePress.toFinalize(function ($) {
		$(".brikit-secondary-menu").each(function() { new BrikitMenu(this); });
	});
	
})(jQuery);

