(function ($) {
	ThemePress.Lesson = {

		// Keep track of the current lesson plan
		currentLessonPlan: false,
		
		// Keep track of the current lesson for each lesson plan
		currentLesson: {},
		
		lastLesson: false,
		
		lessonDialog: "",	
		
		clearLesson: function (lessonPlanName) {
			ThemePress.Lesson.currentLesson[lessonPlanName] = null;
		},
		
		initializeIntroductionFrame: function(content, trigger, showPopup) {
			var lessonBody = $(".lesson-introduction").first().clone();
			lessonBody.find("input[data-copy-id]").convertDataCopyIds();
			content.css({"padding":"20px"}).html(lessonBody.show());
			
			// Wire the "don't show this again" button
			lessonBody.find("#got-it").change(function () {
				ThemePress.Lesson.lessonAutoStartCookie(this.checked ? "stop-showing" : "");
			});
			
			// Wire the start tour button
			lessonBody.find(".start-tour-button").click(function () {
				// alert(ThemePress.Lesson.currentLessonPlan);
				ThemePress.Lesson.start(ThemePress.Lesson.currentLessonPlan);
				return false;
			});
			
			showPopup();
			$(document).unbind(".lessons").bind("keydown.lessons", ThemePress.Lesson.keyPressed);
			return false;
		},
		
		initializeLessonFrame: function(content, trigger, showPopup) {

			ThemePress.Lesson.lessonBody.find(".previous-button").click(ThemePress.Lesson.reverse);
			ThemePress.Lesson.lessonBody.find(".next-button").click(ThemePress.Lesson.proceed);

			// If we're on the first step, allow user back up to the previous lesson if available
			ThemePress.Lesson.firstStep = !ThemePress.Lesson.lessonBody.find(".previous-button.first-step").length;
			ThemePress.Lesson.firstLesson = ThemePress.Lesson.lessonBody.find(".previous-button.previous-lesson").length;
			if (ThemePress.Lesson.firstLesson) {
				if (ThemePress.Lesson.previousLesson().length || ThemePress.Lesson.previousTourLink().length) {
					ThemePress.Lesson.lessonBody.attr("start-previous-tour", ThemePress.Lesson.previousLesson().data("lesson-plan"));
					ThemePress.Lesson.lessonBody.find(".previous-button.previous-lesson").show();
				}
			}

			// If we're at the last step, allow user continue to the next lesson if available
			ThemePress.Lesson.lastLesson = ThemePress.Lesson.lessonBody.find(".next-button.finish").length;
			if (ThemePress.Lesson.lastLesson) {
				if (ThemePress.Lesson.nextLesson().length || ThemePress.Lesson.nextTourLink().length) {
					ThemePress.Lesson.lessonBody.attr("start-next-tour", ThemePress.Lesson.nextLesson().data("lesson-plan"));
					ThemePress.Lesson.lessonBody.find(".next-button.next-lesson").addClass("aui-button-primary").show();
				}
				else {
					ThemePress.Lesson.lessonBody.find(".next-button.finish").addClass("aui-button-primary");
				}
			}

			ThemePress.Lesson.lessonBody.find(".close-link").click(function () { 
				ThemePress.Lesson.lessonDialog.hide(); 
				$(document).unbind(".lessons"); 
				return false;
			});
			content.css({"padding":"20px"}).html(ThemePress.Lesson.lessonBody);
			showPopup();
			$(document).unbind(".lessons").bind("keydown.lessons", ThemePress.Lesson.keyPressed);
			return false;
		},
		
		introduceLessons: function (lessonPlan) {
			
			// If a previous lesson was open, just clear it out
			if (!ThemePress.Lesson.isLessonOpen()) ThemePress.Lesson.clearLesson(lessonPlan);
			if (ThemePress.Lesson.lessonDialog) ThemePress.Lesson.lessonDialog.hide();

			ThemePress.Lesson.currentLessonPlan = lessonPlan.data("lesson-plan");

			lessonPlan.scrollToBeVisible(null, {leaveRoomAtTop: $(window).height() - 100}, function () {
				ThemePress.Lesson.lessonDialog = AJS.InlineDialog(lessonPlan.find(".lesson-button").first(), "lesson-dialog-" + new Date().getTime(),
					ThemePress.Lesson.initializeIntroductionFrame,
					{
						width: 400,
						hideDelay: null,
						fadeTime: 300,
						noBind: true,
						initCallback: function () { $(this.popup).css({zIndex: 15000}); }
					}
				);
				ThemePress.Lesson.lessonDialog.show();
			});
		},

		isLessonOpen: function () {
			return $(".lesson-frame:visible").length;
		},
		
		keyPressed: function (event) {

			// If no lesson is open, don't respond
			// If a lesson is open but another element has focus, don't advance (let the focus element handle the keypress)
			if (!ThemePress.Lesson.isLessonOpen() || $(":focus").length) return;

			var key = event.which;
			if (key == 13 || key == 39) {
				return ThemePress.Lesson.proceed(key);
			}
			else if (key == 37 && !ThemePress.Lesson.firstStep) {
				return ThemePress.Lesson.reverse(key);
			}
		},
		
		lessonAutoStartCookie: function (value) {
			ThemePress.registerCookie("brikit-lesson-auto-start");
			return ThemePress.cookie("brikit-lesson-auto-start", value);
		},

		// The lesson specification has been loaded from the server, so set up the lesson panel, including clicking
		// elements and setting state according to the spec
		lessonLoaded: function (response) {
			ThemePress.Lesson.lessonBody = $(response);
			if (!ThemePress.Lesson.lessonBody.length) return;

			if (ThemePress.Lesson.lessonDialog) ThemePress.Lesson.lessonDialog.hide();
			ThemePress.Lesson.currentLesson[ThemePress.Lesson.currentLessonPlan] = ThemePress.Lesson.lessonBody.data("lesson-name");

			// Make sure the header/toolbar is visible or not as specified
			if (ThemePress.Lesson.lessonBody.data("header") == "open" && !ThemePress.Structure.isHeaderShowing() ||
				ThemePress.Lesson.lessonBody.data("header") != "open" && ThemePress.Structure.isHeaderShowing()) ThemePress.Structure.toggleHeader(null, true);
			
			// Make sure the design mode is enabled as specified
			if (ThemePress.Lesson.lessonBody.data("edit-blocks") == "on" && !ThemePress.Edit.isEditMode() ||
				ThemePress.Lesson.lessonBody.data("edit-blocks") != "on" && ThemePress.Edit.isEditMode()) ThemePress.Edit.toggleEditMode();

			// Click the element specified in the lesson before opening lesson panel
			$(ThemePress.Lesson.lessonBody.data("click-element")).click();

			// Close or open the designer as specified in the lesson before opening lesson panel
			var designerMode = ThemePress.Lesson.lessonBody.data("designer-mode");
			var designerClose = !designerMode;
			var designerAccordion = ThemePress.Lesson.lessonBody.data("designer-accordion");
			var designerFieldset = ThemePress.Lesson.lessonBody.data("designer-fieldset");

			if (designerClose) ThemePress.Designer.closeDesigner(ThemePress.Lesson.waitForLessonTriggerThenShow);
			else if (designerMode) ThemePress.Designer.openDesigner(designerMode, designerAccordion, designerFieldset, ThemePress.Lesson.waitForLessonTriggerThenShow);
			else ThemePress.Lesson.waitForLessonTriggerThenShow();
		},

		lessonPlanCookie: function (lessonPlanName, value) {
			ThemePress.registerCookie("brikit-lesson-plan-" + lessonPlanName);
			return ThemePress.cookie("brikit-lesson-plan-" + lessonPlanName, value);
		},

		// Return the element in the DOM that represents lessonPlanName or the current lesson if not provided
		lessonPlanElement: function (lessonPlanName) {
			lessonPlanName = lessonPlanName || ThemePress.Lesson.currentLessonPlan;
			return $("[data-lesson-plan='" + lessonPlanName + "']");
		},
		
		markComplete: function (lessonPlanName) {
			$(".lesson-status-column span", ThemePress.Lesson.lessonPlanElement(lessonPlanName))
				.addClass("aui-iconfont-success")
				.closest(".lesson-status-column")
					.attr("title", "Mark incomplete")
					.unbind()
					.tooltip({aria: true})
					.click(function () {
						ThemePress.Lesson.lessonPlanCookie(lessonPlanName, null);
						ThemePress.Lesson.markIncomplete(lessonPlanName);
					});
			ThemePress.Lesson.lessonPlanCookie(lessonPlanName, "complete");
		},
		
		markIncomplete: function (lessonPlanName) {
			$("[data-lesson-plan='" + lessonPlanName + "'] .lesson-status-column span")
				.removeClass("aui-iconfont-success")
				.closest(".lesson-status-column")
					.attr("title", "Mark complete")
					.unbind()
					.tooltip({aria: true})
					.click(function () {
						ThemePress.Lesson.lessonPlanCookie(lessonPlanName, "complete");
						ThemePress.Lesson.markComplete(lessonPlanName);
					});
			ThemePress.Lesson.lessonPlanCookie(lessonPlanName, null);
		},
		
		nextLesson: function () {
			return ThemePress.Lesson.lessonPlanElement().next("[data-lesson-plan]");
		},
		
		nextTourLink: function () {
			return false && ThemePress.Lesson.lessonPlanElement().closest(".lesson-plan").find(".next-lesson-page a");
		},

		previousLesson: function () {
			return false && ThemePress.Lesson.lessonPlanElement().prev("[data-lesson-plan]");
		},
		
		previousTourLink: function () {
			return false && ThemePress.Lesson.lessonPlanElement().closest(".lesson-plan").find(".previous-lesson-page a");
		},

		proceed: function (keyPressed) {
			$(document).unbind(".lessons");

			if ($(this).hasClass("complete") || keyPressed && ThemePress.Lesson.lastLesson) {
				ThemePress.Lesson.clearLesson(ThemePress.Lesson.currentLessonPlan);
				ThemePress.Lesson.markComplete(ThemePress.Lesson.currentLessonPlan);
				ThemePress.Lesson.lessonDialog.hide();
				if ($(this).hasClass("next-lesson") || keyPressed == 39) {
					if (ThemePress.Lesson.nextLesson().length) ThemePress.Lesson.start(ThemePress.Lesson.nextLesson());
					else if (ThemePress.Lesson.nextTourLink().length) ThemePress.Lesson.nextTourLink()[0].click();
				}
			}
			else {
				ThemePress.Lesson.start(ThemePress.Lesson.currentLessonPlan, true);
			}
			return false;
		},

		reverse: function (keyPressed) {
			$(document).unbind(".lessons");

			if ($(this).hasClass("previous-lesson") || keyPressed && ThemePress.Lesson.firstLesson) {
				ThemePress.Lesson.clearLesson(ThemePress.Lesson.currentLessonPlan);
				ThemePress.Lesson.lessonDialog.hide();
				if (ThemePress.Lesson.previousLesson().length) ThemePress.Lesson.start(ThemePress.Lesson.previousLesson());
				else if (ThemePress.Lesson.previousTourLink().length) ThemePress.Lesson.previousTourLink()[0].click();
			}
			else if (!ThemePress.Lesson.firstStep){
				ThemePress.Lesson.start(ThemePress.Lesson.currentLessonPlan, false);
			}
			return false;
		},

		scrollAndShowLesson: function () {
			var selector = ThemePress.Lesson.lessonBody.data("selector");
			var $trigger = $(selector);
			if (!$trigger.length) alert("Couldn't find the element with selector: " + selector);
			if ($trigger.length > 1) console.log("Found more than one element with selector: " + selector);
			var $scrollWhat = $trigger.closest("#designer").length ? ThemePress.Designer.designerHolder() : null;
			$trigger.scrollToBeVisible($scrollWhat, {}, function () {
				ThemePress.Lesson.lessonDialog = AJS.InlineDialog($trigger, "lesson-dialog-" + new Date().getTime(),
					ThemePress.Lesson.initializeLessonFrame,
					{
						width: ThemePress.Lesson.lessonBody.data("width") || 400,
						arrowOffsetX: ThemePress.Lesson.lessonBody.data("arrow-offset-x") || 0,
						offsetX: ThemePress.Lesson.lessonBody.data("offset-x") || 0,
						offsetY: ThemePress.Lesson.lessonBody.data("offset-y") || 10,
						hideDelay: null,
						fadeTime: 300,
						noBind: true,
						initCallback: function () { $(this.popup).css({zIndex: 15000}); }
					}
				);
				ThemePress.Lesson.lessonDialog.show();
			});
		},

		start: function (lessonPlan, advance) {
			
			if (themePressMobile) return alert("Lessons aren't available in mobile view.");
			
			// Note the current lesson
			if (lessonPlan && lessonPlan.hasAttr && lessonPlan.hasAttr("data-lesson-plan")) lessonPlan = lessonPlan.data("lesson-plan");
			ThemePress.Lesson.currentLessonPlan = lessonPlan;

			// Animate/highlight the current lesson
			var lessonColumns = ThemePress.Lesson.lessonPlanElement().find("td");
			lessonColumns.css({ backgroundColor: ThemePress.html.toRGB("$lightColor") });
			setTimeout(function () { lessonColumns.css({backgroundColor: "transparent"}); }, 2500);

			// If a previous lesson was open, just clear it out
			if (!ThemePress.Lesson.isLessonOpen()) ThemePress.Lesson.clearLesson(lessonPlan);

			// Load the next lesson
			$.get(contextPath + "/plugins/brikit/lesson/next.action",
				{ key: lessonPlan, lessonName: ThemePress.Lesson.currentLesson[lessonPlan], advance: advance },
				ThemePress.Lesson.lessonLoaded
			);

			return false;
		},

		waitForLessonTriggerThenShow: function () {
			const selector = ThemePress.Lesson.lessonBody.data("selector");
            const $target = $(selector);
			if ($target.length) $target.waitFor(ThemePress.Lesson.scrollAndShowLesson);
			else {
				var msg = ThemePress.Lesson.lessonBody.data("selector-not-found-message") || 
					"<p>Apologies, but the on-screen component for this lesson (" + selector + ") is missing.</p><p>Please contact <a href='https://support.brikit.com'>Brikit support</a> to let us know.</p>";
				ThemePress.Dialog2.alert(msg, {title: "Missing Lesson Component", size: "medium"});
			}
		}

	};

	// Wire the receiver to start a lesson, calling initCallback after the lesson appears
	$.fn.enableLessonPlan = function(initCallback) {
        return this.each(function () {
			$(this).unbind("click").click(function (event) { 
				ThemePress.Lesson.start($(this).data("brikit-lesson-plan"));
				if (initCallback) initCallback.call();
				return false;
			});
	    });
	};

	ThemePress.toInit( function ($) {
		$("[data-brikit-lesson-plan]").enableLessonPlan();
	});
	
})(jQuery);

