(function ($) {

	ThemePress.Drag = {
		
		$dragging: false,
		initialized: false,
		
		ajaxDragCall: function (data) {
			ThemePress.post(contextPath + "/plugins/brikit/pages/move.action", data, ThemePress.Drag.dragUpdateResponse, "json");
		},
		
		drag: function (event, ui) {
			ThemePress.Drag.designerWasShowing = ThemePress.Designer.openState();
			if (ThemePress.Drag.designerWasShowing) ThemePress.Designer.stopDesigner(0);
			var $helper = $(ui.helper);
			ThemePress.Focus.hideFocusBlanket();
		},

		draggableBlocks: function () {
			// return $(".brikit-draggable-area .brikit-content-block");
			return ThemePress.Edit.editableBlocks();
		},
		
		draggableColumns: function () {
			return $(".brikit-draggable-area .brikit-content-column");
		},
		
		dragUpdateResponse: function (data, textStatus, jqXHR) {
			ThemePress.Drag.draggableColumns().sortable("enable");
			if (ThemePress.Drag.designerWasShowing) ThemePress.Designer.startDesigner(0);
			if (data.success) {
				// Process any element updates
				ThemePress.PageTab.designUpdateElements(data.elements);
				if (data.reload) ThemePress.Designer.forceReload();
				else {
					if (ThemePress.Drag.designerWasShowing) {
						ThemePress.Focus.updateFocusBlanket();
						ThemePress.Designer.reloadDesigner();
					}
					$(".brikit-canvas, #" + data.id).removeClass("waiting");
				}
			}
			else {
				ThemePress.Designer.forceReloadAfterAlert(data.message, { title: "Drag Error" });
			}
			
		},
		
		drop: function (event, ui) {
			var $dropped = $(ui.item);

			var $container = $dropped.closest(".brikit-content-column");
			if ($container.hasClass("from-layout")) {
				ThemePress.Dialog2.alert("<p>A block cannot be added to a column provided by the layout.</p><p>Use the Page tab in the Theme Press Designer to add the column to the page.</p>", {title: "Layout Element", size: "medium"});
				return false;
			}
			
			var $sender = $(ui.sender || $container);
			var $fromLayer = $sender.closest(".brikit-content-layer-backdrop");
			var $toLayer = $container.closest(".brikit-content-layer-backdrop");

			// Check for title below the dropped block, or labels/comments above the dropped block
			var error = false;
			if ($dropped.next("#brikit-main-column-title").length) error = "A block cannot be above the title.";
			if ($dropped.prev(".brikit-labels, .brikit-comments").length) error = "A block cannot be below labels or comments.";
			
			// Make sure the dropped block isn't above any "top" elements from the layout
			if ($dropped.next(".position-top").length) error = "A block cannot be above top-positioned blocks from the layout.";
			if ($dropped.prev(".position-bottom").length) error = "A block cannot be below bottom-positioned blocks from the layout.";

			if (error) {
				ThemePress.Dialog2.alert("<p>" + error + "</p>", {title: "Invalid Placement"});
				return false;
			}

			var $nextTo = $dropped.prev(":not(.main-column-addition):not(.position-top):not(.position-bottom)");
			var after = $nextTo.length;
			if (!after) $nextTo = $dropped.next(":not(.main-column-addition):not(.position-top):not(.position-bottom)");

			ThemePress.Drag.$dragging = $dropped;
			$dropped.addClass("waiting");
			$(".brikit-canvas").addClass("waiting");
			ThemePress.Drag.draggableColumns().sortable("disable");
			var data = {
				pageId: ThemePress.pageId,
				containerType: ThemePress.Drag.elementType($container),
				containerId: ThemePress.Drag.elementId($container),
				elementType: ThemePress.Drag.elementType($dropped),
				elementId: ThemePress.Drag.elementId($dropped),
				layerId: ThemePress.Drag.elementId($fromLayer),
				targetId: ThemePress.Drag.elementId($nextTo),
				targetLayerId: ThemePress.Drag.elementId($toLayer),
				after: after ? "true" : ""
			};
			ThemePress.Drag.ajaxDragCall(data);
		},
		
		elementId: function ($element) {
			return $element.length && $element.attr("id") ? $element.attr("id").split("-")[2] : "";
		},

		elementType: function ($element) {
			return $element.length && $element.attr("id") ? $element.attr("id").split("-")[1] : "";
		},
		
		initializeBlocks: function ($blocks) {
			$blocks
				.filter(function () { return !$(".drag-handle", this).length })
				.append("<div class='drag-handle'></div>");
		},

		toggleDragging: function () {
            if (!ThemePress.Edit.isEditMode()) return;
			if (!ThemePress.Drag.initialized) ThemePress.Drag.initializeBlocks(ThemePress.Drag.draggableBlocks());
			ThemePress.Drag.initialized = true;
		}
		
	};

	ThemePress.toInit( function ($) {
		
		if (!ThemePress.Edit.canEdit()) return;
		
		ThemePress.Drag.draggableColumns().sortable({ 
			appendTo: ".brikit-draggable-area",
			connectWith: ".brikit-draggable-area .brikit-content-column",
			cursor: "move",
			delay: 300,
			distance: 20,
			forcePlaceholderSize: true,
			grid: [10, 10],
			handle: ".drag-handle",
			// Remove the edit button because it screws up drawing in Safari (PRESS-349)
			helper: function (event, $element) { var $clone = $element.clone(); $(".edit-content-block", $clone).remove(); return $clone; },
			items: ".brikit-content-block.original",
			placeholder: "brikit-content-block sortable-placeholder",
			start: ThemePress.Drag.drag,
			stop: ThemePress.Drag.drop,
			tolerance: "pointer",
			zIndex: 20000
		});
		ThemePress.Events.addCallback("editModeDidChange pageElementChanged", ThemePress.Drag.toggleDragging);
		ThemePress.Drag.toggleDragging();
		
	});
	
})(jQuery);

