(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];
	
	// If specified, listener may implement:
	// 	spacePickerResultsLoaded(spacePicker) - called after each search results are loaded
	// 	spacePickerSpaceSelected(spacePicker, spaceKey, spaceName) - called when a user selects a space in the dropdown
	BrikitCore.SpacePicker = function (spacePicker, listener) {
		this.spacePicker = $(spacePicker);
		this.listener = listener;
		this.initialize();
		
		this.debug = false;
	};
	
	Object.assign(BrikitCore.SpacePicker.prototype, {
	
		errorOccurred: function (x, s, t) {
			console.error(x);
			var data = { error: JSON.parse(x.responseText).message };
			console.error("An error occurred: " + data.error);
			this.callback(data);
		},
	
		find: function (selector) {
			return selector ? this.spacePicker.find(selector) : this.spacePicker;
		},
		
		hideResults: function (event) {
			this.spaceResultsList.hide();
		},
		
		initialize: function () {
			this.spacePickerField = this.find(".space-picker-input-field");
			this.spaceResultsList = this.find(".space-autocomplete-list");
			
			this.spacePickerField.on("keyup", this.queueSearch.bind(this));
			this.spaceResultsList.on("click", "a", this.spaceSelected.bind(this));

			$(document).click(this.hideResults.bind(this));
		},
		
		loadResults: function (data) {

			if (this.debug) console.log("search results", data);
			
//		 <div class="aui-dropdown aui-dropdown-left">
//			 <ol></ol>
//			 <ol class="last">
//				 <li class=""><a href="#" class="label-suggestion"><span title="booking_issue"><em>booking_issue</em></span></a></li>
//			 </ol>
//		 </div>
			
			var $ol = $("<ol class='last'>");
			var $dropdown = $("<div class='aui-dropdown aui-dropdown-left'>").append($ol);
			
			if (!data.results || !data.results.length) {
				this.hideResults();
				return;
			}
			
			$(data.results).each(function (i, result) {
				if (this.debug) console.log("Found: ", result.space.name, result.space.key);
				var $a = $("<a class='space-result'>")
					.attr("href", BrikitCore.contextPath + "/display/" + result.space.key)
					.attr("data-key", result.space.key)
					.append($("<span>").text(result.space.name));
				var $li = $("<li>").append($a);
				$ol.append($li);
			}.bind(this));
			
			if (this.debug) console.log(this.spaceResultsList, $dropdown);
			this.spaceResultsList.html($dropdown);
			this.showResults();
			
			if (this.listener && this.listener.spacePickerResultsLoaded) this.listener.spacePickerResultsLoaded(this);
		},
		
		queryString: function () {
			return this.spacePickerField.val();
		},
	
		queueSearch: function () {
	        clearTimeout(this.timer);
	        this.timer = setTimeout(this.searchCriteriaChanged.bind(this), 300);
		},

		searchCriteriaChanged: function () {

			if (!this.queryString()) return this.spaceResultsList.empty();

			var data = {
				cql: 'type in (space) and siteSearch~"' + this.queryString() + '*"',
				excerpt: "none",
				// expand: "content.space,space.metadata.labels",
				start: 0,
				limit: 20
			};
			
			var cqlContext = {};
			if (TargetedSearch.spaceKey) cqlContext["spaceKey"] = TargetedSearch.spaceKey;
			if (TargetedSearch.pageId) cqlContext["contentId"] = TargetedSearch.pageId;
			data["cqlcontext"] = JSON.stringify(cqlContext);

			if (this.debug) console.log("Firing CQL search for space", data);
			if (this.debug) TargetedSearch.cqlDebugViewer().show().html(data.cql);
			$.ajax({
			    url: TargetedSearch.contextPath + "/rest/api/search",
			    data : data,
			    type: "GET",
			    success: this.loadResults.bind(this), 
				error: this.errorOccurred.bind(this),
			    dataType: "json"
			});

		},
		
		showResults: function () {
			this.spaceResultsList.show();
		},
		
		spaceSelected: function (event) {
			event.preventDefault();
			event.stopPropagation();
			
			var $selection = $(event.target).closest(".space-result");
			if (this.debug) console.log("space selected", $selection);
			
			if (this.listener && this.listener.spacePickerSpaceSelected) this.listener.spacePickerSpaceSelected(this, $selection.data("key"), $selection.text());
			
			this.hideResults();
			this.spacePickerField.val("");
		}
				
	});
	
})(jQuery);